/*
 *  Misc functions
 *  Copyright (c) by Jaroslav Kysela <perex@jcu.cz>
 */

#include "driver.h"

void snd_dma_program( int dma, const void *buf, unsigned int size, unsigned char mode )
{
  unsigned long flags;
  
  CLI( &flags );
  disable_dma( dma );
  clear_dma_ff( dma );
  set_dma_mode( dma, mode );
  set_dma_addr( dma, virt_to_bus( (void *)buf ) );
  set_dma_count( dma, size );
  enable_dma( dma );
  STI( &flags );
}

unsigned int snd_dma_residue( int dma )
{
  unsigned long flags;
  unsigned int result;
  
  CLI( &flags );
  disable_dma( dma );
  clear_dma_ff( dma );
  result = get_dma_residue( dma );
  enable_dma( dma );
  STI( &flags );
  return result;
}
