/*
 *  Main header file for the ALSA driver
 *  Copyright (c) 1994-98 by Jaroslav Kysela <perex@jcu.cz>
 */

#include "config.h"

#define COPYRIGHT \
"Copyright (c) 1994-98 by Jaroslav Kysela <perex@jcu.cz>."

#define SND_CARDS		8	/* number of supported soundcards - don't change - minor numbers */

#ifndef SNDCFG_MAJOR			/* standard configuration */
#define SNDCFG_MAJOR		14
#endif

#if !defined( SNDCFG_DEBUG )
#undef SNDCFG_DEBUG_MEMORY
#endif

/*
 *  ==========================================================================
 */

#define __KERNEL__
#define MODULE

#define LinuxVersionCode( v, p, s ) (((v)<<16)|((p)<<8)|(s))

#include <linux/config.h>
#include <linux/version.h>

#if LinuxVersionCode( 2, 0, 0 ) > LINUX_VERSION_CODE
#error "This driver is designed only for Linux 2.0.0 and highter."
#endif
#if LinuxVersionCode( 2, 1, 0 ) <= LINUX_VERSION_CODE
#define LINUX_2_1
#endif

#if defined( CONFIG_MODVERSIONS )
#define MODVERSIONS
#include <linux/modversions.h>
#endif
#ifndef SND_MAIN_OBJECT_FILE
#define __NO_VERSION__
#endif
#include <linux/module.h>

#include <linux/errno.h>
#include <linux/kernel.h>
#include <linux/sched.h>
#include <linux/malloc.h>

#include <linux/ioport.h>

#include <asm/io.h>
#include <asm/irq.h>
#include <asm/dma.h>
#include <asm/segment.h>
#ifdef LINUX_2_1
#include <asm/uaccess.h>
#endif
#include <asm/system.h>
#include <asm/string.h>

#include <linux/interrupt.h>
#include <linux/fs.h>
#include <linux/fcntl.h>
#ifdef LINUX_2_1
#include <linux/vmalloc.h>
#endif

#undef SND_POLL
#if LinuxVersionCode( 2, 1, 72 ) <= LINUX_VERSION_CODE
#define SND_POLL
#endif
#ifdef __MAX_POLL_TABLE_ENTRIES		/* new kernel with poll() */
#define SND_POLL
#endif
#ifdef SND_POLL
#include <linux/poll.h>
#endif

#if LinuxVersionCode( 2, 1, 35 ) >= LINUX_VERSION_CODE
#define in_interrupt() intr_count
#endif

#include "sound.h"
#include "sounddetect.h"

#define PRINTK printk

#define OUTB( value, reg ) outb( value, reg )
#define OUTW( value, reg ) outw( value, reg )
#define INB( reg ) inb( reg )
#define INW( reg ) inw( reg )
#define OUTSB( reg, ptr, count ) outsb( reg, ptr, count )
#define OUTSW( reg, ptr, count ) outsw( reg, ptr, count )
#define INSB( reg, ptr, count ) insb( reg, ptr, count )
#define INSW( reg, ptr, count ) insw( reg, ptr, count )
static inline void CLI( unsigned long *flags ) { save_flags( *flags ); cli(); }
static inline void STI( unsigned long *flags ) { restore_flags( *flags ); }

#define MB() 			/* 386+ architecture doesn't need io sync */

#define SLEEP_DEFINE( ident ) \
  struct wait_queue *sleeper_##ident; \
  unsigned long end_jiffies_##ident; \
  unsigned short sleeper_lock_##ident;
#define SLEEP_PREPARE( object, ident ) \
  (object) -> sleeper_##ident = NULL;
#define SLEEP( object, ident, time ) \
  (object) -> end_jiffies_##ident = current -> timeout = jiffies + (time); \
  interruptible_sleep_on( &(object) -> sleeper_##ident );
#define SLEEPU( object, ident, time ) \
  (object) -> end_jiffies_##ident = current -> timeout = jiffies + (time); \
  sleep_on( &(object) -> sleeper_##ident );
#ifdef SND_POLL
#define SLEEP_POLL( file, object, ident, table ) \
  poll_wait( file, &(object) -> sleeper_##ident, table )
#else
#define SLEEPS( object, ident, table ) \
  select_wait( &(object) -> sleeper_##ident, table );
#endif
#if LinuxVersionCode( 2, 1, 71 ) <= LINUX_VERSION_CODE
  #define TABORT( object, ident ) \
    ( signal_pending( current ) )
#else
  #define TABORT( object, ident ) \
    ( current -> signal & ~current -> blocked )
#endif
#define WAKEUP( object, ident ) wake_up( &(object) -> sleeper_##ident );
#define GETLOCK( object, ident ) (object) -> sleeper_lock_##ident
#define TIMEOUT( object, ident ) ( (object) -> end_jiffies_##ident < jiffies )
#define TIMEOUT_VALUE( object, ident ) ( (object) -> end_jiffies_##ident - jiffies )
#define MUTEX_DEFINE( ident ) \
  struct semaphore mutex_##ident;
#define MUTEX_PREPARE( object, ident ) \
  (object) -> mutex_##ident = MUTEX;
#define MUTEX_DOWN( object, ident ) down( &(object) -> mutex_##ident )
#define MUTEX_UP( object, ident ) up( &(object) -> mutex_##ident )
#define MUTEX_DEFINE_STATIC( ident ) \
  static struct semaphore local_mutex_##ident = MUTEX;
#define MUTEX_DOWN_STATIC( ident ) down( &local_mutex_##ident )
#define MUTEX_UP_STATIC( ident ) up( &local_mutex_##ident )

#define VERIFY_AREA verify_area

#define MEMCPY memcpy
#define MEMSET memset
#define MEMMOVE memmove

#ifdef LINUX_2_1
#define MEMCPY_FROMFS copy_from_user
#define MEMCPY_TOFS copy_to_user
#else
#define MEMCPY_FROMFS memcpy_fromfs
#define MEMCPY_TOFS memcpy_tofs
#endif

#define VMALLOC vmalloc
#define VFREE vfree

#ifdef LINUX_2_1

static inline void put_fs_byte( unsigned char val, char *ptr ) { put_user( val, ptr ); }
static inline void put_fs_word( unsigned short val, short *ptr ) { put_user( val, ptr ); }
static inline unsigned char get_fs_byte( unsigned char *ptr ) { unsigned char val; get_user( val, ptr ); return val; }
static inline unsigned short get_fs_word( unsigned short *ptr ) { unsigned short val; get_user( val, ptr ); return val; }

#else

#define get_fs_int		get_fs_long
#define put_fs_int		put_fs_long

#endif

#define SND_IOCTL_IN( arg )	snd_ioctl_in( (long *)arg )
#define SND_IOCTL_OUT( arg, val ) snd_ioctl_out( (long *)arg, val )

#define SND_SA_FLAGS		(SA_INTERRUPT)
#define snd_request_irq	request_irq
#define snd_free_irq		free_irq

#ifndef DMA_MODE_AUTOINIT
#define DMA_MODE_AUTOINIT	0x10
#endif

/*
 *  ==========================================================================
 */

#include "misc.h"

#define SNDSTAT_STRING \
"Sound driver - compatibility text for gmod : 3.0\n"

/*
 *  MINOR numbers
 */

#define SND_MINOR_OSS_MIXER	0	/* /dev/mixer - OSS 3.XX compatible */
#define SND_MINOR_OSS_SEQUENCER	1	/* /dev/sequencer - OSS 3.XX compatible */
#define	SND_MINOR_OSS_MIDI	2	/* /dev/midi - native midi interface - OSS 3.XX compatible - UART */
#define SND_MINOR_OSS_PCM_8	3	/* /dev/dsp - 8bit PCM - OSS 3.XX compatible */
#define SND_MINOR_OSS_AUDIO	4	/* /dev/audio - SunSparc compatible */
#define SND_MINOR_OSS_PCM_16	5	/* /dev/dsp16 - 16bit PCM - OSS 3.XX compatible */
#define SND_MINOR_OSS_SNDSTAT	6	/* /dev/sndstat - for compatibility with OSS */
#define SND_MINOR_OSS_RESERVED7	7	/* reserved for future use */
#define SND_MINOR_OSS_MUSIC	8	/* /dev/music - OSS 3.XX compatible */
#define SND_MINOR_OSS_DMMIDI	9	/* /dev/dmmidi0 - this device can have another minor # with OSS */
#define SND_MINOR_OSS_DMFM	10	/* /dev/dmfm0 - this device can have another minor # with OSS */
#define SND_MINOR_OSS_MIXER1	11	/* alternate mixer */
#define SND_MINOR_OSS_PCM1	12	/* alternate PCM (GF-A-1) */
#define SND_MINOR_OSS_MIDI1	13	/* alternate midi - SYNTH */
#define SND_MINOR_OSS_DMMIDI1	14	/* alternate dmmidi - SYNTH */

#define SND_MINOR_OSS_MASK	0x000f

#define SND_MINOR_BEGIN		128
/* global (not per soundcard) devices */
#define SND_MINOR_INFO		/* 128 */ (SND_MINOR_BEGIN+0)
#define SND_MINOR_DETECT	/* 129 */ (SND_MINOR_BEGIN+1)
#define SND_MINOR_MIDI		/* 136 */ (SND_MINOR_BEGIN+8)
#define SND_MINOR_MIDIS		8
/* local (per soundcard) devices */
#define SND_MINOR_CONTROL	/* 144 */ (SND_MINOR_BEGIN+16)
#define SND_MINOR_MIXER		/* 152 */ (SND_MINOR_CONTROL+SND_CARDS)
#define SND_MINOR_MIXERS	2
#define SND_MINOR_PCM		/* 168 */ (SND_MINOR_MIXER+(SND_CARDS*SND_MINOR_MIXERS))
#define SND_MINOR_PCMS		4
#define SND_MINOR_RAWMIDI	/* 200 */ (SND_MINOR_PCM+(SND_CARDS*SND_MINOR_PCMS))
#define SND_MINOR_RAWMIDIS	4
#define SND_MINOR_SYNTH		/* 232 */ (SND_MINOR_RAWMIDI+(SND_CARDS*SND_MINOR_RAWMIDIS))
#define SND_MINOR_SERVER	/* 240 */ (SND_MINOR_SYNTH+SND_CARDS)
#define SND_MINOR_FM		/* 248 */ (SND_MINOR_SYNTH+SND_CARDS)

/* auto values */

#define SND_AUTO_PORT		0x100
#define SND_AUTO_IRQ		16
#define SND_AUTO_DMA		8
#define SND_AUTO_DMA_SIZE	(0x7fffffff)

#define SND_DMA_DISABLE		0xffff

/* sleep & wakeup state */

#define SND_WK_NONE		0x00
#define SND_WK_LOCK		0x01	/* lock this DMA channel */
#define SND_WK_WAKEUP		0x02	/* DMA transfer done */
#define SND_WK_SLEEP		0x04	/* DMA sleep */

/* kernel / user space */

#define SND_SP_KERNEL		0x00
#define SND_SP_USER		0x01
#define SND_SP_KERNEL_WAVE_USER	0x02	/* special for OSS Sequencer */

/* Hardware resources allocation */

#define SND_DMAS	4	/* max DMA # for soundcard */
#define SND_IRQS	4	/* max IRQ # for soundcard */
#define SND_PORTS	8	/* max PORT regions for soundcard */

struct snd_stru_dma {
  volatile unsigned short
  		static_alloc: 1, /* pre-allocated */
  		mmaped: 1,	/* mmaped area */
  		lock: 1;	/* channel is locked */
  volatile short used;		/* dma channel is used (count) */
  int dma;			/* DMA number */
  char *name;			/* pointer to name */
  unsigned char *buf;		/* pointer to DMA buffer */
  long size;			/* real size of DMA buffer */
  long rsize;			/* requested size of DMA buffer */
  long usize;			/* used size of DMA buffer */
  long ursize;			/* used requested size of DMA buffer */
  char *owner;			/* owner of this DMA channel */
  char *old_owner;		/* old owner of this DMA channel */
  struct vm_area_struct *vma;	/* virtual memory area */
};

struct snd_stru_irq {
  unsigned short irq;
  char *name;
  void *dev_id;
};

struct snd_stru_port {
  unsigned short port;
  unsigned short size;
  char *name;
};

typedef void (snd_irq_handler_t)( int irq, void *dev_id, struct pt_regs *regs );

/* main structure for soundcard */

struct snd_stru_card {
  int number;			/* number of soundcard (index to snd_cards) */

  unsigned int type;		/* type (number ID) of soundcard */

  char id[ 8 ];			/* id string of this card */
  char name[ 80 ];		/* name of this soundcard */

  struct snd_stru_dma *dmas[ SND_DMAS ];
  volatile unsigned int dmas_map; /* bitmask for allocated DMA channels */
  
  struct snd_stru_irq *irqs[ SND_IRQS ];
  volatile unsigned int irqs_map; /* bitmask for allocated IRQ channels */

  struct snd_stru_port *ports[ SND_PORTS ];
  volatile unsigned int ports_map; /* bitmask for allocated port numbers */

  void (*use_inc)( void );	/* increment use count */
  void (*use_dec)( void );	/* decrement use count */

  MUTEX_DEFINE( control );	/* control card mutex */
  
  void *private;		/* private structure for soundcard */
  void (*private_free)( void *private ); /* callback for freeing of private structure */
};

typedef struct snd_stru_card snd_card_t;

/* buffer for informations */

struct snd_info_buffer {
  char *buffer;
  char *curr;
  unsigned long size;
  int stop;
};

typedef struct snd_info_buffer snd_info_buffer_t;

/* device.c */

typedef int (snd_unregister_t)( unsigned short minor );

typedef long long (snd_lseek_t)( struct file *file, long long offset, int orig );
typedef long (snd_read_t)( struct file *file, char *buf, long count );
typedef long (snd_write_t)( struct file *file, const char *buf, long count );
typedef int (snd_open_t)( unsigned short minor, int cardnum, int device, struct file *file );
typedef int (snd_release_t)( unsigned short minor, int cardnum, int device, struct file *file );
#ifdef SND_POLL
typedef unsigned int (snd_poll_t)( struct file *file, poll_table *wait );
#else
typedef int (snd_select_t)( struct file *file, int sel_type, select_table *wait );
#endif
typedef int (snd_ioctl_t)( struct file *file, unsigned int cmd, unsigned long arg );
typedef int (snd_mmap_t)( struct inode *inode, struct file *file, struct vm_area_struct *vma );

struct snd_stru_minor {
  char *comment;		/* for /dev/sndinfo */

  snd_unregister_t *unregister;

  snd_lseek_t *lseek;
  snd_read_t *read;
  snd_write_t *write;
  snd_open_t *open;
  snd_release_t *release;
#ifdef SND_POLL
  snd_poll_t *poll;
#else
  snd_select_t *select;
#endif
  snd_ioctl_t *ioctl;
  snd_mmap_t *mmap;
};

typedef struct snd_stru_minor snd_minor_t;

extern int snd_cards_limit;

extern int snd_register_minor( unsigned short minor, snd_minor_t *reg );
extern int snd_unregister_minor( unsigned short minor );

extern void snd_minor_info( snd_info_buffer_t *buffer );

extern int snd_ioctl_in( long *addr );
extern int snd_ioctl_out( long *addr, int value );

/* memory.c */

extern void snd_malloc_init( void );
extern void snd_malloc_done( void );
extern void *snd_malloc( unsigned long size );
extern void snd_free( void *obj, unsigned long size );
extern char *snd_malloc_strdup( char *string, int space );
extern void snd_free_str( char *string );
extern char *snd_malloc_pages( unsigned long size, int *pg, int dma );
extern void snd_free_pages( char *ptr, unsigned long size );
extern int snd_dma_malloc( snd_card_t *card, int dmanum, char *owner, int lock );
extern void snd_dma_free( snd_card_t *card, int dmanum, int lock );
extern void snd_dma_notify_vma_close( struct vm_area_struct *area );
extern void snd_memory_info( snd_info_buffer_t *buffer );
#ifdef SNDCFG_DEBUG_MEMORY
extern void snd_memory_debug( snd_info_buffer_t *buffer );
#endif

/* init.c */

extern int snd_cards_count;
extern unsigned int snd_cards_bitmap;
extern snd_card_t *snd_cards[ SND_CARDS ];

extern void snd_driver_init( void );

extern snd_card_t *snd_card_new( int idx, char *id, char *name, void (*use_inc)( void ), void (*use_dec)( void ) );
extern int snd_card_free( snd_card_t *card );
extern int snd_card_register( snd_card_t *card );
extern int snd_card_unregister( snd_card_t *card );
extern char *snd_get_id( snd_card_t *card, char *id );
extern void snd_info_card( snd_info_buffer_t *buffer );

extern void snd_delay( int loops );

extern int snd_register_ioport( snd_card_t *card, int port, int size, char *name );
extern int snd_unregister_ioports( snd_card_t *card );

extern int snd_register_dma_channel( snd_card_t *card, char *name, int number, int rsize, int *possible_numbers );
extern int snd_unregister_dma_channels( snd_card_t *card );

extern int snd_register_interrupt( snd_card_t *card, char *name, int number, snd_irq_handler_t *handler, void *dev_id, int *possible_number );
extern int snd_unregister_interrupts( snd_card_t *card );

static inline void snd_enable_irq( snd_card_t *card, int irqnum )
{
  enable_irq( card -> irqs[ irqnum ] -> irq );
}

static inline void snd_disable_irq( snd_card_t *card, int irqnum )
{
  disable_irq( card -> irqs[ irqnum ] -> irq );
}

/* misc.c */

extern void snd_dma_program( int dma, const void *buf, unsigned int size, unsigned char mode );
extern unsigned int snd_dma_residue( int dma );

/* info.c */

extern int snd_iprintf( snd_info_buffer_t *buffer, char *fmt, ... );
extern int snd_info_register( void );

/* --- */

#ifdef SNDCFG_DEBUG
#define PRINTD( args... ) PRINTK( ##args )
#else
#define PRINTD( args... ) /* nothing */
#endif

#ifdef SNDCFG_DEBUG_DETECT
#define PRINTDD( args... ) PRINTK( ##args )
#else
#define PRINTDD( args... ) /* nothing */
#endif

/* --- */

#define SND_DEFAULT_IDX { [0 ... SND_CARDS] = -1 }
#define SND_DEFAULT_STR { [0 ... SND_CARDS] = NULL }
#define SND_DEFAULT_PORT { SND_AUTO_PORT, [1 ... SND_CARDS] = -1 }
#define SND_DEFAULT_IRQ { [0 ... SND_CARDS] = SND_AUTO_IRQ }
#define SND_DEFAULT_DMA { [0 ... SND_CARDS] = SND_AUTO_DMA }
#define SND_DEFAULT_DMA_SIZE { [0 ... SND_CARDS] = SND_AUTO_DMA_SIZE }
#define SND_DEFAULT_PTR SND_DEFAULT_STR
