/*
 * OSS compatible sequencer driver
 * write priority queue
 *
 * Copyright (C) 1998,99 Takashi Iwai <iwai@ww.uni-erlangen.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __SEQ_OSS_WRITEQ_H
#define __SEQ_OSS_WRITEQ_H

#include "seq_oss_device.h"
#include "seq_oss_event.h"


/*
 * queue record
 */
typedef struct evque_t evque_t;

/*
 * write queue
 */
struct seq_oss_writeq_t {
	evque_t *pool;
	evque_t *qhead, *qtail, *empty;
	int qlen;
	int maxlen;
	int output_threshold;
	snd_sleep_define(write);
	snd_sleep_define(sync);
	snd_spin_define(write);
};

/*
 * seq_oss_writeq.c
 */
seq_oss_writeq_t *snd_seq_oss_writeq_new(seq_oss_devinfo_t *dp, int maxlen);
void snd_seq_oss_writeq_delete(seq_oss_writeq_t *q);
void snd_seq_oss_writeq_clear(seq_oss_writeq_t *q);
void snd_seq_oss_wait_room(seq_oss_writeq_t *q, struct file *opt);
#ifdef SND_POLL
unsigned int snd_seq_oss_writeq_poll(seq_oss_writeq_t *q, struct file *file, poll_table *wait);
#else
int snd_seq_oss_writeq_select(seq_oss_writeq_t *q, select_table *wait);
#endif
int snd_seq_oss_writeq_sync(seq_oss_writeq_t *q);

#define snd_seq_oss_writeq_has_room(wq)	((wq)->maxlen - (wq)->qlen >= (wq)->output_threshold)
#define snd_seq_oss_writeq_is_empty(wq)	((wq)->qlen <= 0)


#endif
