/*
 * OSS compatible sequencer driver
 * timer handling routines
 *
 * Copyright (C) 1998,99 Takashi Iwai <iwai@ww.uni-erlangen.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __SEQ_OSS_TIMER_H
#define __SEQ_OSS_TIMER_H

#include "seq_oss_device.h"

seq_oss_timer_t *snd_seq_oss_timer_new(seq_oss_devinfo_t *dp);
void snd_seq_oss_timer_delete(seq_oss_timer_t *rec);
void snd_seq_oss_timer_init(seq_oss_timer_t *rec);
void snd_seq_oss_timer_set(seq_oss_timer_t *rec, abstime_t time);
abstime_t snd_seq_oss_timer_system_tick(void);
abstime_t snd_seq_oss_timer_cur_tick(seq_oss_timer_t *rec);
reltime_t snd_seq_oss_timer_get_tick(seq_oss_timer_t *rec);
int snd_seq_oss_timer_is_realtime(seq_oss_timer_t *rec);

#endif
