/*******************************************************************************
 *
 *  azx_ringbuffer.h - HD Audio CORB/RIRB Software Interface.
 *
 *  Copyright(c) 2004 Intel Corporation. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify it
 *  under the terms of the GNU General Public License as published by the Free
 *  Software Foundation; either version 2 of the License, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful, but WITHOUT
 *  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 *  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 *  more details.
 *
 *  You should have received a copy of the GNU General Public License along with
 *  this program; if not, write to the Free Software Foundation, Inc., 59
 *  Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 *  CONTACTS:
 *
 *  Matt Jared		matt.jared@intel.com
 *  Andy Kopp		andy.kopp@intel.com
 *  Dan Kogan		dan.d.kogan@intel.com
 *
 *  azx_ringbuffer.h,v 1.3 2004/09/22 15:26:32 tiwai Exp
 *
 *  azx_ringbuffer.h,v
 *  tiwai
 *  2004/09/22 15:26:32
 *
 ******************************************************************************/

#ifndef __AZX_RING_BUFF__
#define __AZX_RING_BUFF__

// AZALIA CORB COMMANDS

// GET commands

//	SYMBOL				VALUE

#define GET_PARAMETER			0xF00

#define GET_CONNECTION_SELECT		0xF01

#define GET_CONNECTION_LIST_ENTRY	0xF02

#define GET_PROCESSING_STATE		0xF03

#define GET_COEFFICIENT_INDEX		0xD00

#define GET_PROCESSING_COEFFICIENT	0xC00

#define GET_AMPLIFIER_GAIN_MUTE		0xB00

#define GET_STREAM_FORMAT		0xA00

#define GET_DIGITAL_CONVERTER		0xF0D

#define GET_POWER_STATE			0xF05

#define GET_CHANNEL_STREAMID		0xF06

#define GET_SDI_SELECT			0xF04

#define GET_PIN_WIDGET_CONTROL		0xF07

#define GET_UNSOLICITED_ENABLE		0xF08

#define GET_PIN_SENSE			0xF09

#define GET_EAPD_BTLENALBE		0xF0C

#define GET_BEEP_GENERATION_CONTROL	0xF0A

#define GET_VOLUME_KNOB_CONTROL		0xF0F

#define GET_CONFIG_DEFAULT_BYTES	0xF1C

#define GET_GPI_DATA			0xF10

#define GET_GPI_WAKE_ENABLE_MASK	0xF11

#define GET_GPI_UNSOLICITED_ENABLE_MASK	0xF12

#define GET_GPI_STICKY_MASK		0xF13

#define GET_GPO_DATA			0xF14

#define GET_GPIO_DATA			0xF15

#define GET_GPIO_ENABLE_MASK		0xF16

#define GET_GPIO_DIRECTION		0xF17

#define GET_GPIO_WAKE_ENABLE_MASK	0xF18

#define GET_GPIO_UNSOLICITED_ENABLE_MASK	0xF19

#define GET_GPIO_STICKY_MASK		0xF1A


// SET commands

//	SYMBOL				VALUE

#define SET_CONNECTION_SELECT		0x701

#define SET_PROCESSING_STATE		0x703

#define SET_COEFFICIENT_INDEX		0x500

#define SET_PROCESSING_COEFFICIENT	0x400

#define SET_AMPLIFIER_GAIN_MUTE		0x300

#define SET_STREAM_FORMAT		0x200

#define SET_DIGITAL_CONVERTER_1		0x70D

#define SET_DIGITAL_CONVERTER_2		0x70E

#define SET_POWER_STATE			0x705

#define SET_CHANNEL_STREAMID		0x706

#define SET_SDI_SELECT			0x704

#define SET_PIN_WIDGET_CONTROL		0x707

#define SET_UNSOLICITED_ENABLE		0x708

#define SET_PIN_SENSE			0x709

#define SET_EAPD_BTLENALBE		0x70C

#define SET_BEEP_GENERATION_CONTROL	0x70A

#define SET_VOLUME_KNOB_CONTROL		0x70F

#define SET_CONFIG_DEFAULT_BYTES_0	0x71C

#define SET_CONFIG_DEFAULT_BYTES_1	0x71D

#define SET_CONFIG_DEFAULT_BYTES_2	0x71E

#define SET_CONFIG_DEFAULT_BYTES_3	0x71F

#define SET_CODEC_RESET			0x7FF



// COMMAND Parameters

//	SYMBOL				VALUE		   MEANING

#define VID				0x00		// Vendor ID

#define SSID				0x01		// Subsystem ID

#define RID				0x02		// Revision ID

#define SUB_NODE_COUNT			0x04		// Subordinate node count

#define FUNC_GRP_TYPE			0x05		// Fucntion group type

#define AUD_FG_CAP			0x08		// Audio function group capabilities

#define AUD_WIDGET_CAP			0x09		// Audio widget capabilities

#define SAMPE_SZ_RATE_CAP		0x0A		// Sample size and rate capabilities

#define STREAM_FMT			0x0B		// Stream format

#define PIN_CAP				0x0C		// Pin capabilities

#define IN_AMP_CAP			0x0D		// Input amplifier capabilities

#define OUT_AMP_CAP			0x12		// Out amplifier

#define CONNECTION_LIST_LENGTH		0x0E

#define SUPPORTED_POWER_STATE		0x0F

#define PROCESSING_CAP			0x10

#define GPIO_COUNT			0x11

#define VOLUME_KNOB_CAP			0x13


/* ---------------------------- end CORB COMMAND #DEFINES ---------------------------------- */

#endif //__AZX_RING_BUFF__
