/*******************************************************************************
 *  azx-alsa-drop-driver-1.1.2.tgz is a driver for hardware using Azaila arch.
 *  Copyright (C) 2004 Intel Corporation
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  as published by the Free Software Foundation; either version 2
 *  of the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 *
 *  codec_enum.h - Contains codec enumeration types and functions.
 *
 *  Copyright(c) 2004 Intel Corporation. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify it
 *  under the terms of the GNU General Public License as published by the Free
 *  Software Foundation; either version 2 of the License, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful, but WITHOUT
 *  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 *  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 *  more details.
 *
 *  You should have received a copy of the GNU General Public License along with
 *  this program; if not, write to the Free Software Foundation, Inc., 59
 *  Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 *  The full GNU General Public License is included in this distribution in the
 *  file called LICENSE.
 *
 *  CONTACTS:
 *
 *  Matt Jared		matt.jared@intel.com
 *  Andy Kopp		andy.kopp@intel.com
 *  Dan Kogan		dan.d.kogan@intel.com
 *
 *  codec_enum.h,v 1.4 2004/09/01 19:29:15 tiwai Exp
 *
 *  codec_enum.h,v
 *  tiwai
 *  2004/09/01 19:29:15
 *
 ******************************************************************************/


#ifndef __AZX_CODEC_ENUM__
#define __AZX_CODEC_ENUM__

// ***********************************************************************
// ** Public data types
// ***********************************************************************


// Table entry to assist in tracking amp capabilites for mixer controls
struct mix_ctl_table_entry{
	u32   mix_type;              // key to search by
	char ctl_name[80];
	u8    NID;
	u32   index;
	u32   amp_direction;         // in or out (1 == out, 0 == in) 
	u32   data_direction;        // in or out (1 == out, 0 == in)
	u32   amp_type;              // in or out (1 == out, 0 == in)
	u32   amp_max_steps;
	u32   amp_max_volume;
	u8    is_mute_cap;
	struct list_head mix_list;
};

// Used to track type of mixer control
enum mix_type {PCM_VOLUME, PCM_MUTE, PCM_CAPTURE, PCM_UNKNOWN, PCM_CD, PCM_CD_MUTE};

// ***********************************************************************
// ** Return Codes From Codec Discovery API
// ***********************************************************************
#define E_AZX_CODEC_OK                    0x1
#define E_AZX_CODEC_FAIL                  0x0
#define E_AZX_INVALID_PARAM               0x25
#define E_AZX_INVALID_FUNC_GROUP          0x26
#define E_AZX_MEM_ALLOC_FAIL              0x27

// ***********************************************************************
// ** Codec Discovery API
// ***********************************************************************

// Path Initialization --> these functions must be called before any others
u32  set_audio_codec_address                   (azx_t* chip);
u32  set_output_path                           (azx_t* chip, u32 stream_id, u32 channels, azx_mix_elem_t* mix_elements);
u32  set_input_path                            (azx_t* chip, u32 stream_id, u32 channels, cap_source_t* cap_source_info, azx_mix_elem_t* mix_elements);
u32  set_cd_analog_loopback_path	       (azx_t* chip, azx_mix_elem_t* mix_elements);
u32  set_mic_rp_path			       (azx_t* chip, cap_source_t* cap_source_info);


// Codec interaction functions
u8   get_dac_nid                               (void);
u8   get_adc_nid                               (void);
u32  get_audio_codec_address                   (void);

struct mix_ctl_table_entry*     get_mix_entry  (u32 mix_type);
u32  print_mix_table                           (void);

#define CODEC_INFO_PROC_FILENAME "codecinfo"
// codec info functions used in by /proc/codecinfo
void snd_azx_print_codec_info                  (snd_info_entry_t *entry, snd_info_buffer_t *buffer);


#endif // __AZX_CODEC_ENUM__
