/*******************************************************************************
 *  azx-alsa-drop-driver-1.1.2.tgz is a driver for hardware using Azaila arch.
 *  Copyright (C) 2004 Intel Corporation
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  as published by the Free Software Foundation; either version 2
 *  of the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 *
 *  azx_controller.h - HD Audio hardware Interface.
 *
 *  Copyright(c) 2004 Intel Corporation. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify it
 *  under the terms of the GNU General Public License as published by the Free
 *  Software Foundation; either version 2 of the License, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful, but WITHOUT
 *  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 *  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 *  more details.
 *
 *  You should have received a copy of the GNU General Public License along with
 *  this program; if not, write to the Free Software Foundation, Inc., 59
 *  Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 *  The full GNU General Public License is included in this distribution in the
 *  file called LICENSE.
 *
 *  CONTACTS:
 *
 *  Matt Jared		matt.jared@intel.com
 *  Andy Kopp		andy.kopp@intel.com
 *  Dan Kogan		dan.d.kogan@intel.com
 *
 *
 *  azx_controller.h,v 1.2 2004/08/30 17:43:45 tiwai Exp
 *
 *  azx_controller.h,v
 *  tiwai
 *  2004/08/30 17:43:45
 *
 ******************************************************************************/


#ifndef ___AZX_CONTROLLER___
#define	___AZX_CONTROLLER___

// *********************************************************************
// control which codec is used by commenting/uncommenting
// the following directive.  If commented out, Relatek codec
// will be used

#define ___DO_C_MEDIA___
// *********************************************************************

// *********************************************************************
// control if using internel sample audio or external PCM file

//#define __DO_AZX_SINE_SAMPLE__
// *********************************************************************



/*
 * AZALIA Interface Controller Registers
 *  Symbol		       		OFFSET	MEANING			     Bytes 1st Last
 */

#define AZX_REG_W_GCAP		        0x00 // Global Capabilities                 00 01

#define AZX_REG_B_VMIN 		        0x02 // Minor Version                       02 02

#define AZX_REG_B_VMAJ		        0x03 // Major Version                       03 03

#define AZX_REG_W_OUTPAY		0x04 // Output Payload Capability           04 05

#define AZX_REG_W_INPAY 		0x06 // Input Payload Capability            06 07

#define AZX_REG_L_GCTL		        0x08 // Global Control                      08 0B

#define AZX_REG_W_WAKEEN 		0x0C // Wake Enable                         0C 0D

#define AZX_REG_W_STATESTS		0x0E // Wake Status                         0E 0F

#define AZX_REG_W_GSTST		        0x10 // Global Status                       10 11

#define AZX_REG_L_INTCTL 		0x20 // Interrupt Control                   20 23

#define AZX_REG_L_INTSTS 		0x24 // Interrupt Status                    24 27

#define AZX_REG_L_WCCNT		        0x30 // Wall Clock Counter                  30 33

#define AZX_REG_L_SSYNC		        0x38 // Stream Synchronization              38 3B

#define AZX_REG_L_CORBLBASE 		0x40 // CORB Lower Base Address             40 43

#define AZX_REG_L_CORBUBASE		0x44 // CORB Upper Base Address             44 47

#define AZX_REG_W_CORBWP 		0x48 // CORB Write Pointer                  48 49

#define AZX_REG_W_CORBRP 		0x4A // CORB Read Pointer                   4A 4B

#define AZX_REG_B_CORBCTL		0x4C // CORB Control                        4C 4C

#define AZX_REG_B_CORBSTS		0x4D // CORB Status                         4D 4D

#define AZX_REG_B_CORBSIZE		0x4E // CORB Size                           4E 4E

#define AZX_REG_L_RIRBLBASE 		0x50 // RIRB Lower Base Address             50 53

#define AZX_REG_L_RIRBUBASE 		0x54 // RIRB Upper Base Address             54 57

#define AZX_REG_W_RIRBWP		0x58 // RIRB Write Pointer                  58 59

#define AZX_REG_W_RINTCNT 		0x5A // Response Interrupt Count            5A 5B

#define AZX_REG_B_RIRBCTL 		0x5C // RIRB Control                        5C 5C

#define AZX_REG_B_RIRBSTS 		0x5D // RIRB Status                         5D 5D

#define AZX_REG_B_RIRBSIZE 		0x5E // RIRB Size                           5E 5E

#define AZX_REG_L_IMCOI		        0x60 // Immediate Command Output Interface  60 63

#define AZX_REG_L_IMCII		        0x64 // Immediate Command Input Interface   64 67

#define AZX_REG_W_IMCSTS 		0x68 // Immediate Command Status            68 69

#define AZX_REG_L_DPLBASE 		0x70 // DMA Position Lower Base Address     70 73

#define AZX_REG_L_DPUBASE 		0x74 // DMA Position Upper Base Address     74 77


// stream register offsets from stream base
#define AZX_REG_3B_SD_CTL		0x0

#define AZX_REG_B_SD_STS		0x3

#define AZX_REG_L_SD_LPIB		0x4

#define AZX_REG_L_SD_CBL		0x8

#define AZX_REG_W_SD_LVI		0xC

#define AZX_REG_W_SD_FIFOSIZE		0x10

#define AZX_REG_W_SD_FORMAT		0x12

#define AZX_REG_L_SD_BDLPL		0x18

#define AZX_REG_L_SD_BDLPU		0x1C

#define AZX_REG_L_SD_LPIBA		0x2004



//Stream Description Registers

//SDATA IN 0

#define AZX_REG_3B_SDI0CTL		0x80 // Stream Descriptor Control           80 82

#define AZX_REG_B_SDI0STS 		0x83 // Stream Descriptor Status            83 83

#define AZX_REG_L_SDI0LPIB 		0x84 // Link Position in Current Buffer     84 87

#define AZX_REG_L_SDI0CBL		0x88 // Cyclic Buffer Length                88 8B

#define AZX_REG_W_SDI0LVI		0x8C // Last Valid Index                    8C 8D

#define AZX_REG_W_SDI0FIFOSIZE	        0x90 // FIFO Size                           90 91

#define AZX_REG_W_SDI0FORMAT		0x92 // Format                              92 93

#define AZX_REG_L_SDI0BDLPL		0x98 // List Pointer - Lower                98 9B

#define AZX_REG_L_SDI0BDLPU		0x9C // List Pointer - Upper                9C 9F

#define AZX_REG_L_SDI0LPIBA		0x2084  //Link Posiiton in Buffer n Alias   2084 2087


// Stream interrupts in the status register
#define AZX_STREAM_INT			0x1C


//SDATA IN 1

#define AZX_REG_3B_SDI1CTL		0xA0 // Stream Descriptor Control           A0 82

#define AZX_REG_B_SDI1STS 		0xA3 // Stream Descriptor Status            A3 83

#define AZX_REG_L_SDI1LPIB 		0xA4 // Link Position in Current Buffer     A4 87

#define AZX_REG_L_SDI1CBL		0xA8 // Cyclic Buffer Length                A8 8B

#define AZX_REG_W_SDI1LVI		0xAC // Last Valid Index                    AC 8D

#define AZX_REG_W_SDI1FIFOSIZE	        0xB0 // FIFO Size                           B0 91

#define AZX_REG_W_SDI1FORMAT		0xB2 // Format                              B2 93

#define AZX_REG_L_SDI1BDLPL		0xB8 // List Pointer - Lower                B8 9B

#define AZX_REG_L_SDI1BDLPU		0xBC // List Pointer - Upper                bC 9F

#define AZX_REG_L_SDI1LPIBA		0x20A4	//Link Posiiton in Buffer n Alias   20A4 20A7



//SDATA IN 2

#define AZX_REG_3B_SDI2CTL		0xC0 // Stream Descriptor Control           C0 C2

#define AZX_REG_B_SDI2STS 		0xC3 // Stream Descriptor Status            C3 C3

#define AZX_REG_L_SDI2LPIB 		0xC4 // Link Position in Current Buffer     C4 C7

#define AZX_REG_L_SDI2CBL		0xC8 // Cyclic Buffer Length                C8 CB

#define AZX_REG_W_SDI2LVI		0xCC // Last Valid Index                    CC CD

#define AZX_REG_W_SDI2FIFOSIZE	        0xD0 // FIFO Size                           D0 D1

#define AZX_REG_W_SDI2FORMAT		0xD2 // Format                              D2 D3

#define AZX_REG_L_SDI2BDLPL		0xD8 // List Pointer - Lower                D8 DB

#define AZX_REG_L_SDI2BDLPU		0xDC // List Pointer - Upper                DC DF

#define AZX_REG_L_SDI2LPIBA		0x20D4	//Link Posiiton in Buffer n Alias   20D4 20D7



//SDATA IN 3

#define AZX_REG_3B_SDI3CTL		0xE0 // Stream Descriptor Control           E0 E2

#define AZX_REG_B_SDI3STS 		0xE3 // Stream Descriptor Status            E3 E3

#define AZX_REG_L_SDI3LPIB 		0xE4 // Link Position in Current Buffer     E4 E7

#define AZX_REG_L_SDI3CBL		0xE8 // Cyclic Buffer Length                E8 EB

#define AZX_REG_W_SDI3LVI		0xEC // Last Valid Index                    EC ED

#define AZX_REG_W_SDI3FIFOSIZE	        0xF0 // FIFO Size                           F0 F1

#define AZX_REG_W_SDI3FORMAT		0xF2 // Format                              F2 F3

#define AZX_REG_L_SDI3BDLPL		0xF8 // List Pointer - Lower                F8 FB

#define AZX_REG_L_SDI3BDLPU		0xFC // List Pointer - Upper                FC FF

#define AZX_REG_L_SDI3LPIBA		0x20E4	//Link Posiiton in Buffer n Alias   20E4 20E7



//SDATA OUT 0

#define AZX_REG_3B_SDO0CTL		0x100 // Stream Descriptor Control          100 102

#define AZX_REG_B_SDO0STS 		0x103 // Stream Descriptor Status           103 103

#define AZX_REG_L_SDO0LPIB 		0x104 // Link Position in Current Buffer    104 107

#define AZX_REG_L_SDO0CBL		0x108 // Cyclic Buffer Length               108 10B

#define AZX_REG_W_SDO0LVI		0x10C // Last Valid Index                   10C 10D

#define AZX_REG_W_SDO0FIFOSIZE	        0x110 // FIFO Size                          110 111

#define AZX_REG_W_SDO0FORMAT		0x112 // Format                             112 113

#define AZX_REG_L_SDO0BDLPL		0x118 // List Pointer - Lower               118 11B

#define AZX_REG_L_SDO0BDLPU		0x11C // List Pointer - Upper               11C 11F

#define AZX_REG_L_SDO0LPIBA		0x2104	//Link Posiiton in Buffer n Alias   2104 2107


//SDATA OUT 1

#define AZX_REG_3B_SDO1CTL		0x120 // Stream Descriptor Control          120 122

#define AZX_REG_B_SDO1STS 		0x123 // Stream Descriptor Status           123 123

#define AZX_REG_L_SDO1LPIB 		0x124 // Link Position in Current Buffer    124 127

#define AZX_REG_L_SDO1CBL		0x128 // Cyclic Buffer Length               128 12B

#define AZX_REG_W_SDO1LVI		0x12C // Last Valid Index                   12C 12D

#define AZX_REG_W_SDO1FIFOSIZE	        0x130 // FIFO Size                          130 131

#define AZX_REG_W_SDO1FORMAT		0x132 // Format                             132 133

#define AZX_REG_L_SDO1BDLPL		0x138 // List Pointer - Lower               138 13B

#define AZX_REG_L_SDO1BDLPU		0x13C // List Pointer - Upper               13C 13F

#define AZX_REG_L_SDO1LPIBA		0x2124	//Link Posiiton in Buffer n Alias   2124 2127



//SDATA OUT 2

#define AZX_REG_3B_SDO2CTL		0x140 // Stream Descriptor Control          140 142

#define AZX_REG_B_SDO2STS 		0x143 // Stream Descriptor Status           143 143

#define AZX_REG_L_SDO2LPIB 		0x144 // Link Position in Current Buffer    144 147

#define AZX_REG_L_SDO2CBL		0x148 // Cyclic Buffer Length               148 14B

#define AZX_REG_W_SDO2LVI		0x14C // Last Valid Index                   14C 14D

#define AZX_REG_W_SDO2FIFOSIZE	        0x150 // FIFO Size                          150 151

#define AZX_REG_W_SDO2FORMAT		0x152 // Format                             152 153

#define AZX_REG_L_SDO2BDLPL		0x158 // List Pointer - Lower               158 15B

#define AZX_REG_L_SDO2BDLPU		0x15C // List Pointer - Upper               15C 15F

#define AZX_REG_L_SDO2LPIBA		0x2144	//Link Posiiton in Buffer n Alias   2144 2147



//SDATA OUT 3

#define AZX_REG_3B_SDO3CTL		0x160 // Stream Descriptor Control          160 162

#define AZX_REG_B_SDO3STS 		0x163 // Stream Descriptor Status           163 163

#define AZX_REG_L_SDO3LPIB 		0x164 // Link Position in Current Buffer    164 167

#define AZX_REG_L_SDO3CBL		0x168 // Cyclic Buffer Length               168 16B

#define AZX_REG_W_SDO3LVI		0x16C // Last Valid Index                   16C 16D

#define AZX_REG_W_SDO3FIFOSIZE	        0x170 // FIFO Size                          170 171

#define AZX_REG_W_SDO3FORMAT		0x172 // Format                             172 173

#define AZX_REG_L_SDO3BDLPL		0x178 // List Pointer - Lower               178 17B

#define AZX_REG_L_SDO3BDLPU		0x17C // List Pointer - Upper               17C 17F

#define AZX_REG_L_SDO3LPIBA		0x2164  //Link Posiiton in Buffer n Alias   2164 2167



#define AZX_REG_L_WALCLKA		0x2030	//Wall Clock Counter Alias

/* ---------------------------- end REGISTER #DEFINES -------------------------------------- */



// CORBCTL fields

#define AZX_REG_BIT_CORBCTL_CMEIE	0	/* CORB Memory Error Int. enable */

#define AZX_REG_BIT_CORBCTL_CORBRUN	1	/* CORBRUN - enable CORB DMA     */



// RIRBCTL fields

#define AZX_REG_BIT_RIRBCTL_RIRBOIC	2	/* Response overrun int. control */

#define AZX_REG_BIT_RIRBCTL_RIRBDMAEN	1	/* RIRB DMA Enable		 */

#define AZX_REG_BIT_RIRBCTL_RINTCTL	0	/* Response interrupt control	 */



// CORBSTS fields

#define AZX_REG_BIT_CORBSTS_CMEI	0	/* CORB Memory Error Indication  */





// GCAP: Global Capabilities fields, masks, and offsets
//     Output Streams Supported

#define AZX_GCAP_DEFAULT	0x4401

#define GCAP_STREAM_MASK    	   0xF

#define GCAP_OSS_OFFSET     	    12



//     Input Streams Supported

#define GCAP_ISS_OFFSET     8



//     Bidirectional Streams Supported

#define GCAP_BSS_OFFSET     4



//     Serial Data Out

#define GCAP_SDO_OFFSET     1





// OUTPAY, INPAY: Out/In Payload masks are the same for both registers

#define PAYLOAD_MASK        0x7F





// GCTL: Global Control fields, masks, and offsets

//     UNSOL: Accept Unsolicited Response Enable

#define AZX_REG_BIT_GCTL_CRST		0

#define AZX_REG_BIT_GCTL_UNSOL	 	8





// FCNTRL: Flush control

#define GCTL_FCNTRL_OFFSET   1



// INTCTL:CIE

//	bit 30 Controller Interrupt Enable

//	bit 31 Global Interrupt Enable


// *** added by Matt
#define AZX_REG_BIT_INTCTL_SIE		0
// ***

#define AZX_REG_BIT_INTCTL_CIE		30

#define AZX_REG_BIT_INTCTL_GIE		31



// WAKEEN: Wake Enable flags

// 	bits 14:0 in WAKEEN register, offset 0xC

//#define AZX_MASK_WAKEEN_SDIWEN  	0x3FFF

#define AZX_MASK_WAKEEN_SDIWEN_RESET	0x7FFF



// SDIWAKE: State change status flags

//	bits 14:0 in STATESTS register, offset 0xE

#define AZX_MASK_STATESTS_SDIWAKE_RESET	0x7FFF



// RING BUFFER DMA Enable

#define RING_BUFFER_DMA_MASK	0x02

// add macro for disalbing dma



// RING BUFFER SIZE MASK

#define AZX_RING_BUFFER_SIZE_MASK	0xF0



// RING BUFFER SIZE SUPPORT MASK

#define AZX_RING_BUFFER_SIZE_256	0x40

#define AZX_RING_BUFFER_SIZE_16		0x20

#define AZX_RING_BUFFER_SIZE_2		0x10



// RING BUFFER SIZE SET VALUE

#define RING_BUFFER_SIZE_256_SET	0x02

#define RING_BUFFER_SIZE_16_SET		0x01

#define RING_BUFFER_SIZE_2_SET		0x00



// CODEC CHANGE STATE STATUS MASK

#define AZX_MASK_STATESTS_SDIN_STATE_CHANGE	0x7		// SDIN State Change Status Flags



// CONTROLLER RESET BIT MASK FOR GLOBAL CONTROL REGISTER

#define GCTL_CONTROLLER_RESET_BIT_MASK	0x00000001



// CORB WRITE POINTER MASK

//#define CORB_WP_MASK			0x00FF

#define AZX_MASK_CORB_WP		0x00FF



// CORB READ POINTER MASk

#define CORB_RP_MASK			0x00FF



// CORB READ POINTER RESET MASK

#define CORB_RP_RESET_MASK		0x8000



// RIRB WRITE POINTER MASK

#define RIRB_WP_MASK			0x00FF



// RIRB WRITE POINTER RESET MASK

#define RIRB_WP_RESET_MASK		0x8000



// CORB DMA ENABLE MASK

#define CORB_DMA_ENABLE_BIT_MASK	0x02



// RIRB DMA ENABLE MASK

#define RIRB_DMA_ENABLE_BIT_MASK	0x02



// MAXIMUM SIZE OF CODEC ADDRESS

#define AZX_MAX_CORB_CODEC_ADDR		0x14



// MAXIMUM VALUE OF CORB VERB

#define AZX_MAX_CORB_VERB_VAL		0xF13



// MAXIMUM VALUE OF CORB NID Short Form

#define AZX_MAX_CORB_NID_SF		0x7F



// MAXIMUM VALUE FOR CORB VERB PAYLOAD

#define AZX_MAX_CORB_PARAM_VAL		0x13



// RING BUFFER ENABLE MEMORY ERROR INTERRUPT MASK

#define AZX_CORB_MEM_ERR_INT_ENABLE_MASK	0x01



// WAKE ENABLE SDI 2 MASK

#define AZX_WAKEEN_SDI2			0x04



// GLOBAL INTERRUPT ENABLE MASK

#define AZX_GIE_MASK			0x8000



// CONTROLLER INTERRUPT ENABLE MASK

#define AZX_CIE_MASK			0x4000



// STREAMING INPUT 0 INTERRUPT ENABLE MASK

#define AZX_INPUT_0_IE_MASK		0x0001



// STREAMING INPUT 1 INTERRUPT ENABLE MASK

#define AZX_INPUT_1_IE_MASK		0x0002



// STREAMING INPUT 2 INTERRUPT ENABLE MASK

#define AZX_INPUT_2_IE_MASK		0x0004



// STREAMING INPUT 3 INTERRUPT ENABLE MASK

#define AZX_INPUT_3_IE_MASK		0x0008

// STREAMING OUTPUT 0 INTERRUPT ENABLE MASK

#define AZX_OUTPUT_0_IE_MASK		0x0010



// STREAMING OUTPUT 1 INTERRUPT ENABLE MASK

#define AZX_OUTPUT_1_IE_MASK		0x0020



// STREAMING OUTPUT 2 INTERRUPT ENABLE MASK

#define AZX_OUTPUT_2_IE_MASK		0x0040



// STREAMING OUTPUT 3 INTERRUPT ENABLE MASK

#define AZX_OUTPUT_3_IE_MASK		0x0080



// STREAM DESCRIPTOR CONTROL MASK
// DESCRIPTOR ERROR INTERRUPT ENABLE
#define AZX_SD_CTL_DESE_INT_EN_MASK	0x10
// FIFO ERROR ERROR INTERRUPT ENABLE
#define AZX_SD_CTL_FIFOE_INT_EN_MASK	0x08
// INTERRUPT ON COMPLETION ENABLE
#define AZX_SD_CTL_IOC_INT_EN_MASK	0x04
// DMA run bit
#define AZX_SD_CTL_DMA_RUN_EN		0x02



// STREAM DESCRIPTOR STATUS MASK
// DESCRIPTOR ERROR
#define AZX_SD_STS_DESE_MASK		0x10
// FIFO ERROR
#define AZX_SD_STS_FIFOE_MASK		0x80
// BUFFER COMPLETION INTERRUPT STATUS
#define AZX_SD_STS_BCIS_MASK		0x40


/* ---------------------------- end REGISTER MASK and MACROs ------------------------------- */


#endif //___AZX_CONTROLLER___

