/*******************************************************************************
 *
 *  azx.h - Specification of primary alsa driver code base for Intel HD Audio.
 *
 *  Copyright(c) 2004 Intel Corporation. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify it
 *  under the terms of the GNU General Public License as published by the Free
 *  Software Foundation; either version 2 of the License, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful, but WITHOUT
 *  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 *  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 *  more details.
 *
 *  You should have received a copy of the GNU General Public License along with
 *  this program; if not, write to the Free Software Foundation, Inc., 59
 *  Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 *  CONTACTS:
 *
 *  Matt Jared		matt.jared@intel.com
 *  Andy Kopp		andy.kopp@intel.com
 *  Dan Kogan		dan.d.kogan@intel.com
 *
 *
 *  azx.h,v 1.3 2004/09/22 15:26:30 tiwai Exp
 *
 *  azx.h,v
 *  tiwai
 *  2004/09/22 15:26:30
 *
 ******************************************************************************/

#ifndef __SND_AZX__
#define __SND_AZX__

struct snd_azx;
typedef struct snd_azx azx_t;

#define MAX_CAP_SOURCE 8
#define MAX_ICH6_DEV 8
#define AZX_MAX_MIX_ELEMS 23

int snd_azx_volume_info(snd_kcontrol_t* kcontrol, snd_ctl_elem_info_t* uinfo);
int snd_azx_volume_get(snd_kcontrol_t* kcontrol, snd_ctl_elem_value_t* ucontrol);
int snd_azx_volume_put(snd_kcontrol_t* kcontrol, snd_ctl_elem_value_t* ucontrol);
int snd_azx_switch_get(snd_kcontrol_t* kcontrol, snd_ctl_elem_value_t* ucontrol);
int snd_azx_switch_put(snd_kcontrol_t* kcontrol, snd_ctl_elem_value_t* ucontrol);

enum { AZX_MIX_MASTER, AZX_MIX_MASTER_MUTE, AZX_MIX_HP, AZX_MIX_HP_MUTE, AZX_MIX_FRONT, AZX_MIX_FRONT_MUTE,
       AZX_MIX_SURR, AZX_MIX_SURR_MUTE, AZX_MIX_CLFE, AZX_MIX_CLFE_MUTE, AZX_MIX_RSURR, AZX_MIX_RSURR_MUTE,
       AZX_MIX_MIC1, AZX_MIX_MIC1_MUTE, AZX_MIX_MIC2, AZX_MIX_MIC2_MUTE, AZX_MIX_LINE1, AZX_MIX_LINE1_MUTE,
       AZX_MIX_LINE2, AZX_MIX_LINE2_MUTE, AZX_MIX_CD, AZX_MIX_CD_MUTE, AZX_MIX_CAP };

typedef struct {
	unsigned char num_items;
	char* cap_labels[MAX_CAP_SOURCE];
	unsigned char cap_index[MAX_CAP_SOURCE];
	u8 nids[MAX_CAP_SOURCE];
	unsigned char init_val;
} cap_source_t;

typedef struct {
	unsigned char vol[2];
	unsigned char sw[2];
	char label[255];
	unsigned char nid;
	unsigned char index;
	unsigned char direction;
	unsigned int max_vol;
	unsigned int type;
	unsigned int path;
} azx_mix_elem_t;

int snd_azx_send_corb_cmd(azx_t* chip, u32 cad, u32 nid, u32 direct, u32 verb, u32 parameter, u32* lower_response, u32* upper_response);
u32 snd_azx_get_codec_mask(azx_t* chip);

// helper macro for mixer control creation
#define AZX_VOLUME(xname, nid, index, direction, max_val, type, path) \
{ .iface = SNDRV_CTL_ELEM_IFACE_MIXER, .name = xname, .info = snd_azx_volume_info, \
  .get = snd_azx_volume_get, .put = snd_azx_volume_put, \
  .private_value = (nid) | ((index) << 8) | ((direction) << 12) | ((max_val) << 13) | ((type) << 21) | ((path) << 22) }

#define AZX_MUTE(xname, nid, index, direction, max_val, type, path) \
{ .iface = SNDRV_CTL_ELEM_IFACE_MIXER, .name = xname, .info = snd_azx_volume_info, \
  .get = snd_azx_switch_get, .put = snd_azx_switch_put, \
  .private_value = (nid) | ((index) << 8) | ((direction) << 12) | ((max_val) << 13) | ((type) << 21) | ((path) << 22) }

#endif //__SND_AZX__
