/*******************************************************************************
 *  azx-alsa-drop-driver-1.1.2.tgz is a driver for hardware using Azaila arch.
 *  Copyright (C) 2004 Intel Corporation
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  as published by the Free Software Foundation; either version 2
 *  of the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 *
 *  codec_enum.h - Contains codec enumeration types and functions.
 *
 *  Copyright(c) 2004 Intel Corporation. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify it
 *  under the terms of the GNU General Public License as published by the Free
 *  Software Foundation; either version 2 of the License, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful, but WITHOUT
 *  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 *  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 *  more details.
 *
 *  You should have received a copy of the GNU General Public License along with
 *  this program; if not, write to the Free Software Foundation, Inc., 59
 *  Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 *  The full GNU General Public License is included in this distribution in the
 *  file called LICENSE.
 *
 *  CONTACTS:
 *
 *  Matt Jared		matt.jared@intel.com
 *  Andy Kopp		andy.kopp@intel.com
 *  Dan Kogan		dan.d.kogan@intel.com
 *
 *  codec_enum.h,v 1.2 2004/07/29 06:37:34 cladisch Exp
 *
 *  codec_enum.h,v
 *  cladisch
 *  2004/07/29 06:37:34
 *
 ******************************************************************************/


#ifndef __AZX_CODEC_ENUM__
#define __AZX_CODEC_ENUM__

#include <linux/version.h>
#if LINUX_VERSION_CODE >= KERNEL_VERSION(2, 4, 0)
#define USE_PROC_CODEC_INFO
#endif

#ifdef USE_PROC_CODEC_INFO
#include <linux/proc_fs.h>
#include <linux/seq_file.h>
#endif

// ***********************************************************************
// ** Public data types
// ***********************************************************************


// Table entry to assist in tracking amp capabilites for mixer controls
struct mix_ctl_table_entry{
	u32   mix_type;              // key to search by
	char ctl_name[80];
	u8    NID;
	u32   index;
	u32   amp_direction;         // in or out (1 == out, 0 == in) 
	u32   data_direction;        // in or out (1 == out, 0 == in)
	u32   amp_type;              // in or out (1 == out, 0 == in)
	u32   amp_max_steps;
	struct list_head mix_list;
};

// Used to track type of mixer control
enum mix_type {PCM_VOLUME, PCM_MUTE, PCM_CAPTURE, PCM_UNKNOWN};

// ***********************************************************************
// ** Return Codes From Codec Discovery API
// ***********************************************************************
#define E_AZX_CODEC_OK                    0x1
#define E_AZX_CODEC_FAIL                  0x0
#define E_AZX_INVALID_PARAM               0x25
#define E_AZX_INVALID_FUNC_GROUP          0x26
#define E_AZX_MEM_ALLOC_FAIL              0x27

// ***********************************************************************
// ** Codec Discovery API
// ***********************************************************************

// Path Initialization --> these functions must be called before any others
u32  set_audio_codec_address                   (azx_t* chip);
u32  set_output_path                           (azx_t* chip, u16 stream_id, u16 channels, u32 stream_format);
u32  set_input_path                            (azx_t* chip, u16 stream_id, u16 channels, u32 stream_format);

// Codec interaction functions
u8   get_dac_nid                               (void);
u8   get_adc_nid                               (void);
u32  get_audio_codec_address                   (void);

struct mix_ctl_table_entry*     get_mix_entry  (u32 mix_type);
u32  print_mix_table                           (void);

#ifdef USE_PROC_CODEC_INFO
// codec info functions used in by /proc/codecinfo
u32  collect_codec_info                        (azx_t* chip);
void *codecinf_seq_start                       (struct seq_file *sf, loff_t * pos);
void *codecinf_seq_next                        (struct seq_file *sf, void *v, loff_t * pos);
void codecinf_seq_stop                         (struct seq_file *sf, void *v);
int  codecinf_seq_show                         (struct seq_file *sf, void *v    /* jiffies in disquise */);
int  proc_codecinf_open                        (struct inode *inode, struct file *file);
u32 store_codec_info_entry                     (char* str_codec_info);
u32  cleanup_codec_info_list                   (void);
void print_codec_info_list                     (void);
#endif

// Codec Maintenance
u32  codec_mem_cleanup                         (void);


#ifdef USE_PROC_CODEC_INFO
// Proc (/proc/codecinfo) special filename
#define CODEC_INFO_PROC_FILENAME "codecinfo"
#endif


#endif // __AZX_CODEC_ENUM__
