#ifndef __LINUX_KMOD_H__
#define __LINUX_KMOD_H__
/*
	kmod header
*/

#include <linux/config.h>

#ifdef CONFIG_KMOD
extern int request_module(const char * name);
extern int exec_usermodehelper(char *program_path, char *argv[], char *envp[]);
#ifdef CONFIG_HOTPLUG
extern char hotplug_path[];
#endif
#else
#include <linux/errno.h>

#define request_module(x) do {} while(0)
static inline int exec_usermodehelper(char *program_path, char *argv[], char *envp[])
{
        return -EACCES;
}
#endif

#endif /* __LINUX_KMOD_H__ */
