/*
 *  Plugin core
 *  Copyright (c) 1999 by Jaroslav Kysela <perex@suse.cz>
 *
 *
 *   This library is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU Library General Public License as
 *   published by the Free Software Foundation; either version 2 of
 *   the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU Library General Public License for more details.
 *
 *   You should have received a copy of the GNU Library General Public
 *   License along with this library; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#define SND_MAIN_OBJECT_FILE
#include "../../include/driver.h"
#include "../../include/pcm_plugin.h"

snd_pcm_plugin_t *snd_pcm_plugin_build(const char *name, int extra)
{
	snd_pcm_plugin_t *plugin;

	plugin = snd_kcalloc(sizeof(*plugin) + extra, GFP_KERNEL);
	if (plugin == NULL)
		return NULL;
	if (name)
		plugin->name = snd_kmalloc_strdup(name, GFP_KERNEL);
	return plugin;
}

int snd_pcm_plugin_free(snd_pcm_plugin_t *plugin)
{
	if (plugin == NULL)
		return -EINVAL;
	if (plugin->private_free)
		plugin->private_free(plugin, plugin->private_data);
	if (plugin->name)
		snd_kfree(plugin->name);
	snd_kfree(plugin);
	return 0;
}

EXPORT_SYMBOL(snd_pcm_plugin_build);
EXPORT_SYMBOL(snd_pcm_plugin_free);
EXPORT_SYMBOL(snd_pcm_plugin_build_linear);
EXPORT_SYMBOL(snd_pcm_plugin_build_mulaw);
EXPORT_SYMBOL(snd_pcm_plugin_build_rate);
EXPORT_SYMBOL(snd_pcm_plugin_build_voices);
EXPORT_SYMBOL(snd_pcm_plugin_build_interleave);
