/*
 *  ISA DMA support functions
 *  Copyright (c) by Jaroslav Kysela <perex@suse.cz>
 *
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include "../include/driver.h"

/*
 * I added some delay here [Jaroslav]. Maybe this can help for some broken
 * ISA DMA controllers.
 */

#define SND_DELAY_BY_DMA

/*
 *
 */
 
#ifdef SND_DELAY_BY_DMA
#define snd_dma_delay() udelay(30)
#else
#define snd_dma_delay() do { ; } while(0)
#endif

void snd_dma_program(int dma,
		     const void *buf, unsigned int size,
                     unsigned short mode)
{
	unsigned long flags;

	flags = claim_dma_lock();
	disable_dma(dma);
	snd_dma_delay();
	clear_dma_ff(dma);
	snd_dma_delay();
	set_dma_mode(dma, mode);
	set_dma_addr(dma, virt_to_bus((void *) buf));
	set_dma_count(dma, size);
	snd_dma_delay();
	if (!(mode & DMA_MODE_NO_ENABLE))
		enable_dma(dma);
	release_dma_lock(flags);
}

void snd_dma_disable(int dma)
{
	unsigned long flags;

	flags = claim_dma_lock();
	disable_dma(dma);
	snd_dma_delay();
	clear_dma_ff(dma);
	snd_dma_delay();
	release_dma_lock(flags);
}

unsigned int snd_dma_residue(int dma)
{
	unsigned long flags;
	unsigned int result;

	flags = claim_dma_lock();
	if (!isa_dma_bridge_buggy) {
		disable_dma(dma);
		snd_dma_delay();
	}
	clear_dma_ff(dma);
	snd_dma_delay();
	result = get_dma_residue(dma);
	if (!isa_dma_bridge_buggy)
		enable_dma(dma);
	release_dma_lock(flags);
	return result;
}
