/*
 *  Advanced Linux Sound Architecture - Solid Kernel Initiazation
 *  Copyright (c) by Jaroslav Kysela <perex@suse.cz>
 *
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include "../include/driver.h"
#include "../include/version.h"

extern int alsa_sound_init(void);
extern int alsa_mixer_init(void);
extern int alsa_mixer_oss_init(void);
extern int alsa_pcm_init(void);
extern int alsa_pcm_oss_init(void);
extern int alsa_timer_init(void);
extern int alsa_rawmidi_init(void);
extern int alsa_hwdep_init(void);
extern int alsa_i2c_init(void);
extern int alsa_seq_init(void);
extern int alsa_seq_midi_init(void);
extern int alsa_virmidi_init(void);
extern int alsa_gus_synth_init(void);
extern int alsa_trident_synth_init(void);
extern int alsa_emu8000_init(void);
extern int alsa_emu10k1_synth_init(void);

/* PCI cards at first */
extern int alsa_card_cs461x_init(void);
extern int alsa_card_ens1370_init(void);
extern int alsa_card_ens1371_init(void);
extern int alsa_card_es1938_init(void);
extern int alsa_card_sonicvibes_init(void);
extern int alsa_card_trident_init(void);
extern int alsa_card_emu10k1_init(void);
extern int alsa_card_rme9652_init(void);
extern int alsa_card_ice1712_init(void);
/* ISA PnP cards at middle */
extern int alsa_card_ad1816a_init(void);
extern int alsa_card_als100_init(void);
extern int alsa_card_azt2320_init(void);
extern int alsa_card_cs4232_init(void);
extern int alsa_card_cs4236_init(void);
extern int alsa_card_dt0197h_init(void);
extern int alsa_card_es18xx_init(void);
extern int alsa_card_es968_init(void);
extern int alsa_card_interwave_init(void);
extern int alsa_card_interwave_stb_init(void);
extern int alsa_card_opl3sa2_init(void);
extern int alsa_card_opti93x_init(void);
extern int alsa_card_opti92x_cs4231_init(void);
extern int alsa_card_opti92x_ad1848_init(void);
extern int alsa_card_sbawe_init(void);
extern int alsa_card_sb16_init(void);
extern int alsa_card_wavefront_init(void);
/* Legacy ISA at last */
extern int alsa_card_ad1848_init(void);
extern int alsa_card_cs4231_init(void);
extern int alsa_card_es1688_init(void);
extern int alsa_card_gusclassic_init(void);
extern int alsa_card_gusmax_init(void);
extern int alsa_card_gusextreme_init(void);
extern int alsa_card_mozart_init(void);
extern int alsa_card_sb8_init(void);
extern int alsa_card_serial_init(void);
/* Others */
extern int alsa_card_dummy_init(void);
extern int alsa_card_share_init(void);

#ifndef MODULE

static void __init alsa_init_show(void)
{
	int idx, ok = 0;
	
	printk("Advanced Linux Sound Architecture Driver Version " CONFIG_SND_VERSION ".\n");
	for (idx = 0; idx < SND_CARDS; idx++)
		if (snd_cards[idx] != NULL) {
			printk("  #%i: %s\n", idx, snd_cards[idx]->longname);
			ok++;
		}
	if (ok == 0)
		printk("  No soundcards found.\n");
}

int __init alsa_init(void)
{
	int err;
	
	if ((err = alsa_sound_init()) < 0)
		return err;
#ifdef CONFIG_SND_MIXER
	alsa_mixer_init();
#endif
#ifdef CONFIG_SND_MIXER_OSS
	alsa_mixer_oss_init();
#endif
#ifdef CONFIG_SND_PCM
	alsa_pcm_init();
#endif
#ifdef CONFIG_SND_PCM_OSS
	alsa_pcm_oss_init();
#endif
#ifdef CONFIG_SND_RAWMIDI
	alsa_rawmidi_init();
#endif
#ifdef CONFIG_SND_TIMER
	alsa_timer_init();
#endif
#ifdef CONFIG_SND_HWDEP
	alsa_hwdep_init();
#endif
#ifdef CONFIG_SND_I2C
	alsa_i2c_init();
#endif
#ifdef CONFIG_SND_SEQ
	alsa_seq_init();
#endif
#ifdef CONFIG_SND_SEQ_MIDI
	alsa_seq_midi_init();
#endif
#ifdef CONFIG_SND_SEQ_OSS
	alsa_seq_oss_init();
#endif
#ifdef CONFIG_SND_GUS_SYNTH
	alsa_gus_synth_init();
#endif
#ifdef CONFIG_SND_TRIDENT_SYNTH
	alsa_trident_synth_init();
#endif
#ifdef CONFIG_SND_SYNTH_EMU8000
	alsa_emu8000_init();
#endif
#ifdef CONFIG_SND_SEQ_VIRMIDI
	alsa_virmidi_init();
#endif

#ifdef CONFIG_SND_CARD_CS461X
	alsa_card_cs461x_init();
#endif
#ifdef CONFIG_SND_CARD_ENS1370
	alsa_card_ens1370_init();
#endif
#ifdef CONFIG_SND_CARD_ENS1371
	alsa_card_ens1371_init();
#endif
#ifdef CONFIG_SND_CARD_ES1938
	alsa_card_es1938_init();
#endif
#ifdef CONFIG_SND_CARD_FM801
	alsa_card_fm801_init();
#endif
#ifdef CONFIG_SND_CARD_SONICVIBES
	alsa_card_sonicvibes_init();
#endif
#ifdef CONFIG_SND_CARD_TRIDENT
	alsa_card_trident_init();
#endif
#ifdef CONFIG_SND_CARD_EMU10K1
	alsa_card_emu10k1_init();
#endif
#ifdef CONFIG_SND_CARD_RME9652
	alsa_card_rme9652_init();
#endif
#ifdef CONFIG_SND_CARD_ICE1712
	alsa_card_ice1712_init();
#endif

#ifdef CONFIG_SND_CARD_AD1816A
	alsa_card_ad1816a_init();
#endif
#ifdef CONFIG_SND_CARD_ALS100
	alsa_card_als100_init();
#endif
#ifdef CONFIG_SND_CARD_AZT2320
	alsa_card_azt2320_init();
#endif
#ifdef CONFIG_SND_CARD_CMI8330
	alsa_card_cmi8330_init();
#endif
#ifdef CONFIG_SND_CARD_CS4232
	alsa_card_cs4232_init();
#endif
#ifdef CONFIG_SND_CARD_CS4236
	alsa_card_cs4236_init();
#endif
#ifdef CONFIG_SND_CARD_DT0197H
	alsa_card_dt0197h_init();
#endif
#ifdef CONFIG_SND_CARD_ES18XX
	alsa_card_es18xx_init();
#endif
#ifdef CONFIG_SND_CARD_ES968
	alsa_card_es968_init();
#endif
#ifdef CONFIG_SND_CARD_INTERWAVE_STB
	alsa_card_interwave_stb_init();
#endif
#ifdef CONFIG_SND_CARD_INTERWAVE
	alsa_card_interwave_init();
#endif
#ifdef CONFIG_SND_CARD_OPL3SA2
	alsa_card_opl3sa2_init();
#endif
#ifdef CONFIG_SND_CARD_OPTI93X
	alsa_card_opti93x_init();
#endif
#ifdef CONFIG_SND_CARD_OPTI92X_CS4231
	alsa_card_opti92x_cs4231_init();
#endif
#ifdef CONFIG_SND_CARD_OPTI92X_AD1848
	alsa_card_opti92x_ad1848_init();
#endif
#ifdef CONFIG_SND_CARD_SBAWE
	alsa_card_sbawe_init();
#endif
#ifdef CONFIG_SND_CARD_SB16
	alsa_card_sb16_init();
#endif
#ifdef CONFIG_SND_CARD_WAVEFRONT
	alsa_card_wavefront_init();
#endif

#ifdef CONFIG_SND_CARD_AD1848
	alsa_card_ad1848_init();
#endif
#ifdef CONFIG_SND_CARD_CS4231
	alsa_card_cs4231_init();
#endif
#ifdef CONFIG_SND_CARD_ES1688
	alsa_card_es1688_init();
#endif
#ifdef CONFIG_SND_CARD_GUSEXTREME
	alsa_card_gusextreme_init();
#endif
#ifdef CONFIG_SND_CARD_GUSMAX
	alsa_card_gusmax_init();
#endif
#ifdef CONFIG_SND_CARD_GUSCLASSIC
	alsa_card_gusclassic_init();
#endif
#ifdef CONFIG_SND_CARD_MOZART
	alsa_card_mozart_init();
#endif
#ifdef CONFIG_SND_CARD_SB8
	alsa_card_sb8_init();
#endif
#ifdef CONFIG_SND_CARD_SERIAL
	alsa_card_serial_init();
#endif

#ifdef CONFIG_SND_CARD_DUMMY
	alsa_card_dummy_init();
#endif
#ifdef CONFIG_SND_CARD_SHARE
	alsa_card_share_init();
#endif

	alsa_init_show();
	return 0;
}

#endif
