/*
 *  ALSA sequencer main module
 *  Copyright (c) 1998-1999 by Frank van de Pol <frank@vande-pol.demon.nl>
 *
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#define SND_MAIN_OBJECT_FILE
#include "../../include/driver.h"

#include "../../include/seq_kernel.h"
#include "seq_clientmgr.h"
#include "seq_memory.h"
#include "seq_queue.h"
#include "seq_lock.h"
#include "seq_timer.h"
#include "seq_system.h"
#include "seq_info.h"
#include "../../include/seq_device.h"

int snd_seq_client_load[64] = {63, 62, [2 ... 63] = -1};
int snd_seq_default_timer = SND_TIMER_TYPE_GLOBAL | SND_TIMER_GLOBAL_SYSTEM;
int snd_seq_default_timer_resolution = 250;	/* Hz */

MODULE_AUTHOR("Frank van de Pol <frank@vande-pol.demon.nl>, Jaroslav Kysela <perex@suse.cz>");
MODULE_DESCRIPTION("Advanced Linux Sound Architecture sequencer.");
MODULE_SUPPORTED_DEVICE("sound");

MODULE_PARM(snd_seq_client_load, "i");
MODULE_PARM_DESC(snd_seq_client_load, "The numbers of global (system) clients to load through kmod.");
MODULE_PARM(snd_seq_default_timer, "i");
MODULE_PARM_DESC(snd_seq_default_timer, "The default timer number.");
MODULE_PARM(snd_seq_default_timer_resolution, "i");
MODULE_PARM_DESC(snd_seq_default_timer_resolution, "The default timer resolution in Hz.");

/*
 *  INIT PART
 */


#ifdef MODULE
int __init init_module(void)
#else
int alsa_seq_init(void)
#endif
{
	client_init_data();

	/* init memory, room for selected events */
	snd_sequencer_memory_init();

	/* init event queues */
	snd_seq_queues_init();

	/* register sequencer device */
	snd_sequencer_device_init();

	/* register proc interface */
	snd_seq_info_init();

	/* register our internal client */
	snd_seq_system_client_init();

	return 0;
}

#ifdef MODULE

void __exit cleanup_module(void)
{
	/* unregister our internal client */
	snd_seq_system_client_done();

	/* unregister proc interface */
	snd_seq_info_done();
	
	/* delete timing queues */
	snd_seq_queues_delete();

	/* unregister sequencer device */
	snd_sequencer_device_done();

	/* release event memory */
	snd_sequencer_memory_done();
}

#endif

  /* seq_lock.c */
EXPORT_SYMBOL(snd_seq_sleep_in_lock);
EXPORT_SYMBOL(snd_seq_sleep_timeout_in_lock);
EXPORT_SYMBOL(snd_use_lock_init);
EXPORT_SYMBOL(snd_use_lock_use);
EXPORT_SYMBOL(snd_use_lock_inc);
EXPORT_SYMBOL(snd_use_lock_free);
EXPORT_SYMBOL(snd_use_lock_wait);
EXPORT_SYMBOL(snd_use_lock_terminate);
  /* seq_clientmgr.c */
EXPORT_SYMBOL(snd_seq_create_kernel_client);
EXPORT_SYMBOL(snd_seq_delete_kernel_client);
EXPORT_SYMBOL(snd_seq_kernel_client_enqueue);
EXPORT_SYMBOL(snd_seq_kernel_client_enqueue_blocking);
EXPORT_SYMBOL(snd_seq_kernel_client_dispatch);
EXPORT_SYMBOL(snd_seq_kernel_client_ctl);
EXPORT_SYMBOL(snd_seq_kernel_client_write_poll);
  /* seq_memory.c */
EXPORT_SYMBOL(snd_seq_ext_malloc);
EXPORT_SYMBOL(snd_seq_ext_free);
EXPORT_SYMBOL(snd_seq_ext_ref);
  /* seq_ports.c */
EXPORT_SYMBOL(snd_port_init_callback);
EXPORT_SYMBOL(snd_port_alloc_callback);
EXPORT_SYMBOL(snd_seq_event_port_attach);
EXPORT_SYMBOL(snd_seq_event_port_detach);
