#include <GToolKit/GToolKit.h>
#include <Foundation/NSAutoreleasePool.h>
#include <Foundation/NSArray.h>
#include <Foundation/NSUtilities.h>

int main (int argc, char *argv[])
{
    NSAutoreleasePool *pool = [NSAutoreleasePool new];
    GTKWindow *window;
    GTKLabel *label;
    GTKButton *button;
    GTKVBox *box;
#ifdef LIB_FOUNDATION_LIBRARY
    extern char **environ;
    [NSProcessInfo initializeWithArguments:argv count:argc environment:environ];
#endif

    [[GTKApplication alloc] initWithArgc:&argc argv:&argv];

    window = [GTKWindow windowWithType:GTK_WINDOW_TOPLEVEL];
    [window borderWidth:10];

    button = [GTKButton buttonWithLabel:@"Quit"];
    label = [GTKLabel labelWithStr:@"Hello World!"];
    box = [GTKVBox vBoxWithHomogeneous:YES spacing:10];

    [box packStartDefaults:label];
    [box packStartDefaults:button];
    [window add:box];
    [window show];

    [button connectSignal:@"clicked" withTarget:window sel:@selector(destroy)];
    [window connectSignal:@"destroy" withTarget:GTKApp
	    sel:@selector(terminate:)];

    NSLog([[[box children] objectAtIndex:0] stringValue]);

    [GTKApp run];
    [pool release];
    return 0;
}
