/* LIBGIMP - The GIMP Library
 * Copyright (C) 1995-2003 Peter Mattis and Spencer Kimball
 *
 * gimpbrushes.c
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include "config.h"

#include <string.h>

#include "gimp.h"

/**
 * gimp_brushes_get_opacity:
 *
 * Get the brush opacity.
 *
 * This procedure is deprecated! Use 'gimp_context_get_opacity' instead.
 *
 * Returns: The brush opacity.
 */
gdouble
gimp_brushes_get_opacity (void)
{
  return gimp_context_get_opacity ();
}

/**
 * gimp_brushes_set_opacity:
 * @opacity: The brush opacity.
 *
 * Set the brush opacity.
 *
 * This procedure is deprecated! Use 'gimp_context_set_opacity' instead.
 *
 * Returns: TRUE on success.
 */
gboolean
gimp_brushes_set_opacity (gdouble opacity)
{
  return gimp_context_set_opacity (opacity);
}

/**
 * gimp_brushes_get_paint_mode:
 *
 * Get the brush paint mode.
 *
 * This procedure isdeprecated! Use 'gimp_context_get_paint_mode' instead.
 *
 * Returns: The paint mode.
 */
GimpLayerModeEffects
gimp_brushes_get_paint_mode (void)
{
  return gimp_context_get_paint_mode ();
}

/**
 * gimp_brushes_set_paint_mode:
 * @paint_mode: The paint mode.
 *
 * Set the brush paint mode.
 *
 * This procedure is deprecated! Use 'gimp_context_set_paint_mode' instead.
 *
 * Returns: TRUE on success.
 */
gboolean
gimp_brushes_set_paint_mode (GimpLayerModeEffects paint_mode)
{
  return gimp_context_set_paint_mode (paint_mode);
}

/**
 * gimp_brushes_set_brush:
 * @name: The brush name.
 *
 * Set the specified brush as the active brush.
 *
 * This procedure is deprecated! Use 'gimp_context_set_brush' instead.
 *
 * Returns: TRUE on success.
 */
gboolean
gimp_brushes_set_brush (const gchar *name)
{
  return gimp_context_set_brush (name);
}
