package Gimp::Config;

=cut

=head1 NAME

  Gimp::Config - config options found during configure time.

=head1 DESCRIPTION

The Gimp::Config module creates a tied hash %Gimp::Config which contains
all the definitions the configure script and perl deduced from the system
configuration at configure time. You can access these values just like you
access any other values, i.e.  C<$Gimp::Config{KEY}>. Some important keys are:

  IN_GIMP	=> true when gimp-perl was part of the Gimp distribution.
  GIMP		=> the path of the gimp executable
  prefix	=> the installation prefix
  libdir	=> the gimp systemwide libdir
  bindir	=> paths where gimp binaries are installed
  gimpplugindir	=> the gimp plug-in directory (without the /plug-ins-suffix)

=head1 SEE ALSO

L<Gimp>.

=cut

sub TIEHASH {
   my $pkg = shift;
   my $self;

   bless \$self, $pkg;
}

sub FETCH {
   $cfg{$_[1]};
}

tie %Gimp::Config, 'Gimp::Config';

%cfg = (
   top_builddir         => q[@top_builddir@],
   IN_GIMP              => q[1],
   _GIMP_INC            => q[-I./../.. -I/usr/local/lib/glib/include -I/usr/local/include -I/usr/X11R6/include -I/usr/local/lib/glib/include -I/usr/local/include -g -O2 -Wall -Wno-parentheses -Wno-unused -Wno-uninitialized],
   INC1                 => q[-I.],
   GIMPTOOL             => q[../../gimptool],
   _EXTENSIVE_TESTS     => q[0],
   GIMP                 => q[/usr/local/bin/gimp],
   INSTALL_PROGRAM      => q[/usr/bin/install -c],
   prefix               => q[/usr/local],
   _GIMP_LIBS_NOUI      => q[-L./../../libgimp/.libs -L$dirprefix/../../libgimp -lgimp -L/usr/local/lib -lglib ],
   _CPPFLAGS            => q[],
   _CFLAGS              => q[-g -O2 -Wall],
   pdl_typemaps         => q[/usr/lib/perl5/PDL/Core/typemap.pdl],
   exec_prefix          => q[/usr/local],
   _PERL                => q[/usr/bin/perl],
   _GIMP_LIBS           => q[-L./../../libgimp/.libs -L$dirprefix/../../libgimp -lgimp -L/usr/local/lib -lglib  -lgimpui],
   libdir               => q[/usr/local/lib],
   INSTALL              => q[/usr/bin/install -c],
   bindir               => q[/usr/local/bin],
   pdl_inc              => q[-I/usr/lib/perl5/PDL/Core],
   gimpplugindir        => q[/usr/local/lib/gimp/1.1],
   DEFINE1              => q[-DIN_GIMP -DHAVE_PDL=1],
   _LDFLAGS             => q[],
   _GIMP_INC_NOUI       => q[-I./../.. -I/usr/local/lib/glib/include -I/usr/local/include -I/usr/X11R6/include -I/usr/local/lib/glib/include -I/usr/local/include -g -O2 -Wall -Wno-parentheses -Wno-unused -Wno-uninitialized],
);

1;
