#!/usr/bin/perl -w

# The GIMP -- an image manipulation program
# Copyright (C) 1999-2000 Manish Singh <yosh@gimp.org>

# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUTFILE ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

BEGIN {
    $srcdir  = $ENV{srcdir}  || '.';
    $destdir = $ENV{destdir} || '.';
}

use lib $srcdir;

require 'enums.pl';
require 'util.pl';

*enums = \%Gimp::CodeGen::enums::enums;

*write_file = \&Gimp::CodeGen::util::write_file;
*FILE_EXT   = \$Gimp::CodeGen::util::FILE_EXT;

my $enumfile = "$destdir/plug-ins/script-fu/script-fu-constants.c$FILE_EXT";
open ENUMFILE, "> $enumfile" or die "Can't open $enumfile: $!\n";

print ENUMFILE <<'GPL';
/* The GIMP -- an image manipulation program
 * Copyright (C) 1995-1999 Spencer Kimball and Peter Mattis
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/* NOTE: This file is autogenerated by enumcode.pl. */

GPL

print ENUMFILE <<CODE;
#include "siod.h"

void
init_generated_constants (void)
{
CODE

foreach (sort keys %enums) {
    my $enum = $enums{$_};
    foreach $symbol (@{$enum->{symbols}}) {
	my $sym = $symbol;
	$sym = $enum->{nicks}->{$sym} if exists $enum->{nicks}->{$sym};
	$sym =~ s/_/-/g;

	print ENUMFILE <<CODE;
  setvar (cintern ("$sym"), flocons ($enum->{mapping}->{$symbol}), NIL);
CODE
    }
    print ENUMFILE "\n";
}

print ENUMFILE "  return;\n}\n";

close ENUMFILE;
&write_file($enumfile);

$enumfile = "$destdir/libgimp/gimpenums.h$FILE_EXT";
open ENUMFILE, "> $enumfile" or die "Can't open $enumfile: $!\n";

print ENUMFILE <<'LGPL';
/* LIBGIMP - The GIMP Library
 * Copyright (C) 1995-1999 Peter Mattis and Spencer Kimball
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/* NOTE: This file is autogenerated by enumcode.pl */

LGPL

my $guard = "__GIMP_ENUMS_H__";
print ENUMFILE <<HEADER;
#ifndef $guard
#define $guard

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

HEADER

foreach (sort keys %enums) {
    print ENUMFILE "typedef enum\n{\n";
    my $enum = $enums{$_}; my $body = "";
    foreach $symbol (@{$enum->{symbols}}) {
	my $sym = $symbol;
	$sym = $enum->{nicks}->{$sym} if exists $enum->{nicks}->{$sym};
	$body .= "  GIMP_$sym";
	$body .= " = $enum->{mapping}->{$symbol}" if !$enum->{contig};
	$body .= ",\n";
    }

    $body =~ s/,\n$//s;
    $body .= "\n} ";
    $body .= "Gimp" if !/^Gimp/;
    $body .= "$_;\n\n";
    print ENUMFILE $body
}

# Sigh - this is full of backwards compat hacks. We'll clean this up for 1.3

print ENUMFILE <<'CRUFT';
/* This is for backwards compatibility. Don't use these for new plug-ins. */

#ifndef GIMP_DISABLE_COMPAT_CRUFT

typedef GimpFillType GFillType;
typedef GimpImageBaseType GImageType;
typedef GimpImageType GDrawableType;
typedef GimpLayerModeEffects GLayerMode;
typedef GimpRunModeType GRunModeType;
typedef GimpOrientationType GOrientation;
typedef GimpPDBArgType GParamType;
typedef GimpPDBProcType GProcedureType;
typedef GimpPDBStatusType GStatusType;

CRUFT

@xforms = (
    { enum => 'PDBArgType', xform => [ qw(s/PDB/PARAM/) ] },
    { enum => 'PDBStatusType', xform => [ qw(s/PDB/STATUS/) ] },
    { enum => 'PDBProcType', xform => [ qw(s/^/PROC_/ s/PLUGIN/PLUG_IN/) ] },
    { enum => 'OrientationType', xform => [ qw(s/^/ORIENTATION_/) ] },
    { enum => 'GimpFillType', xform => [] },
    { enum => 'GimpImageBaseType', xform => [] },
    { enum => 'GimpImageType', xform => [] },
    { enum => 'LayerModeEffects', xform => [] },
    { enum => 'RunModeType', xform => [] },
);

foreach $xform (@xforms) {
    my $enum = $enums{$xform->{enum}};
    foreach (@{$enum->{symbols}}) {
        my $symbol = $_;
	$symbol = $enum->{nicks}->{$symbol} if exists $enum->{nicks}->{$symbol};
	my $sym = $symbol;
	foreach $xform (@{$xform->{xform}}) { eval "\$sym =~ $xform" }
	$symbol = "GIMP_$symbol";
	print ENUMFILE "#define $sym $symbol\n";
    }
    print ENUMFILE "\n";
} 

print ENUMFILE <<HEADER;
#endif /* GIMP_DISABLE_COMPAT_CRUFT */

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* $guard */
HEADER

close ENUMFILE;
&write_file($enumfile);
