/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facesconfig.ui.pageflow.properties;

import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jst.jsf.facesconfig.common.dialogfield.Separator;
import org.eclipse.jst.jsf.facesconfig.ui.EditorResources;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.util.FacesConfigUtil;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

public class ActionOutcomeSelectionDialog
extends Dialog {
    private static EditorResources resource = EditorResources.getInstance();
    private Text actionText;
    private String jspName;
    private String outcome;
    private Table actionTable;
    private static final int COMPONENT_COL_WIDTH = 160;
    private static final int ACTION_COL_WIDTH = 160;
    private static final int DIALOG_DEFAULT_WIDTH = 400;
    private static final int DIALOG_DEFAULT_HEIGHT = 300;
    public static String JSF_EL_LEFT_BRACE = "#{";
    public static String JSF_EL_RIGHT_BRACE = "}";
    private ModifyListener modifyListener;

    public ActionOutcomeSelectionDialog(Shell parentShell, String outcome, String jspName) {
        super(parentShell);
        this.outcome = outcome;
        this.jspName = jspName;
        this.modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ActionOutcomeSelectionDialog.this.verifyComplete();
            }
        };
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.marginWidth = 10;
        gridLayout.marginHeight = 10;
        container.setLayout((Layout)gridLayout);
        GridData gd = new GridData(1808);
        gd.heightHint = 300;
        gd.widthHint = 400;
        container.setLayoutData((Object)gd);
        Label choiceLabel = new Label(container, 16384);
        gd = new GridData(256);
        choiceLabel.setLayoutData((Object)gd);
        choiceLabel.setText(resource.getString("Pageflow.Property.Action.OutcomeSelectionDialog.Choice"));
        this.createOutcomeSection(container);
        this.createActionListSection(container);
        return container;
    }

    protected void createOutcomeSection(Composite container) {
        Composite outcomeSection = new Composite(container, 0);
        GridLayout gl = new GridLayout();
        gl.numColumns = 1;
        gl.marginWidth = 0;
        outcomeSection.setLayout((Layout)gl);
        GridData gd = new GridData(768);
        outcomeSection.setLayoutData((Object)gd);
        this.actionText = new Text(outcomeSection, 2048);
        gd = new GridData(768);
        this.actionText.setLayoutData((Object)gd);
        this.actionText.addModifyListener(this.modifyListener);
        if (this.outcome != null && this.outcome.length() > 0) {
            this.actionText.setText(this.outcome);
        }
    }

    protected void createActionListSection(Composite container) {
        Group actionSection = new Group(container, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        actionSection.setLayout((Layout)gridLayout);
        GridData gd = new GridData(1808);
        actionSection.setLayoutData((Object)gd);
        String actionListTitle = resource.getString("Pageflow.Property.Action.OutcomeSelectionDialog.ActionListTable.Title");
        if (this.jspName != null && this.jspName.length() > 0) {
            actionListTitle = String.valueOf(actionListTitle) + " in " + this.jspName;
        }
        actionSection.setText(actionListTitle);
        this.actionTable = new Table((Composite)actionSection, 2048);
        this.actionTable.setLayoutData((Object)new GridData(1808));
        this.actionTable.setHeaderVisible(true);
        this.actionTable.setLinesVisible(true);
        TableLayout layout = new TableLayout();
        this.actionTable.setLayout((Layout)layout);
        layout.addColumnData((ColumnLayoutData)new ColumnPixelData(160));
        layout.addColumnData((ColumnLayoutData)new ColumnPixelData(160));
        TableColumn componentCol = new TableColumn(this.actionTable, 0);
        componentCol.setText(resource.getString("Pageflow.Property.Action.OutcomeSelectionDialog.ActionListTable.Component"));
        TableColumn actionCol = new TableColumn(this.actionTable, 0);
        actionCol.setText(resource.getString("Pageflow.Property.Action.OutcomeSelectionDialog.ActionListTable.Action"));
        this.actionTable.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TableItem selItem = (TableItem)e.item;
                String action = selItem.getText(1);
                if (action != null && action.length() > 0) {
                    ActionOutcomeSelectionDialog.this.actionText.setText(action);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.addActionsInJSP();
    }

    protected void createSeparator(Composite composite, int nColumns) {
        new Separator(258).doFillIntoGrid(null, composite, nColumns, this.convertHeightInCharsToPixels(1));
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.verifyComplete();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(resource.getString("Pageflow.Property.Action.OutcomeSelectionDialog.Title"));
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 1) {
            this.setReturnCode(1);
            this.close();
            return;
        }
        if (buttonId == 0) {
            this.setReturnCode(0);
            this.outcome = this.actionText.getText();
            this.close();
            return;
        }
        super.buttonPressed(buttonId);
    }

    private void verifyComplete() {
        if (this.getButton(0) != null) {
            this.getButton(0).setEnabled(this.isDialogComplete());
        }
    }

    private boolean isDialogComplete() {
        return this.isValidName();
    }

    private boolean isValidName() {
        return this.actionText.getText().length() > 0;
    }

    public String getSelectedAction() {
        return this.outcome;
    }

    private void addActionsInJSP() {
        List actionNodes = FacesConfigUtil.getActionListInJSPFile(this.jspName);
        if (actionNodes != null) {
            int i = 0;
            while (i < actionNodes.size()) {
                Element node = (Element)actionNodes.get(i);
                String tagName = node.getTagName();
                Attr idAttr = node.getAttributeNode("id");
                String id = "";
                if (idAttr != null) {
                    id = idAttr.getNodeValue();
                }
                String componentName = String.valueOf(id) + "(" + tagName + ")";
                Attr actionAttr = node.getAttributeNode("action");
                String action = "";
                if (actionAttr != null && !ActionOutcomeSelectionDialog.isValidEL(action = actionAttr.getValue())) {
                    this.addActionTableItem(componentName, action);
                }
                ++i;
            }
        }
    }

    public static boolean isValidEL(String expressionString) {
        if (expressionString == null || expressionString.length() == 0) {
            return true;
        }
        return expressionString.startsWith(JSF_EL_LEFT_BRACE) && expressionString.endsWith(JSF_EL_RIGHT_BRACE);
    }

    private void addActionTableItem(String componentName, String action) {
        if (componentName != null && componentName.length() > 0 && action != null && action.length() > 0) {
            TableItem item = new TableItem(this.actionTable, 0);
            item.setText(0, componentName);
            item.setText(1, action);
        }
    }
}

