/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facesconfig.ui.pageflow.editpart;

import org.eclipse.core.resources.IResource;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jst.jsf.facesconfig.ui.EditorPlugin;
import org.eclipse.jst.jsf.facesconfig.ui.IconResources;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.editpart.IAnnotationEditPart;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.figure.PageflowNodeFigure;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.model.Pageflow;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.model.PageflowElement;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.model.PageflowPage;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.properties.PageflowElementPropertySource;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.synchronization.FC2PFTransformer;
import org.eclipse.jst.jsf.facesconfig.ui.util.WebrootUtil;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.views.properties.IPropertySource;

public abstract class PageflowElementEditPart
extends AbstractGraphicalEditPart
implements Adapter,
IAnnotationEditPart {
    public static final ImageDescriptor IMG_ACTION = EditorPlugin.getDefault().getImageDescriptor("facesconfig/Pageflow_Action16.gif");
    public static final ImageDescriptor IMG_PAGE = EditorPlugin.getDefault().getImageDescriptor(IconResources.getString("Pageflow.page.large"));
    public static final ImageDescriptor IMG_NODE = EditorPlugin.getDefault().getImageDescriptor(IconResources.getString("Pageflow.node.large"));
    private IPropertySource propertySource = null;
    private Notifier target = null;
    private Image image = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    protected PageflowElementEditPart(PageflowElement element) {
        this.setModel(element);
    }

    public Image getImage(PageflowElement element) {
        if (this.image == null) {
            ImageDescriptor imageDescriptor = null;
            imageDescriptor = element instanceof PageflowPage ? IMG_PAGE : IMG_NODE;
            this.image = EditorPlugin.getDefault().getImageRegistry().get(imageDescriptor.toString());
            if (this.image == null) {
                EditorPlugin.getDefault().getImageRegistry().put(imageDescriptor.toString(), imageDescriptor);
                this.image = EditorPlugin.getDefault().getImageRegistry().get(imageDescriptor.toString());
            }
        }
        return this.image;
    }

    public static String getTypeName(PageflowElement element) {
        if (element instanceof Pageflow) {
            return "Pageflow";
        }
        if (element instanceof PageflowPage) {
            return "Page";
        }
        return "[unknown]";
    }

    public void activate() {
        if (this.isActive()) {
            return;
        }
        this.hookIntoPageflowElement(this.getPageflowElement());
        super.activate();
    }

    public void deactivate() {
        if (!this.isActive()) {
            return;
        }
        this.unhookFromPageflowElement(this.getPageflowElement());
        super.deactivate();
    }

    public PageflowElement getPageflowElement() {
        return (PageflowElement)this.getModel();
    }

    public Notifier getTarget() {
        return this.target;
    }

    public boolean isAdapterForType(Object type) {
        return type.equals(this.getModel().getClass());
    }

    public void setTarget(Notifier newTarget) {
        this.target = newTarget;
    }

    protected void refreshVisuals() {
        if (this.getParent() != null) {
            Point loc = new Point(this.getPageflowElement().getX(), this.getPageflowElement().getY());
            Dimension size = new Dimension(this.getPageflowElement().getWidth(), this.getPageflowElement().getHeight());
            Rectangle r = new Rectangle(loc, size);
            ((GraphicalEditPart)this.getParent()).setLayoutConstraint((EditPart)this, this.getFigure(), (Object)r);
        }
    }

    public Object getAdapter(Class key) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.views.properties.IPropertySource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (key == clazz) {
            return this.getPropertySource();
        }
        return super.getAdapter(key);
    }

    protected IPropertySource getPropertySource() {
        if (this.propertySource == null) {
            this.propertySource = new PageflowElementPropertySource(this.getPageflowElement());
        }
        return this.propertySource;
    }

    public void notifyChanged(Notification notification) {
        int type = notification.getEventType();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.jst.jsf.facesconfig.ui.pageflow.model.PageflowPackage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        int featureId = notification.getFeatureID((Class)clazz);
        if (type == 1) {
            switch (featureId) {
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    this.refreshVisuals();
                }
            }
        }
    }

    protected void hookIntoPageflowElement(PageflowElement element) {
        if (element != null) {
            FC2PFTransformer.getInstance().adapt(element);
            if (!element.eAdapters().contains((Object)this)) {
                element.eAdapters().add((Object)this);
            }
        }
    }

    protected void unhookFromPageflowElement(PageflowElement element) {
        if (element != null) {
            element.eAdapters().remove((Object)this);
        }
    }

    protected IFigure createFigure() {
        PageflowNodeFigure figure = null;
        figure = new PageflowNodeFigure();
        PageflowElement elm = this.getPageflowElement();
        if (elm.getName() != null) {
            figure.setImageText(this.getImage(elm), elm.getName());
        } else {
            figure.setImageText(this.getImage(elm), PageflowElementEditPart.getTypeName(elm));
        }
        figure.update();
        return figure;
    }

    public void performRequest(Request request) {
        if (request.getType() == "open") {
            this.performOpen();
        } else if (request.getType() == "direct edit") {
            this.performDirectEdit();
        }
    }

    protected void performDirectEdit() {
    }

    protected void performOpen() {
    }

    public void addAnnotation(Annotation annotation) {
    }

    public void removeAnnotation() {
    }

    public IResource getMarkerResource() {
        IResource resource = WebrootUtil.getResource((EObject)this.getModel());
        return resource;
    }
}

