/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.ui.internal.properties;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jst.jsf.core.internal.JSFCorePlugin;
import org.eclipse.jst.jsf.core.internal.jsflibraryregistry.ArchiveFile;
import org.eclipse.jst.jsf.core.internal.jsflibraryregistry.JSFLibrary;
import org.eclipse.jst.jsf.core.internal.jsflibraryregistry.JSFLibraryRegistry;
import org.eclipse.jst.jsf.core.internal.jsflibraryregistry.util.IProjectJSFLibraryProvider;
import org.eclipse.jst.jsf.core.internal.jsflibraryregistry.util.ProjectJSFLibrary;
import org.eclipse.jst.jsf.ui.internal.JSFUiPlugin;
import org.eclipse.jst.jsf.ui.internal.classpath.JSFLibraryWizard;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

public class ProjectJSFLibraryControl
extends Composite {
    private IProjectJSFLibraryProvider provider = null;
    private final int COLUMN_DEPLOY = 0;
    private final int COLUMN_LIB_NAME = 1;
    private ComboViewer cvImplLib;
    private CheckboxTableViewer ctvSelCompLib;
    private Button btnDeployJars;
    private TreeViewer tvCompLib;
    private TreeViewerAdapter tvAdapter;
    private TreeLabelProvider tvLabelProvider;
    private List colJSFImpl = null;
    private List colJSFComp = null;
    private Combo comboImplLib;

    public ProjectJSFLibraryControl(Composite parent, int style) {
        super(parent, style);
    }

    public void dispose() {
        super.dispose();
    }

    protected void checkSubclass() {
    }

    public void setProjectJSFLibraryProvider(IProjectJSFLibraryProvider provider) {
        this.provider = provider;
        this.colJSFImpl = provider.getProjectJSFImplementationLibraries();
        this.colJSFComp = provider.getProjectJSFComponentLibraries();
        this.initControls();
    }

    public ProjectJSFLibrary getSelectedJSFLibImplementation() {
        ProjectJSFLibrary selJSFImpl = null;
        StructuredSelection objs = (StructuredSelection)this.cvImplLib.getSelection();
        if (objs != null && objs.getFirstElement() instanceof ProjectJSFLibrary) {
            selJSFImpl = (ProjectJSFLibrary)objs.getFirstElement();
            selJSFImpl.setDeployment(this.btnDeployJars.getSelection());
        }
        return selJSFImpl;
    }

    public List getSelectedJSFLibComponent() {
        ArrayList<ProjectJSFLibrary> list = new ArrayList<ProjectJSFLibrary>();
        Iterator it = ((List)this.ctvSelCompLib.getInput()).iterator();
        while (it.hasNext()) {
            ProjectJSFLibrary prjJSFLib = (ProjectJSFLibrary)it.next();
            prjJSFLib.setDeployment(false);
            if (!prjJSFLib.isSelected()) continue;
            Object[] checked = this.ctvSelCompLib.getCheckedElements();
            int i = 0;
            while (i < checked.length) {
                boolean toDeploy = ((ProjectJSFLibrary)checked[i]).getLibrary().getID().equals(prjJSFLib.getLibrary().getID());
                if (toDeploy) {
                    prjJSFLib.setDeployment(true);
                    break;
                }
                ++i;
            }
            list.add(prjJSFLib);
        }
        return list;
    }

    private void initializeValues() {
        this.cvImplLib.setInput((Object)this.colJSFImpl);
        this.btnDeployJars.setSelection(false);
        if (this.provider.getSelectedJSFImplementation() != null) {
            ProjectJSFLibrary selJSFImplLib = this.provider.getSelectedJSFImplementation();
            this.cvImplLib.setSelection((ISelection)new StructuredSelection((Object)selJSFImplLib), true);
            if (selJSFImplLib.needDeploy()) {
                this.btnDeployJars.setSelection(true);
            }
        }
        this.tvCompLib.setInput((Object)this.colJSFComp);
        this.ctvSelCompLib.setInput((Object)this.colJSFComp);
        ProjectJSFLibrary prjJSFLib = null;
        List jsfCompLib = this.provider.getSelectedJSFComponent();
        int i = 0;
        while (i < jsfCompLib.size()) {
            prjJSFLib = (ProjectJSFLibrary)jsfCompLib.get(i);
            this.ctvSelCompLib.setChecked((Object)prjJSFLib, prjJSFLib.needDeploy());
            ++i;
        }
    }

    private void loadJSFImplList() {
        this.cvImplLib.setInput((Object)this.colJSFImpl);
    }

    private void loadJSFCompList() {
        this.ctvSelCompLib.setInput((Object)this.colJSFComp);
        this.tvCompLib.setInput((Object)this.colJSFComp);
    }

    private void initControls() {
        this.setRedraw(true);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        gridLayout.marginLeft = 0;
        gridLayout.marginRight = 0;
        gridLayout.marginWidth = 0;
        this.setLayout((Layout)gridLayout);
        Label lblImplLib = new Label((Composite)this, 0);
        GridData gd_lbl_impl = new GridData(1, 2, false, false, 2, 1);
        lblImplLib.setLayoutData((Object)gd_lbl_impl);
        lblImplLib.setText("Implementation Library");
        this.btnDeployJars = new Button((Composite)this, 32);
        this.btnDeployJars.setLayoutData((Object)new GridData(3, 2, false, false, 2, 1));
        this.btnDeployJars.setText("Deploy jars to WEB-INF/lib");
        Composite compTest = new Composite((Composite)this, 0);
        GridLayout compgl = new GridLayout();
        compgl.numColumns = 2;
        compgl.marginLeft = 0;
        compgl.marginRight = 0;
        compgl.marginWidth = 0;
        GridData gdCompTest = new GridData(4, 4, true, false);
        gdCompTest.horizontalSpan = 4;
        compTest.setLayoutData((Object)gdCompTest);
        compTest.setLayout((Layout)compgl);
        this.cvImplLib = new ComboViewer(compTest, 8);
        this.cvImplLib.setLabelProvider((IBaseLabelProvider)new ListLabelProviderCVImplLib());
        this.cvImplLib.setContentProvider((IContentProvider)new ContentProviderCVImplLib());
        this.comboImplLib = this.cvImplLib.getCombo();
        GridData gd_cvImplLib = new GridData(4, 2, true, false, 1, 1);
        this.comboImplLib.setLayoutData((Object)gd_cvImplLib);
        Button btnNewImpl = new Button(compTest, 0);
        btnNewImpl.setLayoutData((Object)new GridData(2, 2, false, false));
        btnNewImpl.setText("New...");
        btnNewImpl.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JSFLibraryWizard wizard = new JSFLibraryWizard(true);
                IWorkbench wb = PlatformUI.getWorkbench();
                wizard.init(wb, null);
                WizardDialog dialog = new WizardDialog(wb.getActiveWorkbenchWindow().getShell(), (IWizard)wizard);
                int ret = dialog.open();
                if (ret == 0) {
                    ProjectJSFLibrary newPrjJSFLib = new ProjectJSFLibrary(wizard.getJSFLibrary(), true, true);
                    ProjectJSFLibraryControl.this.provider.getJSFLibraryRegistry().addJSFLibrary(wizard.getJSFLibrary());
                    ((List)ProjectJSFLibraryControl.this.cvImplLib.getInput()).add(newPrjJSFLib);
                    ProjectJSFLibraryControl.this.loadJSFImplList();
                    ProjectJSFLibraryControl.this.btnDeployJars.setSelection(true);
                    ProjectJSFLibraryControl.this.cvImplLib.setSelection((ISelection)new StructuredSelection((Object)newPrjJSFLib), true);
                }
            }
        });
        Label lblSeparator = new Label((Composite)this, 258);
        GridData gd_lbl_spacer = new GridData(4, 2, true, false, 4, 1);
        lblSeparator.setLayoutData((Object)gd_lbl_spacer);
        lblSeparator.setAlignment(0x1000000);
        Label lblCompLib = new Label((Composite)this, 0);
        GridData gd_lbl_complib = new GridData(4, 2, false, false, 4, 1);
        lblCompLib.setLayoutData((Object)gd_lbl_complib);
        lblCompLib.setText("Component Libraries");
        this.tvCompLib = new TreeViewer((Composite)this, 2816);
        this.tvAdapter = new TreeViewerAdapter();
        this.tvLabelProvider = new TreeLabelProvider();
        this.tvCompLib.setContentProvider((IContentProvider)this.tvAdapter);
        this.tvCompLib.setLabelProvider((IBaseLabelProvider)this.tvLabelProvider);
        this.tvCompLib.addSelectionChangedListener((ISelectionChangedListener)this.tvAdapter);
        this.tvCompLib.addDoubleClickListener((IDoubleClickListener)this.tvAdapter);
        this.tvCompLib.getTree().setLayoutData((Object)new GridData(1808));
        this.tvCompLib.addFilter((ViewerFilter)new TreeViewerFilter());
        Composite composite_buttons = new Composite((Composite)this, 0);
        composite_buttons.setLayoutData((Object)new GridData(4, 4, false, false));
        composite_buttons.setLayout((Layout)new GridLayout());
        Composite composite_Single = new Composite(composite_buttons, 0);
        composite_Single.setLayoutData((Object)new GridData(768));
        GridLayout gl_Single = new GridLayout();
        gl_Single.marginHeight = 4;
        composite_Single.setLayout((Layout)gl_Single);
        Button btnAdd = new Button(composite_Single, 0);
        btnAdd.setLayoutData((Object)new GridData(4, 2, true, false));
        btnAdd.setText("  >  ");
        Button btnRemove = new Button(composite_Single, 0);
        btnRemove.setLayoutData((Object)new GridData(4, 2, true, false));
        btnRemove.setText("  <  ");
        Composite composite_All = new Composite(composite_buttons, 0);
        composite_All.setLayoutData((Object)new GridData(768));
        GridLayout gl_All = new GridLayout();
        gl_Single.marginHeight = 4;
        composite_All.setLayout((Layout)gl_All);
        Button btnAddAll = new Button(composite_All, 0);
        btnAddAll.setLayoutData((Object)new GridData(4, 2, true, false));
        btnAddAll.setText("  >>  ");
        Button btnRemoveAll = new Button(composite_All, 0);
        btnRemoveAll.setLayoutData((Object)new GridData(4, 2, true, false));
        btnRemoveAll.setText("  <<  ");
        Composite composite_New = new Composite(composite_buttons, 0);
        composite_New.setLayoutData((Object)new GridData(768));
        GridLayout gl_New = new GridLayout();
        gl_Single.marginHeight = 4;
        composite_New.setLayout((Layout)gl_New);
        Button btnNewCompLib = new Button(composite_New, 0);
        btnNewCompLib.setLayoutData((Object)new GridData(4, 2, false, false));
        btnNewCompLib.setText("New...");
        btnNewCompLib.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JSFLibraryWizard wizard = new JSFLibraryWizard(false);
                IWorkbench wb = PlatformUI.getWorkbench();
                wizard.init(wb, null, true);
                WizardDialog dialog = new WizardDialog(wb.getActiveWorkbenchWindow().getShell(), (IWizard)wizard);
                int ret = dialog.open();
                if (ret == 0) {
                    JSFLibrary newCompLib = wizard.getJSFLibrary();
                    ProjectJSFLibrary newPrjJSFLib = new ProjectJSFLibrary(newCompLib, true, newCompLib.isDeployed());
                    ProjectJSFLibraryControl.this.provider.getJSFLibraryRegistry().addJSFLibrary(newCompLib);
                    ((List)ProjectJSFLibraryControl.this.ctvSelCompLib.getInput()).add(newPrjJSFLib);
                    ProjectJSFLibraryControl.this.loadJSFCompList();
                    ProjectJSFLibraryControl.this.ctvSelCompLib.setChecked((Object)newPrjJSFLib, true);
                }
            }
        });
        this.ctvSelCompLib = CheckboxTableViewer.newCheckList((Composite)this, (int)67586);
        this.ctvSelCompLib.addFilter((ViewerFilter)new CheckedTableViewerFilter());
        Table table = this.ctvSelCompLib.getTable();
        table.setLayoutData((Object)new GridData(4, 4, true, true));
        table.setHeaderVisible(true);
        TableColumn tcDeploy = new TableColumn(table, 16384);
        tcDeploy.setWidth(50);
        tcDeploy.setText("Deploy");
        TableColumn tcLibName = new TableColumn(table, 16384);
        tcLibName.setWidth(150);
        tcLibName.setText("Library Name");
        this.ctvSelCompLib.setSorter((ViewerSorter)new SorterCTVSelCompLib());
        this.ctvSelCompLib.setLabelProvider((IBaseLabelProvider)new TableLabelProviderCTVSelCompLib());
        this.ctvSelCompLib.setContentProvider((IContentProvider)new ContentProviderCTVCompLib());
        this.initializeValues();
        btnAdd.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                StructuredSelection sel = (StructuredSelection)ProjectJSFLibraryControl.this.tvCompLib.getSelection();
                if (sel != null && sel.getFirstElement() != null && sel.getFirstElement() instanceof ProjectJSFLibrary) {
                    ProjectJSFLibrary prjJSFLib = (ProjectJSFLibrary)sel.getFirstElement();
                    prjJSFLib.setSelected(true);
                    prjJSFLib.setDeployment(true);
                    ProjectJSFLibraryControl.this.tvCompLib.refresh();
                    ProjectJSFLibraryControl.this.ctvSelCompLib.refresh();
                    ProjectJSFLibraryControl.this.ctvSelCompLib.setChecked((Object)prjJSFLib, true);
                }
            }
        });
        btnAddAll.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                Iterator it = ((List)ProjectJSFLibraryControl.this.tvCompLib.getInput()).iterator();
                while (it.hasNext()) {
                    ProjectJSFLibrary prjJSFLib = (ProjectJSFLibrary)it.next();
                    prjJSFLib.setSelected(true);
                    prjJSFLib.setDeployment(true);
                }
                ProjectJSFLibraryControl.this.tvCompLib.refresh();
                ProjectJSFLibraryControl.this.ctvSelCompLib.refresh();
                ProjectJSFLibraryControl.this.ctvSelCompLib.setAllChecked(true);
            }
        });
        btnRemove.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                StructuredSelection sel = (StructuredSelection)ProjectJSFLibraryControl.this.ctvSelCompLib.getSelection();
                if (sel != null && sel.getFirstElement() != null) {
                    ProjectJSFLibrary prjJSFLib = (ProjectJSFLibrary)sel.getFirstElement();
                    prjJSFLib.setDeployment(false);
                    prjJSFLib.setSelected(false);
                    ProjectJSFLibraryControl.this.tvCompLib.refresh();
                    ProjectJSFLibraryControl.this.ctvSelCompLib.refresh();
                }
            }
        });
        btnRemoveAll.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                Iterator it = ((List)ProjectJSFLibraryControl.this.tvCompLib.getInput()).iterator();
                while (it.hasNext()) {
                    ProjectJSFLibrary prjJSFLib = (ProjectJSFLibrary)it.next();
                    prjJSFLib.setSelected(false);
                    prjJSFLib.setDeployment(false);
                }
                ProjectJSFLibraryControl.this.tvCompLib.refresh();
                ProjectJSFLibraryControl.this.ctvSelCompLib.refresh();
                ProjectJSFLibraryControl.this.ctvSelCompLib.setAllChecked(false);
            }
        });
    }

    class CheckedTableViewerFilter
    extends ViewerFilter {
        CheckedTableViewerFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof ProjectJSFLibrary) {
                return ((ProjectJSFLibrary)element).isSelected();
            }
            return false;
        }
    }

    class TreeViewerFilter
    extends ViewerFilter {
        TreeViewerFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof ProjectJSFLibrary) {
                return !((ProjectJSFLibrary)element).isSelected();
            }
            return true;
        }
    }

    class ContentProviderCTVCompLib
    implements IStructuredContentProvider {
        private List jsfImplLibs = new ArrayList(Collections.EMPTY_LIST);

        ContentProviderCTVCompLib() {
        }

        public Object[] getElements(Object inputElement) {
            return this.jsfImplLibs.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.jsfImplLibs = newInput == null ? Collections.EMPTY_LIST : (List)newInput;
        }
    }

    class ContentProviderCVImplLib
    implements IStructuredContentProvider {
        private List jsfImplLibs = new ArrayList(Collections.EMPTY_LIST);

        ContentProviderCVImplLib() {
        }

        public Object[] getElements(Object inputElement) {
            return this.jsfImplLibs.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.jsfImplLibs = newInput == null ? Collections.EMPTY_LIST : (List)newInput;
        }
    }

    class TableLabelProviderCTVSelCompLib
    extends LabelProvider
    implements ITableLabelProvider {
        TableLabelProviderCTVSelCompLib() {
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof ProjectJSFLibrary) {
                switch (columnIndex) {
                    case 0: {
                        return " ";
                    }
                    case 1: {
                        return ((ProjectJSFLibrary)element).getLibrary().getName();
                    }
                }
            }
            return "";
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }
    }

    class ListLabelProviderCVImplLib
    extends LabelProvider {
        private JSFLibrary defaultImpl = null;

        ListLabelProviderCVImplLib() {
        }

        public String getText(Object element) {
            if (element instanceof ProjectJSFLibrary) {
                StringBuffer nameBuf = new StringBuffer(((ProjectJSFLibrary)element).getLibrary().getName());
                if (((ProjectJSFLibrary)element).getLibrary() == this.getDefaultImpl()) {
                    nameBuf.append(" ").append(JSFLibraryRegistry.DEFAULT_IMPL_LABEL);
                }
                return nameBuf.toString();
            }
            return null;
        }

        private JSFLibrary getDefaultImpl() {
            if (this.defaultImpl == null) {
                this.defaultImpl = ProjectJSFLibraryControl.this.provider.getJSFLibraryRegistry().getDefaultImplementation();
            }
            return this.defaultImpl;
        }

        public Image getImage(Object element) {
            return null;
        }
    }

    class SorterCTVSelCompLib
    extends ViewerSorter {
        SorterCTVSelCompLib() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            if (e1 instanceof ProjectJSFLibrary && e2 instanceof ProjectJSFLibrary) {
                ProjectJSFLibrary item1 = (ProjectJSFLibrary)e1;
                ProjectJSFLibrary item2 = (ProjectJSFLibrary)e2;
                return item1.getLibrary().getName().compareToIgnoreCase(item2.getLibrary().getName());
            }
            return 0;
        }
    }

    private class TreeViewerAdapter
    implements ITreeContentProvider,
    ISelectionChangedListener,
    IDoubleClickListener {
        private final Object[] NO_ELEMENTS = new Object[0];

        private TreeViewerAdapter() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public boolean isDeleted(Object element) {
            return false;
        }

        public void dispose() {
        }

        public Object[] getElements(Object obj) {
            return ProjectJSFLibraryControl.this.provider.getProjectJSFComponentLibraries().toArray();
        }

        public Object[] getChildren(Object element) {
            if (element instanceof ProjectJSFLibrary) {
                return ((ProjectJSFLibrary)element).getLibrary().getArchiveFiles().toArray();
            }
            return this.NO_ELEMENTS;
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return element instanceof ProjectJSFLibrary;
        }

        public void selectionChanged(SelectionChangedEvent event) {
        }

        public void doubleClick(DoubleClickEvent event) {
        }
    }

    private class TreeLabelProvider
    implements ILabelProvider {
        Image libImg;
        Image jarImg;

        TreeLabelProvider() {
            if (this.jarImg == null) {
                ImageDescriptor jarImgDesc = JSFUiPlugin.getImageDescriptor("obj16/jar_obj.gif");
                this.jarImg = jarImgDesc.createImage();
            }
            if (this.libImg == null) {
                ImageDescriptor libImgDesc = JSFUiPlugin.getImageDescriptor("obj16/library_obj.gif");
                this.libImg = libImgDesc.createImage();
            }
        }

        public Image getImage(Object element) {
            if (element instanceof ProjectJSFLibrary) {
                return this.libImg;
            }
            return this.jarImg;
        }

        public String getText(Object element) {
            StringBuffer labelBuf = new StringBuffer();
            if (element instanceof ProjectJSFLibrary) {
                ProjectJSFLibrary libWrapper = (ProjectJSFLibrary)element;
                JSFLibrary lib = libWrapper.getLibrary();
                labelBuf.append(lib.getName());
                if (lib.isImplementation()) {
                    labelBuf.append(" [implementation");
                    if (lib == JSFCorePlugin.getDefault().getJSFLibraryRegistry().getDefaultImplementation()) {
                        labelBuf.append(" - default");
                    }
                    labelBuf.append("]");
                }
            }
            if (element instanceof ArchiveFile) {
                ArchiveFile jar = (ArchiveFile)element;
                labelBuf.append(jar.getName());
                if (!jar.exists()) {
                    labelBuf.append("[missing]");
                }
                labelBuf.append(" - ").append(((ArchiveFile)element).getSourceLocation());
            }
            return labelBuf.toString();
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
            if (this.libImg != null) {
                this.libImg.dispose();
            }
            if (this.jarImg != null) {
                this.jarImg.dispose();
            }
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

