/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.ui.views;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.dali.orm.AttributeMapping;
import org.eclipse.dali.orm.PersistentAttribute;
import org.eclipse.dali.orm.adapters.IAttributeMappingModelAdapter;
import org.eclipse.dali.orm.adapters.IPersistentAttributeModelAdapter;
import org.eclipse.dali.orm.adapters.java.IJavaDefaultAttributeMappingModelAdapter;
import org.eclipse.dali.orm.adapters.java.JavaPersistentAttributeModelAdapter;
import org.eclipse.dali.orm.provider.OrmItemProviderAdapterFactory;
import org.eclipse.dali.orm.provider.PersistentAttributeItemProvider;
import org.eclipse.dali.ui.DaliUiMessages;
import org.eclipse.dali.ui.views.EmptyComposite;
import org.eclipse.dali.ui.views.IMappingCompositeBuilder;
import org.eclipse.dali.ui.views.IPersistenceComposite;
import org.eclipse.dali.ui.views.NullMappingComposite;
import org.eclipse.dali.ui.views.ScrolledPageContent;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.PageBook;

public class PersistentAttributeComposite
extends Composite
implements IPersistenceComposite,
ISelectionChangedListener {
    private PersistentAttribute persistentAttribute;
    private PersistentAttributeItemProvider persistentAttributeItemProvider;
    private ComboViewer persistentAttributeTypeCombo;
    private PageBook mappingPageBook;
    private IPersistenceComposite visibleMappingComposite;
    private EditingDomain editingDomain;
    private OrmItemProviderAdapterFactory adapterFactory;
    private INotifyChangedListener mappingListener;
    private Map composites;
    private boolean populating;
    static /* synthetic */ Class class$0;

    public PersistentAttributeComposite(Composite parent, EditingDomain editingDomain) {
        super(parent, 0);
        this.editingDomain = editingDomain;
        this.adapterFactory = new OrmItemProviderAdapterFactory();
        this.persistentAttributeItemProvider = (PersistentAttributeItemProvider)this.adapterFactory.createPersistentAttributeAdapter();
        this.composites = new HashMap();
        this.initializeLayout();
    }

    private void initializeLayout() {
        this.setLayout((Layout)new FillLayout());
        ScrolledPageContent pageContent = new ScrolledPageContent(this);
        GridLayout layout = new GridLayout(2, false);
        Composite composite = pageContent.getBody();
        composite.setLayout((Layout)layout);
        Label mappingTypeLabel = new Label(composite, 16384);
        mappingTypeLabel.setText(DaliUiMessages.MappingComposite_mapAs);
        this.persistentAttributeTypeCombo = this.buildMappingTypeCombo(composite);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.persistentAttributeTypeCombo.getCombo().setLayoutData((Object)gridData);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.persistentAttributeTypeCombo.getCombo(), "org.eclipse.dali.ui.mapping_mapAs");
        this.mappingPageBook = new PageBook(composite, 0);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 2;
        this.mappingPageBook.setLayoutData((Object)gridData);
    }

    private ComboViewer buildMappingTypeCombo(Composite parent) {
        ComboViewer viewer = new ComboViewer(parent, 8);
        viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof IConfigurationElement) {
                    return ((IConfigurationElement)element).getAttribute("label");
                }
                return (String)element;
            }
        });
        viewer.setSorter(new ViewerSorter(){

            public int category(Object element) {
                if (((IConfigurationElement)element).getDeclaringExtension().getExtensionPointUniqueIdentifier().equals("org.eclipse.dali.ui.defaultMappings")) {
                    return 0;
                }
                return 1;
            }
        });
        viewer.add((Object[])this.mappingChoices());
        viewer.addSelectionChangedListener((ISelectionChangedListener)this);
        return viewer;
    }

    private IConfigurationElement[] mappingChoices() {
        return Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.dali.ui.mappings");
    }

    private IConfigurationElement[] defaultMappingChoices() {
        return Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.dali.ui.defaultMappings");
    }

    private IConfigurationElement configurationElementFor(String mappingName) {
        IConfigurationElement[] elements = this.mappingChoices();
        String mappingNameExtensionAttribute = ((IPersistentAttributeModelAdapter)this.persistentAttribute.getModelAdapter()).attributeMappingNameExtensionAttribute();
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement element = elements[i];
            String elementMappingName = element.getAttribute(mappingNameExtensionAttribute);
            if (elementMappingName != null && elementMappingName.equals(mappingName)) {
                return element;
            }
            ++i;
        }
        return null;
    }

    private IConfigurationElement defaultConfigurationElementFor(PersistentAttribute persistentAttribute) {
        if (persistentAttribute.getModelAdapter() instanceof JavaPersistentAttributeModelAdapter) {
            IConfigurationElement[] elements = this.defaultMappingChoices();
            int i = 0;
            while (i < elements.length) {
                IJavaDefaultAttributeMappingModelAdapter adapter;
                IConfigurationElement element = elements[i];
                try {
                    adapter = (IJavaDefaultAttributeMappingModelAdapter)element.createExecutableExtension("javaModelAdapter");
                }
                catch (CoreException e) {
                    throw new RuntimeException(e);
                }
                if (adapter.defaultApplies(((JavaPersistentAttributeModelAdapter)persistentAttribute.getModelAdapter()).getAttribute(), this.persistentAttribute)) {
                    return element;
                }
                ++i;
            }
        }
        return null;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (this.populating) {
            return;
        }
        if (this.persistentAttributeTypeCombo.getCombo().isFocusControl() && event.getSelection() instanceof StructuredSelection) {
            IConfigurationElement selection = (IConfigurationElement)((StructuredSelection)event.getSelection()).getFirstElement();
            if (selection == null) {
                return;
            }
            boolean defaultSelected = selection.getDeclaringExtension().getExtensionPointUniqueIdentifier().equals("org.eclipse.dali.ui.defaultMappings");
            this.persistentAttribute.setAttributeMappingKey(selection.getAttribute("key"), defaultSelected);
        }
    }

    public void populate(EObject mapping) {
        this.disenageListeners();
        this.persistentAttribute = (PersistentAttribute)mapping;
        if (this.persistentAttribute == null) {
            return;
        }
        this.engageListeners();
        this.populate(this.persistentAttribute.getAttributeMapping());
    }

    private void engageListeners() {
        this.persistentAttributeItemProvider.addListener(this.getMappingListener());
        this.persistentAttribute.eAdapters().add((Object)this.persistentAttributeItemProvider);
    }

    private void disenageListeners() {
        if (this.persistentAttribute != null) {
            this.persistentAttribute.eAdapters().remove((Object)this.persistentAttributeItemProvider);
            this.persistentAttributeItemProvider.removeListener(this.getMappingListener());
        }
    }

    private void populate(AttributeMapping attributeMapping) {
        if (this.isDisposed()) {
            return;
        }
        this.populating = true;
        IConfigurationElement configurationElement = null;
        this.replaceDefaultMappingChoice();
        if (attributeMapping.isDefault()) {
            configurationElement = this.defaultConfigurationElementFor(this.persistentAttribute);
        } else {
            String mappingName = ((IAttributeMappingModelAdapter)attributeMapping.getModelAdapter()).attributeMappingName();
            configurationElement = this.configurationElementFor(mappingName);
        }
        IPersistenceComposite newMappingComposite = null;
        if (configurationElement != null) {
            this.persistentAttributeTypeCombo.setSelection((ISelection)new StructuredSelection((Object)configurationElement));
            newMappingComposite = this.persistenceCompositeFor(configurationElement);
        } else {
            newMappingComposite = new NullMappingComposite((Composite)this.mappingPageBook);
            new EmptyComposite((Composite)this.mappingPageBook, "");
            this.persistentAttributeTypeCombo.setSelection(null);
        }
        if (this.visibleMappingComposite != null) {
            this.visibleMappingComposite.populate(null);
        }
        this.visibleMappingComposite = newMappingComposite;
        this.mappingPageBook.showPage((Control)this.visibleMappingComposite);
        this.visibleMappingComposite.populate((EObject)attributeMapping);
        this.populating = false;
    }

    private IPersistenceComposite persistenceCompositeFor(IConfigurationElement configurationElement) {
        IPersistenceComposite persistenceComposite = (IPersistenceComposite)this.composites.get(configurationElement);
        if (persistenceComposite != null) {
            return persistenceComposite;
        }
        IMappingCompositeBuilder mappingCompositeBuilder = null;
        try {
            mappingCompositeBuilder = (IMappingCompositeBuilder)configurationElement.createExecutableExtension("compositeClassBuilder");
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
        persistenceComposite = mappingCompositeBuilder.buildMappingComposite((Composite)this.mappingPageBook, this.editingDomain, this.adapterFactory);
        this.composites.put(configurationElement, persistenceComposite);
        return persistenceComposite;
    }

    private void replaceDefaultMappingChoice() {
        IConfigurationElement element = (IConfigurationElement)this.persistentAttributeTypeCombo.getElementAt(0);
        if (element.getDeclaringExtension().getExtensionPointUniqueIdentifier().equals("org.eclipse.dali.ui.defaultMappings")) {
            this.persistentAttributeTypeCombo.remove((Object)element);
        }
        if ((element = this.defaultConfigurationElementFor(this.persistentAttribute)) != null) {
            this.persistentAttributeTypeCombo.add((Object)element);
        }
    }

    private INotifyChangedListener getMappingListener() {
        if (this.mappingListener == null) {
            this.mappingListener = new INotifyChangedListener(){

                public void notifyChanged(Notification notification) {
                    if (PersistentAttributeComposite.this.populating) {
                        return;
                    }
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("org.eclipse.dali.orm.PersistentAttribute");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (notification.getFeatureID((Class)clazz) == 1) {
                        AttributeMapping attributeMapping = (AttributeMapping)notification.getNewValue();
                        Display.getDefault().syncExec(new Runnable(this, attributeMapping){
                            final /* synthetic */ 3 this$1;
                            private final /* synthetic */ AttributeMapping val$attributeMapping;
                            {
                                this.this$1 = var1_1;
                                this.val$attributeMapping = attributeMapping;
                            }

                            public void run() {
                                PersistentAttributeComposite.access$1(3.access$0(this.this$1), this.val$attributeMapping);
                            }
                        });
                    }
                }

                static /* synthetic */ PersistentAttributeComposite access$0(3 var0) {
                    return var0.PersistentAttributeComposite.this;
                }
            };
        }
        return this.mappingListener;
    }

    public boolean setFocus() {
        super.setFocus();
        return this.persistentAttributeTypeCombo.getCombo().setFocus();
    }

    public PersistentAttribute getPersistentAttribute() {
        return this.persistentAttribute;
    }

    public void dispose() {
        this.disenageListeners();
        Iterator i = this.composites.values().iterator();
        while (i.hasNext()) {
            ((Composite)i.next()).dispose();
        }
        super.dispose();
    }

    static /* synthetic */ void access$1(PersistentAttributeComposite persistentAttributeComposite, AttributeMapping attributeMapping) {
        persistentAttributeComposite.populate(attributeMapping);
    }
}

