/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.texteditor.stickyscroll;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.ui.internal.texteditor.stickyscroll.IStickyLine;
import org.eclipse.ui.internal.texteditor.stickyscroll.IStickyLinesProvider;
import org.eclipse.ui.internal.texteditor.stickyscroll.StickyLine;

public class DefaultStickyLinesProvider
implements IStickyLinesProvider {
    private static final int IGNORE_LINE_INDENTATION = -1;
    private static final String TAB = "\t";
    private IStickyLinesProvider.StickyLinesProperties fProperties;

    @Override
    public List<IStickyLine> getStickyLines(StyledText textWidget, int lineNumber, IStickyLinesProvider.StickyLinesProperties properties) {
        this.fProperties = properties;
        LinkedList<IStickyLine> stickyLines = new LinkedList<IStickyLine>();
        try {
            int startIndetation = this.getStartIndentation(lineNumber, textWidget);
            int i = lineNumber;
            int previousIndetation = startIndetation;
            while (i >= 0) {
                String line = textWidget.getLine(i);
                int indentation = this.getIndentation(line);
                if (indentation != -1 && indentation < previousIndetation) {
                    previousIndetation = indentation;
                    stickyLines.addFirst(new StickyLine(i, textWidget));
                }
                --i;
            }
        }
        catch (IllegalArgumentException e) {
            stickyLines.clear();
        }
        return stickyLines;
    }

    private int getStartIndentation(int startFromLine, StyledText styledText) {
        int indentation = this.getIndentation(styledText.getLine(startFromLine));
        if (indentation != -1) {
            return indentation;
        }
        int nextContentLine = this.getIndentation(this.getNextContentLine(startFromLine, styledText));
        int previousContentLine = this.getIndentation(this.getPreviousContentLine(startFromLine, styledText));
        return Math.max(nextContentLine, previousContentLine);
    }

    private String getNextContentLine(int startFromLine, StyledText styledText) {
        int i = startFromLine + 1;
        while (i < styledText.getLineCount()) {
            String line = styledText.getLine(i);
            if (!line.isBlank()) {
                return line;
            }
            ++i;
        }
        return null;
    }

    private String getPreviousContentLine(int startFromLine, StyledText styledText) {
        int i = startFromLine - 1;
        while (i >= 0) {
            String line = styledText.getLine(i);
            if (!line.isBlank()) {
                return line;
            }
            --i;
        }
        return null;
    }

    private int getIndentation(String line) {
        if (line == null || line.isBlank()) {
            return -1;
        }
        String tabAsSpaces = String.join((CharSequence)"", Collections.nCopies(this.fProperties.tabWith(), " "));
        line = line.replace(TAB, tabAsSpaces);
        return line.length() - line.stripLeading().length();
    }
}

