/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.core;

import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationMigrationDelegate;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchDelegate;
import org.eclipse.debug.core.ILaunchMode;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate;
import org.eclipse.debug.core.sourcelookup.ISourcePathComputer;
import org.eclipse.debug.internal.core.DebugCoreMessages;
import org.eclipse.debug.internal.core.LaunchConfigurationWorkingCopy;
import org.eclipse.debug.internal.core.LaunchDelegate;
import org.eclipse.debug.internal.core.LaunchManager;

public class LaunchConfigurationType
extends PlatformObject
implements ILaunchConfigurationType {
    private final IConfigurationElement fElement;
    private Set<String> fModes = null;
    private Set<Set<String>> fModeCombinations = null;
    private ISourcePathComputer fSourcePathComputer = null;
    private ILaunchConfigurationMigrationDelegate fMigrationDelegate = null;
    private String fSourceLocator = null;
    private Map<Set<String>, Set<ILaunchDelegate>> fDelegates = null;
    private LaunchDelegate fSourceProvider = null;
    private Map<Set<String>, ILaunchDelegate> fPreferredDelegates = null;

    protected LaunchConfigurationType(IConfigurationElement element) {
        this.fElement = element;
        this.initializePreferredDelegates();
    }

    @Override
    public String getAttribute(String attributeName) {
        return this.fElement.getAttribute(attributeName);
    }

    @Override
    public String getCategory() {
        return this.fElement.getAttribute("category");
    }

    @Override
    public ILaunchConfigurationDelegate getDelegate() throws CoreException {
        return this.getDelegate("run");
    }

    @Override
    public ILaunchConfigurationDelegate getDelegate(String mode) throws CoreException {
        HashSet<String> modes = new HashSet<String>();
        modes.add(mode);
        ILaunchDelegate[] delegates = this.getDelegates(modes);
        if (delegates.length > 0) {
            return delegates[0].getDelegate();
        }
        Status status = null;
        ILaunchMode launchMode = DebugPlugin.getDefault().getLaunchManager().getLaunchMode(mode);
        status = launchMode == null ? new Status(4, DebugPlugin.getUniqueIdentifier(), MessageFormat.format(DebugCoreMessages.LaunchConfigurationType_7, mode)) : new Status(4, DebugPlugin.getUniqueIdentifier(), MessageFormat.format(DebugCoreMessages.LaunchConfigurationType_7, ((LaunchManager)DebugPlugin.getDefault().getLaunchManager()).getLaunchModeName(mode)));
        throw new CoreException((IStatus)status);
    }

    @Override
    public ILaunchDelegate[] getDelegates(Set<String> modes) throws CoreException {
        this.initializeDelegates();
        Set delegates = this.fDelegates.get(modes);
        if (delegates == null) {
            delegates = Collections.EMPTY_SET;
        }
        return delegates.toArray(new ILaunchDelegate[delegates.size()]);
    }

    @Override
    public void setPreferredDelegate(Set<String> modes, ILaunchDelegate delegate) {
        if (this.fPreferredDelegates == null) {
            this.fPreferredDelegates = new HashMap<Set<String>, ILaunchDelegate>();
        }
        if (delegate == null) {
            this.fPreferredDelegates.remove(modes);
        } else {
            this.fPreferredDelegates.put(modes, delegate);
        }
        ((LaunchManager)DebugPlugin.getDefault().getLaunchManager()).persistPreferredLaunchDelegate(this);
    }

    @Override
    public ILaunchDelegate getPreferredDelegate(Set<String> modes) {
        this.initializePreferredDelegates();
        return this.fPreferredDelegates.get(modes);
    }

    public Map<Set<String>, ILaunchDelegate> getPreferredDelegates() {
        this.initializePreferredDelegates();
        return this.fPreferredDelegates;
    }

    private synchronized void initializePreferredDelegates() {
        if (this.fPreferredDelegates == null) {
            this.fPreferredDelegates = new HashMap<Set<String>, ILaunchDelegate>();
            this.initializeDelegates();
            LaunchManager lm = (LaunchManager)DebugPlugin.getDefault().getLaunchManager();
            ILaunchDelegate delegate = null;
            for (Set<String> modes : this.fDelegates.keySet()) {
                delegate = lm.getPreferredDelegate(this.getIdentifier(), modes);
                if (delegate == null) continue;
                this.fPreferredDelegates.put(modes, delegate);
            }
        }
    }

    private synchronized void initializeDelegates() {
        if (this.fDelegates == null) {
            this.fDelegates = new Hashtable<Set<String>, Set<ILaunchDelegate>>();
            LaunchDelegate[] launchDelegates = this.getLaunchDelegateExtensions();
            LaunchDelegate delegate = null;
            List<Set<String>> modelist = null;
            Set<ILaunchDelegate> tmp = null;
            LaunchDelegate[] launchDelegateArray = launchDelegates;
            int n = launchDelegates.length;
            int n2 = 0;
            while (n2 < n) {
                LaunchDelegate launchDelegate;
                delegate = launchDelegate = launchDelegateArray[n2];
                modelist = delegate.getModes();
                for (Set<String> modes : modelist) {
                    tmp = this.fDelegates.get(modes);
                    if (tmp == null) {
                        tmp = new HashSet<ILaunchDelegate>();
                        this.fDelegates.put(modes, tmp);
                    }
                    tmp.add(delegate);
                }
                ++n2;
            }
        }
    }

    private LaunchDelegate[] getLaunchDelegateExtensions() {
        return ((LaunchManager)DebugPlugin.getDefault().getLaunchManager()).getLaunchDelegates(this.getIdentifier());
    }

    @Override
    public String getIdentifier() {
        return this.fElement.getAttribute("id");
    }

    @Override
    public String getName() {
        return this.fElement.getAttribute("name");
    }

    @Override
    public String getPluginIdentifier() {
        return this.fElement.getContributor().getName();
    }

    @Override
    public String getSourceLocatorId() {
        if (this.fSourceLocator == null) {
            this.fSourceLocator = this.getAttribute("sourceLocatorId");
            if (this.fSourceProvider != null) {
                this.fSourceLocator = this.fSourceProvider.getSourceLocatorId();
            }
            if (this.fSourceLocator == null) {
                LaunchDelegate[] delegates;
                LaunchDelegate[] launchDelegateArray = delegates = this.getLaunchDelegateExtensions();
                int n = delegates.length;
                int n2 = 0;
                while (n2 < n) {
                    LaunchDelegate delegate = launchDelegateArray[n2];
                    this.fSourceLocator = delegate.getSourceLocatorId();
                    if (this.fSourceLocator != null) {
                        this.fSourceProvider = delegate;
                        return this.fSourceLocator;
                    }
                    ++n2;
                }
                this.fSourceProvider = null;
            }
        }
        return this.fSourceLocator;
    }

    @Override
    public ISourcePathComputer getSourcePathComputer() {
        if (this.fSourcePathComputer == null) {
            String id = this.fElement.getAttribute("sourcePathComputerId");
            if (this.fSourceProvider != null) {
                id = this.fSourceProvider.getSourcePathComputerId();
            }
            if (id != null) {
                this.fSourcePathComputer = DebugPlugin.getDefault().getLaunchManager().getSourcePathComputer(id);
            } else {
                LaunchDelegate[] delegates;
                LaunchDelegate[] launchDelegateArray = delegates = this.getLaunchDelegateExtensions();
                int n = delegates.length;
                int n2 = 0;
                while (n2 < n) {
                    LaunchDelegate delegate = launchDelegateArray[n2];
                    id = delegate.getSourcePathComputerId();
                    if (id != null) {
                        this.fSourceProvider = delegate;
                        this.fSourcePathComputer = DebugPlugin.getDefault().getLaunchManager().getSourcePathComputer(id);
                        if (this.fSourcePathComputer != null) {
                            return this.fSourcePathComputer;
                        }
                    }
                    ++n2;
                }
                this.fSourceProvider = null;
            }
        }
        return this.fSourcePathComputer;
    }

    @Override
    public Set<String> getSupportedModes() {
        if (this.fModes == null) {
            this.fModes = new HashSet<String>();
            LaunchDelegate[] delegates = this.getLaunchDelegateExtensions();
            List<Set<String>> modesets = null;
            LaunchDelegate[] launchDelegateArray = delegates;
            int n = delegates.length;
            int n2 = 0;
            while (n2 < n) {
                LaunchDelegate delegate = launchDelegateArray[n2];
                modesets = delegate.getModes();
                for (Set<String> modes : modesets) {
                    this.fModes.addAll(modes);
                }
                ++n2;
            }
        }
        return this.fModes;
    }

    @Override
    public Set<Set<String>> getSupportedModeCombinations() {
        if (this.fModeCombinations == null) {
            this.initializeDelegates();
            this.fModeCombinations = this.fDelegates.keySet();
        }
        return Collections.unmodifiableSet(this.fModeCombinations);
    }

    public boolean isMigrationCandidate(ILaunchConfiguration candidate) throws CoreException {
        this.initializeMigrationDelegate();
        if (this.fMigrationDelegate != null) {
            return this.fMigrationDelegate.isCandidate(candidate);
        }
        return false;
    }

    private synchronized void initializeMigrationDelegate() throws CoreException {
        if (this.fElement.getAttribute("migrationDelegate") != null && this.fMigrationDelegate == null) {
            this.fMigrationDelegate = (ILaunchConfigurationMigrationDelegate)this.fElement.createExecutableExtension("migrationDelegate");
        }
    }

    @Override
    public boolean isPublic() {
        String publicString = this.fElement.getAttribute("public");
        return publicString == null || !publicString.equalsIgnoreCase("false");
    }

    public void migrate(ILaunchConfiguration candidate) throws CoreException {
        this.initializeMigrationDelegate();
        if (this.fMigrationDelegate != null) {
            this.fMigrationDelegate.migrate(candidate);
        }
    }

    @Override
    public ILaunchConfigurationWorkingCopy newInstance(IContainer container, String name) throws CoreException {
        IPath path = IPath.fromOSString((String)name);
        if (container == null && path.segmentCount() > 1) {
            throw new CoreException((IStatus)new Status(4, DebugPlugin.getUniqueIdentifier(), DebugCoreMessages.LaunchConfigurationType_2));
        }
        try {
            DebugPlugin.getDefault().getLaunchManager().isValidLaunchConfigurationName(path.lastSegment());
        }
        catch (IllegalArgumentException e) {
            throw new CoreException((IStatus)new Status(4, DebugPlugin.getUniqueIdentifier(), e.getMessage(), (Throwable)e));
        }
        return new LaunchConfigurationWorkingCopy(container, name, this);
    }

    @Override
    public boolean supportsMode(String mode) {
        if (this.fModeCombinations == null) {
            this.getSupportedModeCombinations();
        }
        for (Set<String> modes : this.fModeCombinations) {
            if (modes.size() != 1 || !modes.contains(mode)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getContributorName() {
        return this.fElement.getContributor().getName();
    }

    @Override
    public boolean supportsModeCombination(Set<String> modes) {
        if (this.fModeCombinations == null) {
            this.getSupportedModeCombinations();
        }
        return this.fModeCombinations.contains(modes);
    }

    void resetPreferredDelegates() {
        this.fPreferredDelegates = null;
    }

    @Override
    public ILaunchConfiguration[] getPrototypes() throws CoreException {
        return DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations(this, 2);
    }

    @Override
    public ILaunchConfigurationWorkingCopy newPrototypeInstance(IContainer container, String name) throws CoreException {
        LaunchConfigurationWorkingCopy wc = new LaunchConfigurationWorkingCopy(container, name, this, true);
        return wc;
    }

    @Override
    public boolean supportsPrototypes() {
        String allowPrototypesString = this.fElement.getAttribute("allowPrototypes");
        return allowPrototypesString != null && allowPrototypesString.equalsIgnoreCase("true");
    }

    @Override
    public boolean supportsCommandLine() {
        String allowPrototypesString = this.fElement.getAttribute("allowCommandLine");
        return allowPrototypesString != null && allowPrototypesString.equalsIgnoreCase("true");
    }

    @Override
    public boolean supportsOutputMerging() {
        String allowOutputMergingString = this.fElement.getAttribute("allowOutputMerging");
        return allowOutputMergingString != null && allowOutputMergingString.equalsIgnoreCase("true");
    }
}

