/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.internal.core.refactoring;

import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.internal.core.refactoring.Changes;
import org.eclipse.ltk.internal.core.refactoring.Lock;
import org.eclipse.ltk.internal.core.refactoring.TextChanges;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.UndoEdit;

public class UndoDocumentChange
extends Change {
    private String fName;
    private UndoEdit fUndo;
    private IDocument fDocument;
    private int fLength;

    public UndoDocumentChange(String name, IDocument document, UndoEdit undo) {
        this.fName = name;
        this.fUndo = undo;
        this.fDocument = document;
    }

    @Override
    public String getName() {
        return this.fName;
    }

    @Override
    public Object getModifiedElement() {
        return null;
    }

    @Override
    public void initializeValidationData(IProgressMonitor pm) {
        this.fLength = this.fDocument.getLength();
    }

    @Override
    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException {
        if (pm == null) {
            pm = new NullProgressMonitor();
        }
        pm.beginTask("", 1);
        RefactoringStatus result = TextChanges.isValid(this.fDocument, this.fLength);
        pm.worked(1);
        return result;
    }

    @Override
    public Change perform(IProgressMonitor pm) throws CoreException {
        try {
            UndoEdit redo = this.performEdits();
            UndoDocumentChange result = new UndoDocumentChange(this.getName(), this.fDocument, redo);
            return result;
        }
        catch (MalformedTreeException e) {
            throw Changes.asCoreException(e);
        }
        catch (BadLocationException e) {
            throw Changes.asCoreException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UndoEdit performEdits() throws BadLocationException, MalformedTreeException {
        ITextFileBufferManager fileBufferManager = FileBuffers.getTextFileBufferManager();
        ITextFileBuffer fileBuffer = fileBufferManager.getTextFileBuffer(this.fDocument);
        if (fileBuffer == null || !fileBuffer.isSynchronizationContextRequested()) {
            return this.fUndo.apply(this.fDocument, 1);
        }
        Lock completionLock = new Lock();
        UndoEdit[] result = new UndoEdit[1];
        BadLocationException[] exception = new BadLocationException[1];
        Runnable runnable = () -> {
            Lock lock2 = completionLock;
            synchronized (lock2) {
                block8: {
                    try {
                        try {
                            undoEditArray[0] = this.fUndo.apply(this.fDocument, 1);
                        }
                        catch (BadLocationException e) {
                            badLocationExceptionArray[0] = e;
                            lock.fDone = true;
                            completionLock.notifyAll();
                            break block8;
                        }
                    }
                    catch (Throwable throwable) {
                        lock.fDone = true;
                        completionLock.notifyAll();
                        throw throwable;
                    }
                    lock.fDone = true;
                    completionLock.notifyAll();
                }
            }
        };
        Lock lock = completionLock;
        synchronized (lock) {
            fileBufferManager.execute(runnable);
            while (!completionLock.fDone) {
                try {
                    completionLock.wait(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        if (exception[0] != null) {
            throw exception[0];
        }
        return result[0];
    }
}

