/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.ui.scripts.repository.impl;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ease.Logger;
import org.eclipse.ease.ui.scripts.repository.IRepositoryService;
import org.eclipse.ease.ui.scripts.repository.IScriptLocation;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;

public class GithubParser {
    private static final String BASE_URL = "https://api.github.com/repos";
    private static final String RAW_CONTENT_BASE_URL = "https://raw.githubusercontent.com";
    private static final String CONTENT = "contents";
    private static final String GIT = "git";
    private static final String GIT_EXTENSION = ".git";
    private static final String TREE = "trees";
    private static final String RECURSIVE = "?recursive=1";
    private static final String BRANCH = "master";
    private static final String BLOB = "blob";
    private static final String SEPARATOR = "/";
    private static final String JSON_TREE_LABEL = "tree";
    private static final String JSON_PATH_LABEL = "path";
    private static final String JSON_SHA_LABEL = "sha";
    private static final String JSON_TYPE_LABEL = "type";
    private static final String JSON_BLOB_LABEL = "blob";

    public static boolean checkBundle() {
        Bundle gsonBundle = Platform.getBundle((String)"com.google.gson");
        if (gsonBundle == null) {
            Logger.info((String)"org.eclipse.ease.ui.scripts", (String)"Bundle: com.google.gson is not loaded");
            return false;
        }
        Logger.info((String)"org.eclipse.ease.ui.scripts", (String)"Bundle: com.google.gson is loaded");
        return true;
    }

    public static boolean isLocationValid(String location) {
        if (location == null) {
            return false;
        }
        String regex = "(http(s)?)(://)((www.)?github.com)(/)([\\w]+(-+(\\w)+)*)(/)(\\w|_|-|.)+(.git)$";
        return Pattern.matches("(http(s)?)(://)((www.)?github.com)(/)([\\w]+(-+(\\w)+)*)(/)(\\w|_|-|.)+(.git)$", location);
    }

    public void parse(String location, IScriptLocation entry) {
        IRepositoryService repositoryService = (IRepositoryService)PlatformUI.getWorkbench().getService(IRepositoryService.class);
        Map<String, String> scripts = this.fetchRemoteScripts(location, entry.isRecursive());
        for (Map.Entry<String, String> script : scripts.entrySet()) {
            String scriptUrl = this.getRawContentUrl(location, script.getValue()).replaceAll(" ", "%20");
            repositoryService.updateLocation(entry, scriptUrl, new Date().getTime());
        }
    }

    private Map<String, String> fetchRemoteScripts(String location, boolean isRecursive) {
        HashMap<String, String> scripts = new HashMap<String, String>();
        String contentTreeUrl = this.getContentTreeUrl(location);
        JsonParser jsonParser = new JsonParser();
        try {
            Throwable throwable = null;
            Object var7_9 = null;
            try (InputStreamReader reader = new InputStreamReader(new URL(contentTreeUrl).openStream());){
                JsonObject rootObject = jsonParser.parse((Reader)reader).getAsJsonObject();
                if (rootObject == null) {
                    return scripts;
                }
                JsonArray projectTree = rootObject.getAsJsonArray(JSON_TREE_LABEL);
                if (projectTree == null) {
                    return scripts;
                }
                for (JsonElement element : projectTree) {
                    JsonObject object = element.getAsJsonObject();
                    if (object == null) continue;
                    String scriptPath = object.get(JSON_PATH_LABEL).getAsString();
                    String scriptName = scriptPath.contains(SEPARATOR) ? this.getScriptName(scriptPath) : scriptPath;
                    String scriptSHA = object.get(JSON_SHA_LABEL).getAsString();
                    String scriptType = object.get(JSON_TYPE_LABEL).getAsString();
                    if (scriptType == null && scriptName == null && scriptSHA == null && scriptType == null || !"blob".equals(scriptType)) continue;
                    String repositoryName = this.getRepositoryName(location);
                    String relativeScriptPath = this.getRelativeScriptPath(location);
                    if (repositoryName == null) continue;
                    if (isRecursive) {
                        if (!repositoryName.equals(relativeScriptPath) && !scriptPath.startsWith(relativeScriptPath)) continue;
                        scripts.put(scriptSHA, scriptPath);
                        continue;
                    }
                    if ((!repositoryName.equals(relativeScriptPath) || scriptPath.contains(SEPARATOR)) && !scriptPath.endsWith(String.valueOf(relativeScriptPath) + SEPARATOR + scriptName)) continue;
                    scripts.put(scriptSHA, scriptPath);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            Logger.error((String)"org.eclipse.ease.ui.scripts", (String)("Unable to fetch content: " + e.getMessage()));
        }
        return scripts;
    }

    private String getRepositoryName(String location) {
        String[] tokens = location.split(SEPARATOR);
        if (tokens.length >= 5) {
            return location.endsWith(GIT_EXTENSION) ? tokens[4].substring(0, tokens[4].length() - 4) : tokens[4].substring(0);
        }
        return null;
    }

    private String getRelativeScriptPath(String location) {
        String[] tokens = location.split(SEPARATOR);
        String relativeScriptPath = tokens[tokens.length - 1].replaceAll("%20", " ");
        if (relativeScriptPath.endsWith(GIT_EXTENSION)) {
            relativeScriptPath = relativeScriptPath.substring(0, relativeScriptPath.length() - GIT_EXTENSION.length());
        }
        return relativeScriptPath;
    }

    private String getScriptName(String path) {
        if (path != null) {
            return path.substring(path.lastIndexOf(SEPARATOR) + 1, path.length());
        }
        return null;
    }

    private String getRawContentUrl(String location, String scriptRelativePath) {
        StringBuilder rawContentUrl = new StringBuilder(RAW_CONTENT_BASE_URL);
        String[] tokens = location.split(SEPARATOR);
        String userName = tokens[3];
        String repositoryName = this.getRepositoryName(location);
        rawContentUrl.append(SEPARATOR + userName);
        rawContentUrl.append(SEPARATOR + repositoryName);
        rawContentUrl.append("/master");
        rawContentUrl.append(SEPARATOR + scriptRelativePath);
        return rawContentUrl.toString();
    }

    private String getContentTreeUrl(String location) {
        StringBuilder contentTreeUrl = new StringBuilder(BASE_URL);
        String[] tokens = location.split(SEPARATOR);
        String userName = tokens[3];
        String repositoryName = tokens[4].endsWith(GIT_EXTENSION) ? tokens[4].substring(0, tokens[4].length() - 4) : tokens[4];
        contentTreeUrl.append(SEPARATOR + userName);
        contentTreeUrl.append(SEPARATOR + repositoryName);
        contentTreeUrl.append("/git");
        contentTreeUrl.append("/trees");
        contentTreeUrl.append("/master?recursive=1");
        return contentTreeUrl.toString();
    }
}

