/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.codegen;

public class FloatCache {
    private static final int[] EMPTY_INTS = new int[0];
    private static final float[] EMPTY_FLOATS = new float[0];
    private float[] keyTable;
    private int[] valueTable;
    private int elementSize = 0;

    public FloatCache() {
        this.keyTable = EMPTY_FLOATS;
        this.valueTable = EMPTY_INTS;
    }

    public FloatCache(int initialCapacity) {
        this.keyTable = new float[initialCapacity];
        this.valueTable = new int[initialCapacity];
    }

    public void clear() {
        this.elementSize = 0;
        this.keyTable = EMPTY_FLOATS;
        this.valueTable = EMPTY_INTS;
    }

    public boolean containsKey(float key) {
        if (key == 0.0f) {
            int i = 0;
            int max = this.elementSize;
            while (i < max) {
                if (this.keyTable[i] == 0.0f) {
                    int value1 = Float.floatToIntBits(key);
                    int value2 = Float.floatToIntBits(this.keyTable[i]);
                    if (value1 == Integer.MIN_VALUE && value2 == Integer.MIN_VALUE) {
                        return true;
                    }
                    if (value1 == 0 && value2 == 0) {
                        return true;
                    }
                }
                ++i;
            }
        } else {
            int i = 0;
            int max = this.elementSize;
            while (i < max) {
                if (this.keyTable[i] == key) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public int putIfAbsent(float key, int value) {
        if (key == 0.0f) {
            int value1 = Float.floatToIntBits(key);
            int i = 0;
            int max = this.elementSize;
            while (i < max) {
                int value2;
                if (this.keyTable[i] == 0.0f && value1 == (value2 = Float.floatToIntBits(this.keyTable[i]))) {
                    return this.valueTable[i];
                }
                ++i;
            }
        } else {
            int i = 0;
            int max = this.elementSize;
            while (i < max) {
                if (this.keyTable[i] == key) {
                    return this.valueTable[i];
                }
                ++i;
            }
        }
        if (this.elementSize == this.keyTable.length) {
            int newSize = Math.max(13, this.elementSize * 2);
            this.keyTable = new float[newSize];
            System.arraycopy(this.keyTable, 0, this.keyTable, 0, this.elementSize);
            this.valueTable = new int[newSize];
            System.arraycopy(this.valueTable, 0, this.valueTable, 0, this.elementSize);
        }
        this.keyTable[this.elementSize] = key;
        this.valueTable[this.elementSize] = value;
        ++this.elementSize;
        return -value;
    }

    public String toString() {
        int max = this.elementSize;
        StringBuilder buf = new StringBuilder();
        buf.append("{");
        int i = 0;
        while (i < max) {
            if (this.keyTable[i] != 0.0f || this.keyTable[i] == 0.0f && this.valueTable[i] != 0) {
                buf.append(this.keyTable[i]).append("->").append(this.valueTable[i]);
            }
            if (i < max) {
                buf.append(", ");
            }
            ++i;
        }
        buf.append("}");
        return buf.toString();
    }
}

