/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.core.refactoring;

import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CreateChangeOperation;
import org.eclipse.ltk.core.refactoring.IUndoManager;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.internal.core.refactoring.NotCancelableProgressMonitor;

public class PerformChangeOperation
implements IWorkspaceRunnable {
    private Change fChange;
    private CreateChangeOperation fCreateChangeOperation;
    private RefactoringStatus fValidationStatus;
    private Change fUndoChange;
    private String fUndoName;
    private IUndoManager fUndoManager;
    private boolean fChangeExecuted;
    private boolean fChangeExecutionFailed;
    private ISchedulingRule fSchedulingRule;

    public PerformChangeOperation(Change change) {
        Assert.isNotNull((Object)change);
        this.fChange = change;
        this.fSchedulingRule = ResourcesPlugin.getWorkspace().getRoot();
    }

    public PerformChangeOperation(CreateChangeOperation op) {
        Assert.isNotNull((Object)op);
        this.fCreateChangeOperation = op;
        this.fSchedulingRule = ResourcesPlugin.getWorkspace().getRoot();
    }

    public boolean changeExecutionFailed() {
        return this.fChangeExecutionFailed;
    }

    public boolean changeExecuted() {
        return this.fChangeExecuted;
    }

    public RefactoringStatus getConditionCheckingStatus() {
        if (this.fCreateChangeOperation != null) {
            return this.fCreateChangeOperation.getConditionCheckingStatus();
        }
        return null;
    }

    public Change getChange() {
        return this.fChange;
    }

    public Change getUndoChange() {
        return this.fUndoChange;
    }

    public RefactoringStatus getValidationStatus() {
        return this.fValidationStatus;
    }

    public void setUndoManager(IUndoManager manager, String undoName) {
        if (manager != null) {
            Assert.isNotNull((Object)undoName);
        }
        this.fUndoManager = manager;
        this.fUndoName = undoName;
    }

    public void setSchedulingRule(ISchedulingRule rule) {
        this.fSchedulingRule = rule;
    }

    public void run(IProgressMonitor pm) throws CoreException {
        SubMonitor subMon = SubMonitor.convert((IProgressMonitor)pm, (int)4);
        try {
            this.fChangeExecuted = false;
            if (this.createChange()) {
                this.fCreateChangeOperation.run((IProgressMonitor)subMon.split(3));
                this.fChange = this.fCreateChangeOperation.getChange();
                if (this.fChange != null) {
                    this.executeChange((IProgressMonitor)subMon.newChild(1));
                }
            } else {
                this.executeChange((IProgressMonitor)subMon.newChild(4));
            }
        }
        finally {
            subMon.done();
        }
    }

    protected void executeChange(IProgressMonitor pm) throws CoreException {
        this.fChangeExecuted = false;
        if (!this.fChange.isEnabled()) {
            return;
        }
        IWorkspaceRunnable runnable = monitor -> {
            boolean undoInitialized = false;
            try {
                SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (int)11);
                this.fValidationStatus = this.fChange.isValid((IProgressMonitor)subMon.newChild(1));
                if (this.fValidationStatus.hasFatalError()) {
                    return;
                }
                try {
                    boolean aboutToPerformChangeCalled = false;
                    try {
                        if (this.fUndoManager != null) {
                            ResourcesPlugin.getWorkspace().checkpoint(false);
                            this.fUndoManager.aboutToPerformChange(this.fChange);
                            aboutToPerformChangeCalled = true;
                        }
                        this.fChangeExecutionFailed = true;
                        this.fUndoChange = this.fChange.perform((IProgressMonitor)subMon.newChild(9));
                        this.fChangeExecutionFailed = false;
                        this.fChangeExecuted = true;
                    }
                    catch (Throwable throwable) {
                        if (this.fUndoManager != null) {
                            ResourcesPlugin.getWorkspace().checkpoint(false);
                            if (aboutToPerformChangeCalled) {
                                this.fUndoManager.changePerformed(this.fChange, !this.fChangeExecutionFailed);
                            }
                        }
                        throw throwable;
                    }
                    if (this.fUndoManager != null) {
                        ResourcesPlugin.getWorkspace().checkpoint(false);
                        if (aboutToPerformChangeCalled) {
                            this.fUndoManager.changePerformed(this.fChange, !this.fChangeExecutionFailed);
                        }
                    }
                    this.fChange.dispose();
                    if (this.fUndoChange != null) {
                        this.fUndoChange.initializeValidationData((IProgressMonitor)new NotCancelableProgressMonitor((IProgressMonitor)subMon.newChild(1)));
                        undoInitialized = true;
                    }
                    if (this.fUndoManager != null) {
                        if (this.fUndoChange != null) {
                            this.fUndoManager.addUndo(this.fUndoName, this.fUndoChange);
                        } else {
                            this.fUndoManager.flush();
                        }
                    }
                }
                catch (RuntimeException | CoreException e) {
                    if (this.fUndoManager != null) {
                        this.fUndoManager.flush();
                    }
                    if (this.fUndoChange != null && undoInitialized) {
                        Change ch = this.fUndoChange;
                        this.fUndoChange = null;
                        ch.dispose();
                    }
                    this.fUndoChange = null;
                    throw e;
                }
            }
            finally {
                monitor.done();
            }
        };
        ResourcesPlugin.getWorkspace().run(runnable, this.fSchedulingRule, 1, pm);
    }

    private boolean createChange() {
        return this.fCreateChangeOperation != null;
    }
}

