/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.text.codemining;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.internal.text.codemining.CodeMiningManager;
import org.eclipse.jface.internal.text.codemining.ICodeMiningAnnotation;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.codemining.ICodeMining;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.inlined.LineHeaderAnnotation;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public class CodeMiningLineHeaderAnnotation
extends LineHeaderAnnotation
implements ICodeMiningAnnotation {
    private static final String SEPARATOR = " | ";
    private ICodeMining[] fResolvedMinings = null;
    private final List<ICodeMining> fMinings = new ArrayList<ICodeMining>();
    private final List<Rectangle> fBounds = new ArrayList<Rectangle>();
    private IProgressMonitor fMonitor;

    public CodeMiningLineHeaderAnnotation(Position position, ISourceViewer viewer) {
        this(position, viewer, null, null, null);
    }

    public CodeMiningLineHeaderAnnotation(Position position, ISourceViewer viewer, Consumer<MouseEvent> onMouseHover, Consumer<MouseEvent> onMouseOut, Consumer<MouseEvent> onMouseMove) {
        super(position, viewer, onMouseHover, onMouseOut, onMouseMove);
    }

    @Override
    public int getHeight() {
        return CodeMiningLineHeaderAnnotation.hasAtLeastOneResolvedMiningNotEmpty(this.fMinings, this.fResolvedMinings) ? CodeMiningLineHeaderAnnotation.getMultilineHeight(null, this.fMinings, super.getTextWidget(), super.getHeight()) : 0;
    }

    public int getHeight(GC gc) {
        return CodeMiningLineHeaderAnnotation.hasAtLeastOneResolvedMiningNotEmpty(this.fMinings, this.fResolvedMinings) ? CodeMiningLineHeaderAnnotation.getMultilineHeight(gc, this.fMinings, super.getTextWidget(), super.getHeight()) : 0;
    }

    static int getMultilineHeight(GC gc, List<ICodeMining> minings, StyledText styledText, int superHeight) {
        int numLinesOfAllMinings = 0;
        boolean ignoreFirstLine = false;
        int sumLineHeight = 0;
        int i = 0;
        while (i < minings.size()) {
            ICodeMining mining = minings.get(i);
            String label = mining.getLabel();
            if (label != null) {
                String[] splitted = label.split("\\r?\\n|\\r");
                int numLines = splitted.length;
                if (ignoreFirstLine) {
                    --numLines;
                }
                numLinesOfAllMinings += numLines;
                if (gc != null) {
                    sumLineHeight = CodeMiningLineHeaderAnnotation.calculateLineHeight(minings, gc, styledText, ignoreFirstLine, sumLineHeight, i, splitted);
                }
                ignoreFirstLine = true;
            }
            ++i;
        }
        if (sumLineHeight == 0 && numLinesOfAllMinings == 0) {
            return superHeight;
        }
        if (gc != null) {
            return sumLineHeight;
        }
        int lineHeight = styledText.getLineHeight();
        int result = numLinesOfAllMinings * (lineHeight + styledText.getLineSpacing());
        return result;
    }

    private static int calculateLineHeight(List<ICodeMining> minings, GC gc, StyledText styledText, boolean ignoreFirstLine, int sumLineHeight, int miningIndex, String[] splitted) {
        int j = 0;
        while (j < splitted.length) {
            Object line = splitted[j];
            if (j != 0 || !ignoreFirstLine) {
                String nextLabel;
                if (j == splitted.length - 1 && miningIndex + 1 < minings.size() && (nextLabel = minings.get(miningIndex + 1).getLabel()) != null) {
                    String firstFromNext = nextLabel.split("\\r?\\n|\\r")[0];
                    line = (String)line + firstFromNext;
                }
                Point ext = gc.textExtent((String)line);
                sumLineHeight += ext.y + styledText.getLineSpacing();
            }
            ++j;
        }
        return sumLineHeight;
    }

    static boolean hasAtLeastOneResolvedMiningNotEmpty(List<ICodeMining> minings, ICodeMining[] resolvedMinings) {
        if (minings.stream().anyMatch(m -> m.getLabel() != null && !m.getLabel().isEmpty())) {
            return true;
        }
        if (resolvedMinings == null || resolvedMinings.length == 0) {
            return false;
        }
        return Stream.of(resolvedMinings).anyMatch(CodeMiningManager::isValidMining);
    }

    @Override
    public void update(List<ICodeMining> minings, IProgressMonitor monitor) {
        if (this.fResolvedMinings == null || this.fResolvedMinings.length != minings.size()) {
            this.fResolvedMinings = new ICodeMining[minings.size()];
        }
        int length = Math.min(this.fMinings.size(), minings.size());
        int i = 0;
        while (i < length) {
            ICodeMining mining = this.fMinings.get(i);
            if (mining.getLabel() != null) {
                this.fResolvedMinings[i] = mining;
            }
            ++i;
        }
        CodeMiningLineHeaderAnnotation.disposeMinings(this.fMinings);
        this.fMonitor = monitor;
        this.fMinings.addAll(minings);
    }

    public void markDeleted(boolean deleted) {
        super.markDeleted(deleted);
        if (deleted) {
            CodeMiningLineHeaderAnnotation.disposeMinings(this.fMinings);
            this.fResolvedMinings = null;
        }
    }

    static void disposeMinings(List<ICodeMining> minings) {
        minings.stream().forEach(ICodeMining::dispose);
        minings.clear();
    }

    @Override
    public void draw(GC gc, StyledText textWidget, int offset, int length, Color color, int x, int y) {
        int singleLineHeight = super.getHeight();
        CodeMiningLineHeaderAnnotation.draw(this.fMinings, this.fBounds, singleLineHeight, this.fResolvedMinings, gc, textWidget, color, x, y, this::redraw);
    }

    static void draw(List<ICodeMining> pMinings, List<Rectangle> fBounds, int singleLineHeight, ICodeMining[] fResolvedMinings, GC gc, StyledText textWidget, Color color, int x, int y, Runnable redrawRunnable) {
        ArrayList<ICodeMining> minings = new ArrayList<ICodeMining>(pMinings);
        int nbDraw = 0;
        int separatorWidth = -1;
        boolean redrawn = false;
        fBounds.clear();
        int lineSpacing = textWidget.getLineSpacing();
        int i = 0;
        while (i < minings.size()) {
            ICodeMining lastResolvedMining;
            ICodeMining mining = (ICodeMining)minings.get(i);
            ICodeMining iCodeMining = lastResolvedMining = fResolvedMinings != null && fResolvedMinings.length > i ? fResolvedMinings[i] : null;
            if (mining.getLabel() != null) {
                if (fResolvedMinings != null) {
                    fResolvedMinings[i] = mining;
                }
            } else if (!mining.isResolved()) {
                mining = lastResolvedMining;
                if (!redrawn) {
                    redrawRunnable.run();
                    redrawn = true;
                }
            } else {
                mining = lastResolvedMining;
            }
            if (CodeMiningManager.isValidMining(mining)) {
                if (nbDraw > 0) {
                    gc.drawText(SEPARATOR, x, y);
                    if (separatorWidth == -1) {
                        separatorWidth = gc.stringExtent((String)SEPARATOR).x;
                    }
                    x += separatorWidth;
                }
                Point loc = null;
                if (mining != null) {
                    loc = mining.draw(gc, textWidget, color, x, y);
                }
                if (loc != null) {
                    fBounds.add(new Rectangle(x, y, loc.x, loc.y));
                    x += loc.x;
                    if (loc.y > singleLineHeight) {
                        y += loc.y + lineSpacing - singleLineHeight;
                    }
                }
                ++nbDraw;
            }
            ++i;
        }
    }

    @Override
    public void redraw() {
        ArrayList<ICodeMining> minings = new ArrayList<ICodeMining>(this.fMinings);
        for (ICodeMining mining : minings) {
            if (mining.isResolved()) continue;
            mining.resolve(this.getViewer(), this.fMonitor).thenRunAsync(() -> this.redraw());
            return;
        }
        super.redraw();
    }

    @Override
    public Consumer<MouseEvent> getAction(MouseEvent e) {
        ICodeMining mining = CodeMiningManager.getValidCodeMiningAtLocation(this.fResolvedMinings, this.fBounds, e.x, e.y);
        return mining != null ? mining.getAction() : null;
    }

    @Override
    public boolean isInVisibleLines() {
        return super.isInVisibleLines();
    }
}

