/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.analysis.xml.core.module;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.Messages;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.compile.AnalysisCompilationData;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.compile.TmfXmlStateSystemPathCu;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.DataDrivenStateSystemPath;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.module.IXmlStateSystemContainer;
import org.eclipse.tracecompass.internal.tmf.core.model.TmfXyResponseFactory;
import org.eclipse.tracecompass.internal.tmf.core.model.filters.FetchParametersUtils;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.tmf.analysis.xml.core.module.TmfXmlUtils;
import org.eclipse.tracecompass.tmf.core.model.AbstractTmfTraceDataProvider;
import org.eclipse.tracecompass.tmf.core.model.CommonStatusMessage;
import org.eclipse.tracecompass.tmf.core.model.YModel;
import org.eclipse.tracecompass.tmf.core.model.filters.SelectionTimeQueryFilter;
import org.eclipse.tracecompass.tmf.core.model.filters.TimeQueryFilter;
import org.eclipse.tracecompass.tmf.core.model.tree.ITmfTreeDataModel;
import org.eclipse.tracecompass.tmf.core.model.tree.TmfTreeDataModel;
import org.eclipse.tracecompass.tmf.core.model.tree.TmfTreeModel;
import org.eclipse.tracecompass.tmf.core.model.xy.ITmfTreeXYDataProvider;
import org.eclipse.tracecompass.tmf.core.model.xy.ITmfXyModel;
import org.eclipse.tracecompass.tmf.core.model.xy.IYModel;
import org.eclipse.tracecompass.tmf.core.response.ITmfResponse;
import org.eclipse.tracecompass.tmf.core.response.TmfModelResponse;
import org.eclipse.tracecompass.tmf.core.statesystem.ITmfAnalysisModuleWithStateSystems;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;
import org.w3c.dom.Element;

@NonNullByDefault
public class XmlXYDataProvider
extends AbstractTmfTraceDataProvider
implements ITmfTreeXYDataProvider<ITmfTreeDataModel> {
    private static final String TITLE = Objects.requireNonNull(Messages.XmlDataProvider_DefaultXYTitle);
    public static final String ID = "org.eclipse.tracecompass.tmf.analysis.xml.core.module.XmlXYDataProvider";
    private static final String SPLIT_STRING = "/";
    private static final Pattern WILDCARD_PATTERN = Pattern.compile("\\*");
    private static final AtomicLong ENTRY_IDS = new AtomicLong();
    private final ReentrantReadWriteLock fLock = new ReentrantReadWriteLock(false);
    private final BiMap<Long, Integer> fIdToQuark = HashBiMap.create();
    private final BiMap<Integer, String> fQuarkToString = HashBiMap.create();
    private final long fTraceId = ENTRY_IDS.getAndIncrement();
    private @Nullable TmfModelResponse<TmfTreeModel<ITmfTreeDataModel>> fCached;
    private final DataDrivenStateSystemPath fDisplay;
    private final XmlXYEntry fXmlEntry;
    private final @Nullable DataDrivenStateSystemPath fSeriesNameAttrib;

    private XmlXYDataProvider(ITmfTrace trace, XmlXYEntry entry, DataDrivenStateSystemPath displayPath, @Nullable DataDrivenStateSystemPath seriesName) {
        super(trace);
        this.fXmlEntry = entry;
        this.fDisplay = displayPath;
        this.fSeriesNameAttrib = seriesName;
    }

    public static @Nullable XmlXYDataProvider create(ITmfTrace trace, Set<String> analysisIds, Element entryElement) {
        ITmfAnalysisModuleWithStateSystems ss = XmlXYDataProvider.getStateSystemFromAnalyses(analysisIds, trace);
        if (ss == null) {
            return null;
        }
        AnalysisCompilationData compilationData = new AnalysisCompilationData();
        String path = entryElement.hasAttribute("path") ? entryElement.getAttribute("path") : "*";
        XmlXYEntry entry = new XmlXYEntry(ss, path, entryElement, compilationData);
        List<@NonNull Element> displayElements = TmfXmlUtils.getChildElements(entryElement, "display");
        if (displayElements.isEmpty()) {
            return null;
        }
        Element displayElement = displayElements.get(0);
        TmfXmlStateSystemPathCu display = TmfXmlStateSystemPathCu.compile(entry.getAnalysisCompilationData(), Collections.singletonList(displayElement));
        if (display == null) {
            return null;
        }
        List<Element> seriesNameElements = TmfXmlUtils.getChildElements(entryElement, "name");
        DataDrivenStateSystemPath seriesName = null;
        if (!seriesNameElements.isEmpty()) {
            Element seriesNameElement = seriesNameElements.get(0);
            TmfXmlStateSystemPathCu seriesNameCu = TmfXmlStateSystemPathCu.compile(entry.getAnalysisCompilationData(), Collections.singletonList(seriesNameElement));
            if (seriesNameCu != null) {
                seriesName = seriesNameCu.generate();
            }
        }
        return new XmlXYDataProvider(trace, entry, display.generate(), seriesName);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public TmfModelResponse<ITmfXyModel> fetchXY(Map<String, Object> fetchParameters, @Nullable IProgressMonitor monitor) {
        DataDrivenStateSystemPath display = this.fDisplay;
        XmlXYEntry entry = this.fXmlEntry;
        ITmfStateSystem ss = entry.getStateSystem();
        TimeQueryFilter filter = FetchParametersUtils.createTimeQuery(fetchParameters);
        if (filter == null) {
            return TmfXyResponseFactory.createFailedResponse((String)CommonStatusMessage.INCORRECT_QUERY_PARAMETERS);
        }
        long[] xValues = filter.getTimesRequested();
        Map<Integer, IYModel> map = this.initSeries(fetchParameters);
        if (map.isEmpty()) {
            return TmfXyResponseFactory.create((String)TITLE, (long[])xValues, Collections.emptyList(), (boolean)true);
        }
        long currentEnd = ss.getCurrentEndTime();
        try {
            int i = 0;
            while (i < xValues.length) {
                if (monitor != null && monitor.isCanceled()) {
                    return TmfXyResponseFactory.createCancelledResponse((String)CommonStatusMessage.TASK_CANCELLED);
                }
                long time = xValues[i];
                if (time > currentEnd) break;
                if (ss.getStartTime() <= time) {
                    @NonNull List full = ss.queryFullState(time);
                    for (Map.Entry<Integer, IYModel> series : map.entrySet()) {
                        int attributeQuark = display.getQuark(series.getKey(), entry);
                        if (attributeQuark < 0 || attributeQuark >= full.size()) continue;
                        Object value = ((ITmfStateInterval)full.get(attributeQuark)).getValue();
                        series.getValue().getData()[i] = XmlXYDataProvider.extractValue(value);
                    }
                }
                ++i;
            }
            for (Map.Entry<Integer, IYModel> series : map.entrySet()) {
                if (!entry.getType().equals((Object)DisplayType.DELTA)) continue;
                XmlXYDataProvider.getSeriesDelta(series.getValue().getData());
            }
        }
        catch (StateSystemDisposedException e) {
            return TmfXyResponseFactory.createFailedResponse((String)e.getMessage());
        }
        boolean complete = ss.waitUntilBuilt(0L) || filter.getEnd() <= currentEnd;
        return TmfXyResponseFactory.create((String)TITLE, (long[])xValues, map.values(), (boolean)complete);
    }

    private Map<Integer, IYModel> initSeries(Map<String, Object> parameters) {
        SelectionTimeQueryFilter filter = FetchParametersUtils.createSelectionTimeQuery(parameters);
        if (filter == null) {
            return Collections.emptyMap();
        }
        this.fLock.readLock().lock();
        try {
            HashMap<Integer, IYModel> map = new HashMap<Integer, IYModel>();
            int length = filter.getTimesRequested().length;
            for (Long id : filter.getSelectedItems()) {
                Integer quark = (Integer)this.fIdToQuark.get((Object)id);
                if (quark == null) continue;
                String name = String.valueOf(this.fQuarkToString.get((Object)quark));
                map.put(quark, (IYModel)new YModel(id.longValue(), name, new double[length]));
            }
            HashMap<Integer, IYModel> hashMap = map;
            return hashMap;
        }
        finally {
            this.fLock.readLock().unlock();
        }
    }

    private static void getSeriesDelta(double[] data) {
        double prevData = data[0];
        data[0] = 0.0;
        int i = 1;
        while (i < data.length) {
            double current = data[i];
            data[i] = current - prevData;
            prevData = current;
            ++i;
        }
        data[0] = data[1];
    }

    private static double extractValue(@Nullable Object val) {
        if (val instanceof Number) {
            return ((Number)val).doubleValue();
        }
        return 0.0;
    }

    private static @Nullable ITmfAnalysisModuleWithStateSystems getStateSystemFromAnalyses(Set<String> analysisIds, ITmfTrace trace) {
        @Nullable ITmfAnalysisModuleWithStateSystems stateSystemModule = null;
        if (analysisIds.isEmpty()) {
            stateSystemModule = (ITmfAnalysisModuleWithStateSystems)Iterables.getFirst((Iterable)TmfTraceUtils.getAnalysisModulesOfClass((ITmfTrace)trace, ITmfAnalysisModuleWithStateSystems.class), null);
        } else {
            for (String moduleId : analysisIds) {
                ITmfAnalysisModuleWithStateSystems module = (ITmfAnalysisModuleWithStateSystems)TmfTraceUtils.getAnalysisModuleOfClass((ITmfTrace)trace, ITmfAnalysisModuleWithStateSystems.class, (String)moduleId);
                if (module == null) continue;
                stateSystemModule = module;
                break;
            }
        }
        if (stateSystemModule != null) {
            stateSystemModule.schedule();
        }
        return stateSystemModule;
    }

    public TmfModelResponse<TmfTreeModel<ITmfTreeDataModel>> fetchTree(Map<String, Object> fetchParameters, @Nullable IProgressMonitor monitor) {
        this.fLock.readLock().lock();
        try {
            if (this.fCached != null) {
                TmfModelResponse<TmfTreeModel<ITmfTreeDataModel>> tmfModelResponse = this.fCached;
                return tmfModelResponse;
            }
        }
        finally {
            this.fLock.readLock().unlock();
        }
        ITmfStateSystem ss = this.fXmlEntry.getStateSystem();
        DataDrivenStateSystemPath seriesNameAttrib = this.fSeriesNameAttrib;
        boolean isComplete = ss.waitUntilBuilt(0L);
        List<Integer> quarks = this.fXmlEntry.getQuarks();
        this.fLock.writeLock().lock();
        try {
            List fullState = ss.queryFullState(ss.getCurrentEndTime());
            ImmutableList.Builder builder = ImmutableList.builder();
            builder.add((Object)new TmfTreeDataModel(this.fTraceId, -1L, Collections.singletonList(this.getTrace().getName())));
            for (int quark : quarks) {
                int seriesNameQuark;
                Object value;
                String seriesName = ss.getAttributeName(quark);
                if (seriesNameAttrib != null && (value = ((ITmfStateInterval)fullState.get(seriesNameQuark = seriesNameAttrib.getQuark(quark, this.fXmlEntry))).getValue()) != null) {
                    seriesName = String.valueOf(value);
                }
                if (seriesName.isEmpty()) continue;
                String tempSeriesName = seriesName;
                String uniqueName = (String)this.fQuarkToString.computeIfAbsent((Object)quark, q -> this.getUniqueNameFor(tempSeriesName));
                Long id = (Long)this.fIdToQuark.inverse().computeIfAbsent((Object)quark, q -> ENTRY_IDS.getAndIncrement());
                builder.add((Object)new TmfTreeDataModel(id.longValue(), this.fTraceId, Collections.singletonList(uniqueName)));
            }
            ImmutableList list = builder.build();
            if (isComplete) {
                TmfModelResponse tmfModelResponse;
                this.fCached = tmfModelResponse = new TmfModelResponse((Object)new TmfTreeModel(Collections.emptyList(), (List)list), ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
                TmfModelResponse tmfModelResponse2 = tmfModelResponse;
                return tmfModelResponse2;
            }
            TmfModelResponse tmfModelResponse = new TmfModelResponse((Object)new TmfTreeModel(Collections.emptyList(), (List)list), ITmfResponse.Status.RUNNING, CommonStatusMessage.RUNNING);
            return tmfModelResponse;
        }
        catch (StateSystemDisposedException stateSystemDisposedException) {
            TmfModelResponse tmfModelResponse = new TmfModelResponse(null, ITmfResponse.Status.FAILED, CommonStatusMessage.STATE_SYSTEM_FAILED);
            return tmfModelResponse;
        }
        finally {
            this.fLock.writeLock().unlock();
        }
    }

    private String getUniqueNameFor(String seriesName) {
        Integer quark = (Integer)this.fQuarkToString.inverse().get((Object)seriesName);
        int index = 1;
        String newName = seriesName;
        while (quark != null) {
            newName = String.valueOf(seriesName) + '(' + index + ')';
            quark = (Integer)this.fQuarkToString.inverse().get((Object)newName);
            ++index;
        }
        return newName;
    }

    public String getId() {
        return ID;
    }

    private static enum DisplayType {
        ABSOLUTE,
        DELTA;

    }

    private static class XmlXYEntry
    implements IXmlStateSystemContainer {
        private final ITmfAnalysisModuleWithStateSystems fStateSystemModule;
        private final String fPath;
        private final DisplayType fType;
        private final AnalysisCompilationData fCompilationData;

        /*
         * Exception decompiling
         */
        public XmlXYEntry(ITmfAnalysisModuleWithStateSystems stateSystem, String path, Element entryElement, AnalysisCompilationData compilationData) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Can't sort instructions [@NONE, blocks:[4] lbl24 : CaseStatement: default:\u000a, @NONE, blocks:[4] lbl24 : CaseStatement: default:\u000a]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:25)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:8)
             *     at java.base/java.util.TimSort.countRunAndMakeAscending(TimSort.java:360)
             *     at java.base/java.util.TimSort.sort(TimSort.java:220)
             *     at java.base/java.util.Arrays.sort(Arrays.java:1308)
             *     at java.base/java.util.ArrayList.sort(ArrayList.java:1804)
             *     at java.base/java.util.Collections.sort(Collections.java:178)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.buildSwitchCases(SwitchReplacer.java:271)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitch(SwitchReplacer.java:258)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:66)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public @Nullable String getAttributeValue(@Nullable String name) {
            return name;
        }

        @Override
        public ITmfStateSystem getStateSystem() {
            this.fStateSystemModule.waitForInitialization();
            Iterator stateSystems = this.fStateSystemModule.getStateSystems().iterator();
            if (!stateSystems.hasNext()) {
                throw new NullPointerException("Analysis " + this.fStateSystemModule.getId() + " has no state system");
            }
            return (ITmfStateSystem)stateSystems.next();
        }

        public DisplayType getType() {
            return this.fType;
        }

        public List<Integer> getQuarks() {
            String[] paths = this.fPath.split(XmlXYDataProvider.SPLIT_STRING);
            List<Integer> quarks = Collections.singletonList(-1);
            String[] stringArray = paths;
            int n = paths.length;
            int n2 = 0;
            while (n2 < n) {
                String path = stringArray[n2];
                ArrayList<Integer> subQuarks = new ArrayList<Integer>();
                String name = WILDCARD_PATTERN.matcher(path).replaceAll(".*");
                for (int relativeQuark : quarks) {
                    subQuarks.addAll(this.getStateSystem().getSubAttributes(relativeQuark, false, name));
                }
                quarks = subQuarks;
                ++n2;
            }
            return quarks;
        }

        @Override
        public @NonNull AnalysisCompilationData getAnalysisCompilationData() {
            return this.fCompilationData;
        }
    }
}

