/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.ftrace.core.binary.header;

public class BinaryFTraceCPUDataPage {
    private final long fPageStartingOffset;
    private final long fDataStartingOffset;
    private final long fTimeStamp;
    private final long fFlags;
    private final int fSize;
    private final int fCpu;
    private BinaryFTraceCPUDataPage nextPage;

    private BinaryFTraceCPUDataPage(BinaryFTraceCPUDataPageBuilder builder) {
        this.fPageStartingOffset = builder.fBuilderPageStartingOffset;
        this.fDataStartingOffset = builder.fBuilderDataStartingOffset;
        this.fTimeStamp = builder.fBuilderTimeStamp;
        this.fFlags = builder.fBuilderFlags;
        this.fCpu = builder.fBuilderCpu;
        this.fSize = builder.fBuilderSize;
        this.nextPage = builder.builderNextPage;
    }

    public long getPageStartingOffset() {
        return this.fPageStartingOffset;
    }

    public int getSize() {
        return this.fSize;
    }

    public long getDataStartingOffset() {
        return this.fDataStartingOffset;
    }

    public long getTimeStamp() {
        return this.fTimeStamp;
    }

    public long getFlags() {
        return this.fFlags;
    }

    public int getCpu() {
        return this.fCpu;
    }

    public BinaryFTraceCPUDataPage getNextPage() {
        return this.nextPage;
    }

    /* synthetic */ BinaryFTraceCPUDataPage(BinaryFTraceCPUDataPageBuilder binaryFTraceCPUDataPageBuilder, BinaryFTraceCPUDataPage binaryFTraceCPUDataPage) {
        this(binaryFTraceCPUDataPageBuilder);
    }

    public static class BinaryFTraceCPUDataPageBuilder {
        private long fBuilderPageStartingOffset = 0L;
        private long fBuilderDataStartingOffset = 0L;
        private long fBuilderTimeStamp = 0L;
        private long fBuilderFlags = 0L;
        private int fBuilderCpu = 0;
        private int fBuilderSize = 0;
        private BinaryFTraceCPUDataPage builderNextPage = null;

        public BinaryFTraceCPUDataPageBuilder pageStartingOffset(long pageStartingOffset) {
            this.fBuilderPageStartingOffset = pageStartingOffset;
            return this;
        }

        public BinaryFTraceCPUDataPageBuilder pageDataStartingOffset(long pageDataStartingOffset) {
            this.fBuilderDataStartingOffset = pageDataStartingOffset;
            return this;
        }

        public BinaryFTraceCPUDataPageBuilder timeStamp(long timeStamp) {
            this.fBuilderTimeStamp = timeStamp;
            return this;
        }

        public BinaryFTraceCPUDataPageBuilder flags(long flags) {
            this.fBuilderFlags = flags;
            return this;
        }

        public BinaryFTraceCPUDataPageBuilder cpu(int cpu) {
            this.fBuilderCpu = cpu;
            return this;
        }

        public BinaryFTraceCPUDataPageBuilder nextPage(BinaryFTraceCPUDataPage nextPage) {
            this.builderNextPage = nextPage;
            return this;
        }

        public BinaryFTraceCPUDataPageBuilder size(int size) {
            this.fBuilderSize = size;
            return this;
        }

        public BinaryFTraceCPUDataPage build() {
            return new BinaryFTraceCPUDataPage(this, null);
        }
    }
}

