/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.lttng.ui.views.latency.listeners;

import java.text.DecimalFormat;
import java.util.Collections;
import java.util.Vector;
import org.eclipse.linuxtools.lttng.ui.views.latency.AbstractViewer;
import org.eclipse.linuxtools.lttng.ui.views.latency.HistogramViewer;
import org.eclipse.linuxtools.lttng.ui.views.latency.Messages;
import org.eclipse.linuxtools.lttng.ui.views.latency.listeners.AbstractPaintListener;
import org.eclipse.linuxtools.tmf.ui.views.histogram.HistogramScaledData;
import org.eclipse.linuxtools.tmf.ui.views.histogram.HistogramUtils;
import org.eclipse.linuxtools.tmf.ui.views.histogram.IHistogramDataModel;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class HistogramPaintListener
extends AbstractPaintListener {
    private boolean fBarIsClipped = false;
    protected HistogramScaledData fScaledData;
    protected Image fWarningImage = AbstractUIPlugin.imageDescriptorFromPlugin((String)Messages.LatencyView_tmf_UI, (String)"icons/elcl16/warning.gif").createImage((Device)Display.getCurrent());

    public HistogramPaintListener(AbstractViewer viewer) {
        super(viewer);
    }

    public int getBarWidth() {
        return this.fBarWith;
    }

    @Override
    public void dispose() {
        this.fWarningImage.dispose();
        super.dispose();
    }

    @Override
    public void scale() {
        double width = this.getWidth();
        double height = this.getHeight();
        int barWidth = this.getBarWidth();
        IHistogramDataModel model = ((HistogramViewer)this.fViewer).getModel();
        this.fScaledData = model.scaleTo((int)width, (int)height, barWidth);
        this.fYMin = 0L;
        this.fYMax = this.fScaledData.fMaxValue;
        this.fXMin = this.fScaledData.getFirstBucketTime();
        this.fXMin = this.fXMin > 0L ? this.fXMin : 0L;
        this.fXMax = this.fScaledData.getBucketEndTime(this.fScaledData.fLastBucket - 1);
        if (this.fYMax == 0L) {
            this.fXMax = 0L;
        }
    }

    @Override
    public void paintVerticalTicks(int x) {
    }

    @Override
    public void paintVerticalAxisValues(int x) {
        int zoomFactor = 1;
        zoomFactor = this.fViewer.getZoomFactor();
        if (this.fYMin >= 0L && this.fYMax != 0L) {
            this.fAxisImage.setForeground(this.fTextColor);
            this.fAxisImage.setBackground(this.fBackgroundColor);
            long yMax = this.fYMax / (long)zoomFactor;
            int nbTicks = (int)this.getHeight() / 30 + 1;
            Vector<Integer> values = new Vector<Integer>();
            boolean multipleSameValues = true;
            while (multipleSameValues) {
                double valueStep = (double)(yMax - this.fYMin) / (double)nbTicks;
                int i = 0;
                while (i < nbTicks) {
                    double currentValue = ((double)this.fYMin + (double)i * valueStep) / Math.pow(10.0, this.fDelta);
                    values.add((int)currentValue);
                    ++i;
                }
                Collections.sort(values);
                boolean hasRepetition = false;
                int i2 = 1;
                while (i2 < values.size()) {
                    if (values.get(i2) == values.get(i2 - 1)) {
                        hasRepetition = true;
                        break;
                    }
                    ++i2;
                }
                if (hasRepetition) {
                    --nbTicks;
                    values.clear();
                    continue;
                }
                multipleSameValues = false;
                int height = this.fViewer.getBounds().height - 2 * this.fPadding - this.fPaddingTop - this.fHorizontalAxisYOffset;
                this.fAxisImage.fillRectangle(0, this.fPadding + this.fPaddingTop, this.fPadding + this.fVerticalAxisOffset, height);
                double pixelStep = this.getHeight() / (double)values.size() + 1.0;
                int i3 = 0;
                while (i3 < values.size()) {
                    double currentValue = ((Integer)values.get(i3)).intValue();
                    int y = (int)((double)(this.fClientArea.height - this.fPadding - this.fHorizontalAxisYOffset) - (double)i3 * pixelStep);
                    String currentLabel = this.formatStringForVerticalAxis((long)currentValue);
                    this.fAxisImage.setFont(this.fValuesFont);
                    Point textDimensions = this.fAxisImage.stringExtent(currentLabel);
                    this.fAxisImage.drawText(currentLabel, x - textDimensions.x - 5, y - textDimensions.y / 2);
                    this.fAxisImage.drawLine(x - 3, y, x, y);
                    ++i3;
                }
            }
        }
    }

    @Override
    public void paintContent() {
        double zoomFactor = this.fViewer.getZoomFactor();
        double tmpDelta = this.fDelta;
        this.fDelta = 0;
        if (Long.toString(this.fYMax / (long)zoomFactor).length() > 5) {
            this.fDelta = Long.toString(this.fYMax / (long)zoomFactor).length() - 5;
        }
        if (tmpDelta != (double)this.fDelta) {
            this.fViewer.clearBackground();
        }
        this.paintBackground();
        this.paintVerticalAxis();
        this.paintHorizontalAxis();
        this.fAxisImage.setForeground(this.fDataColor);
        this.fAxisImage.setBackground(this.fDataColor);
        double height = this.getHeight();
        int barWidth = this.getBarWidth();
        boolean oneBarIsClipped = false;
        int i = 0;
        while (i < this.fScaledData.fData.length) {
            double barHeight;
            double pointY = this.fScaledData.fData[i];
            double x = this.fPadding + i * barWidth + this.fVerticalAxisOffset + 1;
            if (i == this.fScaledData.fData.length - 1) {
                x -= 1.0;
            }
            if ((barHeight = zoomFactor * ((pointY - (double)this.fYMin) / (double)(this.fYMax - this.fYMin)) * height) > height + 1.0) {
                barHeight = height;
                oneBarIsClipped = true;
                this.fAxisImage.drawImage(this.fWarningImage, 5, 3);
            }
            if (barHeight > 0.0) {
                double y = (double)(this.fPadding + this.fPaddingTop) + height - barHeight;
                this.fAxisImage.setBackground(this.fDataColor);
                if (barHeight > height - 1.0) {
                    this.fAxisImage.fillRectangle((int)x, (int)y, barWidth, (int)(barHeight + 1.0));
                } else {
                    this.fAxisImage.fillRectangle((int)x, (int)y, barWidth, (int)(barHeight + 2.0));
                }
            }
            ++i;
        }
        this.fBarIsClipped = oneBarIsClipped;
    }

    @Override
    public String formatStringForHorizontalAxis(long value) {
        DecimalFormat formatter = new DecimalFormat("##0.#E0");
        return formatter.format(value);
    }

    public void setBarWidth(int barWidth) {
        this.fBarWith = barWidth;
    }

    public boolean barIsClipped() {
        return this.fBarIsClipped;
    }

    @Override
    public String formatToolTipLabel(int x, int y) {
        if (this.fScaledData != null) {
            double barWidth = this.getBarWidth();
            double height = this.getHeight();
            double zoomFactor = this.fViewer.getZoomFactor();
            int index = (int)((double)(x - this.fPadding - this.fVerticalAxisOffset - 1) / barWidth);
            double barHeight = 0.0;
            if (index >= 0 && index <= this.fScaledData.fLastBucket) {
                barHeight = zoomFactor * height * (double)((long)this.fScaledData.fData[index] - this.fYMin) / (double)(this.fYMax - this.fYMin);
            }
            long fMouseY = (long)(height - (double)(y - this.fPadding - this.fPaddingTop));
            if (index >= 0 && this.fScaledData.fLastBucket >= index && fMouseY >= 0L && (double)fMouseY < barHeight && (double)fMouseY < height && x >= this.fVerticalAxisOffset + this.fPadding) {
                this.fScaledData.fCurrentBucket = index;
                long startTime = this.fScaledData.getBucketStartTime(index);
                if (startTime < 0L) {
                    startTime = 0L;
                }
                long endTime = this.fScaledData.getBucketEndTime(index);
                int nbEvents = this.fScaledData.fData[index];
                StringBuffer buffer = new StringBuffer();
                buffer.append("Latency Range in s = [");
                buffer.append(HistogramUtils.nanosecondsToString((long)startTime));
                buffer.append(",");
                buffer.append(HistogramUtils.nanosecondsToString((long)endTime));
                buffer.append("]\n");
                buffer.append("Latency count = ");
                buffer.append(nbEvents);
                return buffer.toString();
            }
        }
        return "";
    }
}

