/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.systemtap.ui.dashboard.structures;

import java.io.File;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.linuxtools.systemtap.ui.dashboard.internal.DashboardPlugin;
import org.eclipse.linuxtools.systemtap.ui.dashboard.structures.DashboardModuleTreeBuilder;
import org.eclipse.linuxtools.systemtap.ui.structures.JarArchive;
import org.eclipse.linuxtools.systemtap.ui.structures.TreeNode;
import org.eclipse.linuxtools.systemtap.ui.systemtapgui.SystemTapGUISettings;

public final class DashboardModuleLocator {
    public static final String moduleLocation = String.valueOf(SystemTapGUISettings.installDirectory) + "/.modules/";
    public static final String moduleStore = String.valueOf(SystemTapGUISettings.installDirectory) + "/plugins/org.eclipse.linuxtools.systemtap.ui.dashboard_1.0.0.jar";

    public static TreeNode getModules() {
        TreeNode root = new TreeNode(null, "", false);
        String[] locations = DashboardModuleLocator.getModuleLocations();
        DashboardModuleTreeBuilder dmtb = null;
        if (locations != null) {
            int i = 0;
            while (i < locations.length) {
                dmtb = new DashboardModuleTreeBuilder(root);
                dmtb.generateTree(new File(locations[i]));
                ++i;
            }
            root.sortTree();
        }
        return root;
    }

    public static String[] getModuleLocations() {
        String[] allFolders;
        IPreferenceStore store = DashboardPlugin.getDefault().getPreferenceStore();
        String locations = store.getString("ModuleFoldersPreference");
        String[] folders = locations.split(File.pathSeparator);
        if (locations.length() > 0) {
            allFolders = new String[folders.length + 2];
            System.arraycopy(folders, 0, allFolders, 2, folders.length);
        } else {
            allFolders = new String[2];
        }
        if (new File(moduleStore).exists()) {
            File f = new File(moduleLocation);
            if (!f.exists()) {
                f.mkdir();
                JarArchive.unjarFiles((String)moduleStore, (String)moduleLocation, (String)"modules/");
            }
            allFolders[0] = moduleLocation;
        } else {
            allFolders[0] = System.getProperty("osgi.splashLocation");
            int stapguiLoc = allFolders[0].indexOf("systemtapgui");
            if (stapguiLoc != -1) {
                allFolders[0] = allFolders[0].substring(0, stapguiLoc);
                allFolders[0] = String.valueOf(allFolders[0]) + "dashboard/modules/";
            }
        }
        allFolders[1] = SystemTapGUISettings.settingsFolder.getAbsolutePath();
        return allFolders;
    }
}

