/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.lttng.ui.views.common;

import org.eclipse.linuxtools.internal.lttng.core.state.evProcessor.ILttngEventProcessor;
import org.eclipse.linuxtools.internal.lttng.core.state.evProcessor.state.AbsStateProcessing;
import org.eclipse.linuxtools.internal.lttng.core.state.model.LttngTraceState;
import org.eclipse.linuxtools.internal.lttng.ui.views.common.ParamsUpdater;
import org.eclipse.linuxtools.tmf.core.event.TmfTimeRange;

public abstract class AbsTRangeUpdate
extends AbsStateProcessing
implements ILttngEventProcessor {
    private static final long MINORBITS = 20L;

    public long getMkdevId(long major, long minor) {
        return major << 20 | minor;
    }

    protected double getPixelsPerNs(LttngTraceState traceSt, ParamsUpdater params) {
        double pixPerNs = params.getPixelsPerNs();
        if (pixPerNs == 0.0) {
            TmfTimeRange tsetRange = traceSt.getContext().getExperimentTimeWindow();
            long startTime = tsetRange.getStartTime().getValue();
            long endTime = tsetRange.getEndTime().getValue();
            long delta = endTime - startTime;
            if (delta > 0L) {
                pixPerNs = (double)params.getWidth() / (double)delta;
                params.setPixelsPerNs(pixPerNs);
            }
        }
        return pixPerNs;
    }
}

