/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.systemtap.ui.dashboardextension.actions;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.Writer;
import java.text.MessageFormat;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.linuxtools.systemtap.ui.dashboard.DashboardPerspective;
import org.eclipse.linuxtools.systemtap.ui.dashboard.views.DashboardModuleBrowserView;
import org.eclipse.linuxtools.systemtap.ui.dashboardextension.dialogs.ExportScriptDialog;
import org.eclipse.linuxtools.systemtap.ui.dashboardextension.internal.Localization;
import org.eclipse.linuxtools.systemtap.ui.graphing.GraphingConstants;
import org.eclipse.linuxtools.systemtap.ui.graphingapi.nonui.datasets.IDataSet;
import org.eclipse.linuxtools.systemtap.ui.graphingapi.nonui.datasets.IDataSetParser;
import org.eclipse.linuxtools.systemtap.ui.graphingapi.nonui.filters.IDataSetFilter;
import org.eclipse.linuxtools.systemtap.ui.graphingapi.nonui.structures.GraphData;
import org.eclipse.linuxtools.systemtap.ui.graphingapi.ui.wizards.dataset.DataSetWizard;
import org.eclipse.linuxtools.systemtap.ui.ide.IDEPerspective;
import org.eclipse.linuxtools.systemtap.ui.ide.actions.RunScriptAction;
import org.eclipse.linuxtools.systemtap.ui.structures.TreeNode;
import org.eclipse.linuxtools.systemtap.ui.structures.ZipArchive;
import org.eclipse.linuxtools.systemtap.ui.systemtapgui.SystemTapGUISettings;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;

public class ExportScriptAction
extends RunScriptAction
implements IWorkbenchWindowActionDelegate {
    private static String scriptFileName = "/script.stp";

    public void run(IAction action) {
        String script = this.getFilePath();
        if (script == null || script.length() <= 0) {
            String msg = MessageFormat.format(Localization.getString("ExportScriptAction.NoFileToExport"), null);
            MessageDialog.openWarning((Shell)this.fWindow.getShell(), (String)Localization.getString("ExportScriptAction.Error"), (String)msg);
        } else {
            DataSetWizard wizard = new DataSetWizard(GraphingConstants.DataSetMetaData, script);
            IWorkbench workbench = PlatformUI.getWorkbench();
            wizard.init(workbench, null);
            WizardDialog dialog = new WizardDialog(workbench.getActiveWorkbenchWindow().getShell(), (IWizard)wizard);
            dialog.create();
            dialog.open();
            IDataSetParser parser = wizard.getParser();
            IDataSet dataSet = wizard.getDataSet();
            wizard.dispose();
            if (parser == null || dataSet == null) {
                return;
            }
            ExportScriptDialog exportDialog = new ExportScriptDialog(this.fWindow.getShell(), dataSet);
            exportDialog.open();
            exportDialog.dispose();
            if (!exportDialog.isCanceled()) {
                String category = exportDialog.getCategory();
                String display = exportDialog.getDisplay();
                String description = exportDialog.getDescription();
                GraphData[] gd = exportDialog.getGraphs();
                TreeNode filters = exportDialog.getGraphFilters();
                this.validateDirectory();
                File meta = this.saveMetaData(display, category, description, dataSet, parser, gd, filters, "local");
                String archiveName = String.valueOf(this.getSaveDirectory()) + "/" + category.replace(' ', '_') + "." + display.replace(' ', '_');
                this.buildArchive(archiveName, new File(script), meta);
                this.cleanupFiles(new String[]{archiveName, meta.getAbsolutePath()});
                this.updateDashboard();
            }
        }
    }

    private void validateDirectory() {
        File folder = new File(this.getSaveDirectory());
        if (!folder.exists()) {
            folder.mkdir();
        }
    }

    private File saveMetaData(String disp, String cat, String desc, IDataSet dataSet, IDataSetParser parser, GraphData[] gd, TreeNode filters, String location) {
        File meta = null;
        XMLMemento data = XMLMemento.createWriteRoot((String)"DashboardItem");
        try {
            IMemento child2;
            data.putString("display", disp);
            data.putString("category", cat);
            data.putString("description", desc);
            data.putString("dataset", dataSet.getID());
            data.putString("script", scriptFileName);
            data.putString("location", location);
            data.putString("scriptFileName", scriptFileName);
            IMemento child = data.createChild("ParsingExpressions");
            String[] cols = dataSet.getTitles();
            int i = 0;
            while (i < cols.length) {
                child2 = child.createChild("Column");
                child2.putString("name", cols[i]);
                ++i;
            }
            parser.saveXML(child.createChild("Parser"));
            child = data.createChild("GraphDisplays");
            int i2 = 0;
            while (i2 < gd.length) {
                child2 = child.createChild("Graph");
                child2.putString("id", gd[i2].graphID);
                child2.putString("title", gd[i2].title);
                TreeNode treeChild = filters.getChildAt(i2);
                int j = 0;
                while (j < treeChild.getChildCount()) {
                    ((IDataSetFilter)treeChild.getChildAt(j).getData()).writeXML(child2);
                    ++j;
                }
                IMemento child3 = child2.createChild("Series");
                child3.putString("axis", "x");
                child3.putInteger("column", gd[i2].xSeries);
                j = 0;
                while (j < gd[i2].ySeries.length) {
                    child3 = child2.createChild("Series");
                    child3.putString("axis", "y");
                    child3.putInteger("column", gd[i2].ySeries[j]);
                    ++j;
                }
                ++i2;
            }
            meta = new File(String.valueOf(this.getSaveDirectory()) + "/metaData");
            FileWriter writer = new FileWriter(meta);
            data.save((Writer)writer);
            writer.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            return meta;
        }
        catch (Exception exception) {
            return meta;
        }
        return meta;
    }

    private void buildArchive(String archiveName, File script, File meta) {
        String[] files = new String[]{script.getAbsolutePath(), meta.getAbsolutePath()};
        String[] names = new String[]{scriptFileName, "/metaData"};
        ZipArchive.zipFiles((String)archiveName, (String[])files, (String[])names);
        ZipArchive.compressFile((String)(String.valueOf(archiveName) + ".dash"), (String)archiveName);
    }

    private void cleanupFiles(String[] files) {
        if (files == null) {
            return;
        }
        int i = 0;
        while (i < files.length) {
            File f = new File(files[i]);
            if (f.exists()) {
                f.delete();
            }
            ++i;
        }
    }

    private String getSaveDirectory() {
        return SystemTapGUISettings.settingsFolder + "/dashboard";
    }

    private void updateDashboard() {
        try {
            IWorkbenchPage p = PlatformUI.getWorkbench().showPerspective(DashboardPerspective.ID, PlatformUI.getWorkbench().getActiveWorkbenchWindow());
            IViewPart ivp = p.findView("org.eclipse.linuxtools.systemtap.ui.dashboard.views.DashboardModuleBrowserView");
            ((DashboardModuleBrowserView)ivp).refresh();
            p = PlatformUI.getWorkbench().showPerspective(IDEPerspective.ID, PlatformUI.getWorkbench().getActiveWorkbenchWindow());
        }
        catch (WorkbenchException workbenchException) {}
    }

    public void dispose() {
        super.dispose();
    }
}

