/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.dataviewers.charts.dataengine;

import com.ibm.icu.util.ULocale;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.factory.Generator;
import org.eclipse.birt.chart.factory.IDataRowExpressionEvaluator;
import org.eclipse.birt.chart.factory.RunTimeContext;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.attribute.AxisType;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.attribute.IntersectionType;
import org.eclipse.birt.chart.model.attribute.LegendItemType;
import org.eclipse.birt.chart.model.attribute.Position;
import org.eclipse.birt.chart.model.attribute.TickStyle;
import org.eclipse.birt.chart.model.attribute.impl.ColorDefinitionImpl;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.component.impl.SeriesImpl;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.data.impl.QueryImpl;
import org.eclipse.birt.chart.model.data.impl.SeriesDefinitionImpl;
import org.eclipse.birt.chart.model.impl.ChartWithAxesImpl;
import org.eclipse.birt.chart.model.layout.Legend;
import org.eclipse.birt.chart.model.layout.Plot;
import org.eclipse.birt.chart.model.type.BarSeries;
import org.eclipse.birt.chart.model.type.impl.BarSeriesImpl;
import org.eclipse.birt.core.data.ExpressionUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.DataEngine;
import org.eclipse.birt.data.engine.api.DataEngineContext;
import org.eclipse.birt.data.engine.api.IBaseDataSetDesign;
import org.eclipse.birt.data.engine.api.IBaseDataSourceDesign;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IBinding;
import org.eclipse.birt.data.engine.api.IPreparedQuery;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.api.IQueryResults;
import org.eclipse.birt.data.engine.api.querydefn.Binding;
import org.eclipse.birt.data.engine.api.querydefn.GroupDefinition;
import org.eclipse.birt.data.engine.api.querydefn.OdaDataSetDesign;
import org.eclipse.birt.data.engine.api.querydefn.OdaDataSourceDesign;
import org.eclipse.birt.data.engine.api.querydefn.QueryDefinition;
import org.eclipse.birt.data.engine.api.querydefn.ScriptExpression;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.linuxtools.dataviewers.charts.dataengine.FlatFileDataSource;
import org.eclipse.linuxtools.dataviewers.charts.dataengine.GroupedRowExpressionsEvaluator;

public class BindDataEngine {
    private String[] columnsName = null;
    private FlatFileDataSource ffds = null;

    public final Chart createWorkingWithBIRTDataEngine(FlatFileDataSource ffds) throws ChartException {
        this.ffds = ffds;
        this.columnsName = ffds.getCOLUMNNAME();
        String[] expressions = new String[this.columnsName.length];
        expressions[0] = ExpressionUtil.createRowExpression((String)this.columnsName[0]);
        expressions[1] = ExpressionUtil.createRowExpression((String)this.columnsName[1]);
        ChartWithAxes cwaBar = BindDataEngine.createChartModel(expressions);
        cwaBar = this.bindData(cwaBar, expressions);
        return cwaBar;
    }

    private static ChartWithAxes createChartModel(String[] expressions) {
        ChartWithAxes cwaBar = ChartWithAxesImpl.create();
        cwaBar.setType("Bar Chart");
        cwaBar.setSubType("Side-by-side");
        cwaBar.getBlock().setBackground((Fill)ColorDefinitionImpl.WHITE());
        cwaBar.getBlock().getOutline().setVisible(true);
        Plot p = cwaBar.getPlot();
        p.getClientArea().setBackground((Fill)ColorDefinitionImpl.create((int)255, (int)255, (int)225));
        cwaBar.getTitle().getLabel().getCaption().setValue("Working with BIRT Data Engine");
        Legend lg = cwaBar.getLegend();
        lg.setItemType(LegendItemType.CATEGORIES_LITERAL);
        Axis xAxisPrimary = cwaBar.getPrimaryBaseAxes()[0];
        xAxisPrimary.setType(AxisType.TEXT_LITERAL);
        xAxisPrimary.getMajorGrid().setTickStyle(TickStyle.BELOW_LITERAL);
        xAxisPrimary.getOrigin().setType(IntersectionType.MIN_LITERAL);
        Axis yAxisPrimary = cwaBar.getPrimaryOrthogonalAxis(xAxisPrimary);
        yAxisPrimary.getMajorGrid().setTickStyle(TickStyle.LEFT_LITERAL);
        yAxisPrimary.setType(AxisType.LINEAR_LITERAL);
        yAxisPrimary.getLabel().getCaption().getFont().setRotation(90.0);
        yAxisPrimary.getTitle().setVisible(true);
        yAxisPrimary.getTitle().getCaption().setValue("Customer Amount");
        yAxisPrimary.getTitle().getCaption().setColor(ColorDefinitionImpl.GREEN());
        Series seCategory = SeriesImpl.create();
        seCategory.getDataDefinition().add((Object)QueryImpl.create((String)expressions[0]));
        SeriesDefinition sdX = SeriesDefinitionImpl.create();
        sdX.getSeriesPalette().shift(0);
        xAxisPrimary.getSeriesDefinitions().add((Object)sdX);
        sdX.getSeries().add((Object)seCategory);
        BarSeries bs1 = (BarSeries)BarSeriesImpl.create();
        bs1.getDataDefinition().add((Object)QueryImpl.create((String)expressions[1]));
        bs1.getLabel().setVisible(true);
        bs1.setLabelPosition(Position.INSIDE_LITERAL);
        SeriesDefinition sdY = SeriesDefinitionImpl.create();
        yAxisPrimary.getSeriesDefinitions().add((Object)sdY);
        sdY.getSeries().add((Object)bs1);
        return cwaBar;
    }

    private ChartWithAxes bindData(ChartWithAxes cwaBar, String[] expressions) throws ChartException {
        RunTimeContext context = new RunTimeContext();
        context.setULocale(ULocale.getDefault());
        try {
            IDataRowExpressionEvaluator evaluator = this.prepareRowExpressionEvaluator(cwaBar, expressions);
            Generator.instance().bindData(evaluator, (Chart)cwaBar, context);
        }
        catch (BirtException e) {
            throw new ChartException("org.eclipse.linuxtools.dataviewers.charts", 19, (Throwable)e);
        }
        return cwaBar;
    }

    private IDataRowExpressionEvaluator prepareRowExpressionEvaluator(ChartWithAxes chart, String[] expressions) throws BirtException {
        OdaDataSourceDesign odaDataSource = this.newDataSource();
        OdaDataSetDesign odaDataSet = this.newDataSet(odaDataSource);
        QueryDefinition query = this.createQueryDefinition(odaDataSet, expressions);
        DataEngine dataEngine = BindDataEngine.newDataEngine();
        dataEngine.defineDataSource((IBaseDataSourceDesign)odaDataSource);
        dataEngine.defineDataSet((IBaseDataSetDesign)odaDataSet);
        IPreparedQuery preparedQuery = dataEngine.prepare((IQueryDefinition)query);
        IQueryResults queryResults = preparedQuery.execute(null);
        return new GroupedRowExpressionsEvaluator(queryResults.getResultIterator(), true);
    }

    private QueryDefinition createQueryDefinition(OdaDataSetDesign odaDataSet, String[] expressions) throws ChartException {
        QueryDefinition queryDefn = new QueryDefinition();
        queryDefn.setDataSetName(odaDataSet.getName());
        try {
            this.initDefaultBindings(queryDefn);
            String groupName = "Group_Country";
            GroupDefinition gd = new GroupDefinition(groupName);
            gd.setKeyExpression(expressions[0]);
            gd.setInterval(0);
            gd.setIntervalRange(0.0);
            int i = 0;
            while (i < expressions.length) {
                String expr = expressions[i];
                Binding colBinding = new Binding(expr);
                colBinding.setExpression((IBaseExpression)new ScriptExpression(expr));
                if (i == 1) {
                    colBinding.setExpression(null);
                    colBinding.setAggrFunction("COUNT");
                    colBinding.addAggregateOn(groupName);
                    colBinding.addArgument((IBaseExpression)new ScriptExpression(expressions[i]));
                }
                queryDefn.addBinding((IBinding)colBinding);
                ++i;
            }
            queryDefn.addGroup(gd);
        }
        catch (DataException e) {
            throw new ChartException("org.eclipse.linuxtools.dataviewers.charts", 19, (Throwable)e);
        }
        return queryDefn;
    }

    private void initDefaultBindings(QueryDefinition queryDefn) throws DataException {
        int i = 0;
        while (i < this.columnsName.length) {
            Binding colBinding = new Binding(this.columnsName[i]);
            colBinding.setExpression((IBaseExpression)new ScriptExpression(ExpressionUtil.createDataSetRowExpression((String)this.columnsName[i])));
            queryDefn.addBinding((IBinding)colBinding);
            ++i;
        }
    }

    private static DataEngine newDataEngine() throws BirtException {
        DataEngineContext context = DataEngineContext.newInstance((int)3, null, null, null);
        DataEngine myDataEngine = DataEngine.newDataEngine((DataEngineContext)context);
        return myDataEngine;
    }

    private OdaDataSetDesign newDataSet(OdaDataSourceDesign dataSourceDesign) {
        OdaDataSetDesign dataSet = new OdaDataSetDesign("Data Set1");
        dataSet.setDataSource(dataSourceDesign.getName());
        dataSet.setExtensionID("org.eclipse.datatools.connectivity.oda.flatfile.dataSet");
        dataSet.setQueryText(this.ffds.getQuery());
        return dataSet;
    }

    private OdaDataSourceDesign newDataSource() throws BirtException {
        OdaDataSourceDesign dataSource = new OdaDataSourceDesign("Data Source1");
        dataSource.setExtensionID("org.eclipse.datatools.connectivity.oda.flatfile");
        dataSource.addPrivateProperty("HOME", this.ffds.HOME);
        dataSource.addPrivateProperty("CHARSET", "UTF-8");
        dataSource.addPrivateProperty("DELIMTYPE", "TAB");
        dataSource.addPrivateProperty("INCLTYPELINE", "NO");
        dataSource.addPrivateProperty("OdaPropertyConfigId", String.valueOf(dataSource.getExtensionID()) + "_" + dataSource.getName());
        return dataSource;
    }
}

