/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.views.uml2sd;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.linuxtools.tmf.event.TmfTimestamp;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.DrawableToolTip;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.ITimeCompressionListener;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.SDView;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.ScrollView;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.core.AsyncMessage;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.core.BaseMessage;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.core.ExecutionOccurrence;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.core.Frame;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.core.GraphNode;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.core.ITimeRange;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.core.Lifeline;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.core.Metrics;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.core.SDTimeEvent;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.core.SyncMessage;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.drawings.IColor;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.drawings.impl.ColorImpl;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.preferences.SDViewPref;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.util.TimeEventComparator;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public class TimeCompressionBar
extends ScrollView
implements DisposeListener {
    protected ArrayList<ITimeCompressionListener> listenerList = null;
    protected Frame frame = null;
    protected List<SDTimeEvent> nodeList = null;
    protected TmfTimestamp min = new TmfTimestamp();
    protected TmfTimestamp max = new TmfTimestamp();
    protected float zoomValue = 1.0f;
    protected DrawableToolTip tooltip = null;
    protected ColorImpl[] col;
    protected Accessible accessible = null;
    protected int focusedWidget = -1;
    protected SDView view = null;
    protected Lifeline ll = null;
    protected int ls = 0;
    protected int ln = 0;
    protected IColor lc = null;
    protected int nextNodeY = 0;
    protected int prevNodeY = 0;

    public TimeCompressionBar(Composite parent, int s) {
        super(parent, s | 0x40000, false);
        this.setVScrollBarMode(2);
        this.setHScrollBarMode(2);
        this.listenerList = new ArrayList();
        this.col = new ColorImpl[10];
        this.col[0] = new ColorImpl(Display.getDefault(), 255, 229, 229);
        this.col[1] = new ColorImpl(Display.getDefault(), 255, 204, 204);
        this.col[2] = new ColorImpl(Display.getDefault(), 255, 178, 178);
        this.col[3] = new ColorImpl(Display.getDefault(), 255, 153, 153);
        this.col[4] = new ColorImpl(Display.getDefault(), 255, 127, 127);
        this.col[5] = new ColorImpl(Display.getDefault(), 255, 102, 102);
        this.col[6] = new ColorImpl(Display.getDefault(), 255, 76, 76);
        this.col[7] = new ColorImpl(Display.getDefault(), 255, 51, 51);
        this.col[8] = new ColorImpl(Display.getDefault(), 255, 25, 25);
        this.col[9] = new ColorImpl(Display.getDefault(), 255, 0, 0);
        super.addDisposeListener((DisposeListener)this);
        this.accessible = this.getViewControl().getAccessible();
        this.accessible.addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                if (e.childID != -1) {
                    if (e.childID == 0) {
                        if (TimeCompressionBar.this.tooltip != null) {
                            e.result = TimeCompressionBar.this.tooltip.getAccessibleText();
                        }
                    } else if (e.childID == 1) {
                        TimeCompressionBar.this.createFakeTooltip();
                        e.result = TimeCompressionBar.this.tooltip.getAccessibleText();
                    }
                }
            }
        });
        this.accessible.addAccessibleControlListener((AccessibleControlListener)new AccessibleControlAdapter(){

            public void getFocus(AccessibleControlEvent e) {
                e.childID = TimeCompressionBar.this.focusedWidget == -1 ? -1 : TimeCompressionBar.this.focusedWidget;
            }

            public void getRole(AccessibleControlEvent e) {
                switch (e.childID) {
                    case -1: {
                        e.detail = 10;
                        break;
                    }
                    case 0: {
                        e.detail = 13;
                        break;
                    }
                    case 1: {
                        e.detail = 41;
                    }
                }
            }

            public void getState(AccessibleControlEvent e) {
                e.detail = 0x100000;
                if (e.childID == -1) {
                    e.detail |= 4;
                } else {
                    e.detail |= 0x200000;
                    if (e.childID == TimeCompressionBar.this.focusedWidget) {
                        e.detail |= 0x16;
                    }
                }
            }
        });
        this.getViewControl().addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 16 || e.detail == 8) {
                    e.doit = true;
                }
            }
        });
        this.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 16 || e.detail == 8) {
                    e.doit = true;
                }
            }
        });
        this.getViewControl().addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                TimeCompressionBar.this.redraw();
            }

            public void focusLost(FocusEvent e) {
                TimeCompressionBar.this.redraw();
            }
        });
    }

    void setFocus(int newFocusShape) {
        this.focusedWidget = newFocusShape;
        if (this.focusedWidget == -1) {
            this.getViewControl().getAccessible().setFocus(-1);
        } else {
            this.getViewControl().getAccessible().setFocus(this.focusedWidget);
        }
    }

    public void setFrame(Frame theFrame) {
        this.frame = theFrame;
        this.min = this.frame.getMinTime();
        this.max = this.frame.getMaxTime();
    }

    @Override
    protected void drawContents(GC gc, int clipx, int clipy, int clipw, int cliph) {
        SDTimeEvent t;
        BaseMessage m;
        int firstVisible;
        if (this.frame == null) {
            return;
        }
        this.nodeList = new ArrayList<SDTimeEvent>();
        int messageArraysStep = 1;
        if ((float)(Metrics.getMessageFontHeigth() + 20) * this.zoomValue < 2.0f) {
            messageArraysStep = Math.round(1.0f + 1.0f / ((float)(Metrics.getMessageFontHeigth() + 20) * this.zoomValue));
        }
        if ((firstVisible = this.frame.getFirstVisibleSyncMessage()) > 0) {
            --firstVisible;
        }
        int i = firstVisible;
        while (i < this.frame.syncMessageCount()) {
            m = this.frame.getSyncMessage(i);
            if (((SyncMessage)m).hasTimeInfo()) {
                t = new SDTimeEvent(((SyncMessage)m).getStartTime(), m.getEventOccurrence(), (ITimeRange)((Object)m));
                this.nodeList.add(t);
                if ((float)m.getY() * this.zoomValue > (float)(this.getContentsY() + this.getVisibleHeight())) break;
            }
            i += messageArraysStep;
        }
        firstVisible = this.frame.getFirstVisibleSyncMessageReturn();
        if (firstVisible > 0) {
            --firstVisible;
        }
        i = firstVisible;
        while (i < this.frame.syncMessageReturnCount()) {
            m = this.frame.getSyncMessageReturn(i);
            if (((SyncMessage)m).hasTimeInfo()) {
                t = new SDTimeEvent(((SyncMessage)m).getStartTime(), m.getEventOccurrence(), (ITimeRange)((Object)m));
                this.nodeList.add(t);
                if ((float)m.getY() * this.zoomValue > (float)(this.getContentsY() + this.getVisibleHeight())) break;
            }
            i += messageArraysStep;
        }
        firstVisible = this.frame.getFirstVisibleAsyncMessage();
        if (firstVisible > 0) {
            --firstVisible;
        }
        i = firstVisible;
        while (i < this.frame.asyncMessageCount()) {
            m = this.frame.getAsyncMessage(i);
            if (((AsyncMessage)m).hasTimeInfo()) {
                t = new SDTimeEvent(((AsyncMessage)m).getStartTime(), m.getStartOccurrence(), (ITimeRange)((Object)m));
                this.nodeList.add(t);
                t = new SDTimeEvent(((AsyncMessage)m).getEndTime(), m.getEndOccurrence(), (ITimeRange)((Object)m));
                this.nodeList.add(t);
                if ((float)((AsyncMessage)m).getY() * this.zoomValue > (float)(this.getContentsY() + this.getVisibleHeight())) break;
            }
            i += messageArraysStep;
        }
        firstVisible = this.frame.getFirstVisibleAsyncMessageReturn();
        if (firstVisible > 0) {
            --firstVisible;
        }
        i = firstVisible;
        while (i < this.frame.asyncMessageReturnCount()) {
            m = this.frame.getAsyncMessageReturn(i);
            if (((AsyncMessage)m).hasTimeInfo()) {
                t = new SDTimeEvent(((AsyncMessage)m).getStartTime(), m.getStartOccurrence(), (ITimeRange)((Object)m));
                this.nodeList.add(t);
                t = new SDTimeEvent(((AsyncMessage)m).getEndTime(), m.getEndOccurrence(), (ITimeRange)((Object)m));
                this.nodeList.add(t);
                if ((float)((AsyncMessage)m).getY() * this.zoomValue > (float)(this.getContentsY() + this.getVisibleHeight())) break;
            }
            i += messageArraysStep;
        }
        List<SDTimeEvent> executionOccurrencesWithTime = this.frame.getExecutionOccurrencesWithTime();
        if (executionOccurrencesWithTime != null) {
            this.nodeList.addAll(executionOccurrencesWithTime);
        }
        SDTimeEvent[] temp = this.nodeList.toArray(new SDTimeEvent[0]);
        Arrays.sort(temp, new TimeEventComparator());
        this.nodeList = Arrays.asList(temp);
        Image dbuffer = null;
        GC gcim = null;
        try {
            dbuffer = new Image((Device)this.getDisplay(), this.getClientArea().width, this.getClientArea().height);
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        gcim = new GC(dbuffer);
        int i2 = 0;
        while (i2 < this.nodeList.size() - 1) {
            block34: {
                AsyncMessage as;
                int colIndex;
                SDTimeEvent m2;
                SDTimeEvent m1;
                block33: {
                    m1 = this.nodeList.get(i2);
                    m2 = this.nodeList.get(i2 + 1);
                    if (!SDViewPref.getInstance().excludeExternalTime() || !(m1.getGraphNode() instanceof BaseMessage) || !(m2.getGraphNode() instanceof BaseMessage)) break block33;
                    BaseMessage mes1 = (BaseMessage)((Object)m1.getGraphNode());
                    BaseMessage mes2 = (BaseMessage)((Object)m2.getGraphNode());
                    if (mes2.getStartLifeline() == null || mes1.getEndLifeline() == null) break block34;
                }
                this.min = this.frame.getMinTime();
                this.max = this.frame.getMaxTime();
                TmfTimestamp minMaxdelta = this.max.getDelta(this.min);
                double gr = (double)minMaxdelta.getValue() / 10.0;
                TmfTimestamp delta = m2.getTime().getDelta(m1.getTime()).getDelta(this.min);
                long absDelta = Math.abs(delta.getValue());
                ColorImpl color = gr != 0.0 ? ((colIndex = Math.round((float)((double)absDelta / gr))) < this.col.length && colIndex > 0 ? this.col[colIndex - 1] : (colIndex <= 0 ? this.col[0] : this.col[this.col.length - 1])) : this.col[0];
                if (color.getColor() instanceof Color) {
                    gcim.setBackground((Color)color.getColor());
                }
                int y1 = ((GraphNode)((Object)m1.getGraphNode())).getY();
                int y2 = ((GraphNode)((Object)m2.getGraphNode())).getY();
                if (m1.getGraphNode() instanceof AsyncMessage && (as = (AsyncMessage)m1.getGraphNode()).getEndTime() == m1.getTime()) {
                    y1 += as.getHeight();
                }
                if (m2.getGraphNode() instanceof AsyncMessage && (as = (AsyncMessage)m2.getGraphNode()).getEndTime() == m2.getTime()) {
                    y2 += as.getHeight();
                }
                if (m1.getGraphNode() instanceof ExecutionOccurrence) {
                    ExecutionOccurrence eo = (ExecutionOccurrence)m1.getGraphNode();
                    if (m1.getEvent() == eo.getEndOccurrence()) {
                        y1 += eo.getHeight();
                    }
                    if (m2.getGraphNode() instanceof ExecutionOccurrence) {
                        ExecutionOccurrence eo2 = (ExecutionOccurrence)m2.getGraphNode();
                        if (m2.getEvent() == eo2.getEndOccurrence()) {
                            y2 += eo2.getHeight();
                        }
                    }
                }
                gcim.fillRectangle(this.contentsToViewX(0), this.contentsToViewY(Math.round((float)y1 * this.zoomValue)), 10, Math.round((float)(y2 - y1) * this.zoomValue) + 1);
                if (messageArraysStep == 1) {
                    Color backupColor = gcim.getForeground();
                    gcim.setForeground(Display.getDefault().getSystemColor(1));
                    gcim.drawRectangle(this.contentsToViewX(0), this.contentsToViewY(Math.round((float)y1 * this.zoomValue)), 9, Math.round((float)(y2 - y1) * this.zoomValue));
                    gcim.setForeground(backupColor);
                }
            }
            ++i2;
        }
        if (this.getViewControl().isFocusControl() || this.isFocusControl()) {
            gcim.drawFocus(this.contentsToViewX(0), this.contentsToViewY(Math.round((float)this.prevNodeY * this.zoomValue)), this.contentsToViewX(10), Math.round((float)(this.nextNodeY - this.prevNodeY) * this.zoomValue));
        }
        try {
            gc.drawImage(dbuffer, 0, 0, this.getClientArea().width, this.getClientArea().height, 0, 0, this.getClientArea().width, this.getClientArea().height);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        gcim.dispose();
        if (dbuffer != null) {
            dbuffer.dispose();
        }
        gc.dispose();
    }

    protected boolean checkFocusOnChilds(Control childs) {
        if (childs instanceof Composite) {
            Control[] child = ((Composite)childs).getChildren();
            int i = 0;
            while (i < child.length) {
                if (child[i].isFocusControl()) {
                    return true;
                }
                this.checkFocusOnChilds(child[i]);
                ++i;
            }
        }
        return false;
    }

    public boolean isFocusControl() {
        Control[] child = this.getChildren();
        int i = 0;
        while (i < child.length) {
            if (child[i].isFocusControl()) {
                return true;
            }
            this.checkFocusOnChilds(child[i]);
            ++i;
        }
        return false;
    }

    @Override
    protected void contentsMouseMoveEvent(MouseEvent event) {
        if (this.tooltip != null) {
            this.tooltip.hideToolTip();
        }
        super.contentsMouseMoveEvent(event);
        if (!this.isFocusControl() || this.getViewControl().isFocusControl()) {
            Control[] child = this.getParent().getChildren();
            int i = 0;
            while (i < child.length) {
                if (child[i].isFocusControl()) break;
                ++i;
            }
        }
        this.setFocus(-1);
    }

    @Override
    protected void contentsMouseHover(MouseEvent e) {
        block12: {
            if (this.tooltip == null) {
                this.tooltip = new DrawableToolTip(this);
            }
            if (this.frame == null) break block12;
            this.setFocus(0);
            int i = 0;
            while (i < this.nodeList.size() - 1) {
                block14: {
                    AsyncMessage as;
                    SDTimeEvent m2;
                    SDTimeEvent m1;
                    block13: {
                        m1 = this.nodeList.get(i);
                        m2 = this.nodeList.get(i + 1);
                        if (!SDViewPref.getInstance().excludeExternalTime() || !(m1.getGraphNode() instanceof BaseMessage) || !(m2.getGraphNode() instanceof BaseMessage)) break block13;
                        BaseMessage mes1 = (BaseMessage)((Object)m1.getGraphNode());
                        BaseMessage mes2 = (BaseMessage)((Object)m2.getGraphNode());
                        if (mes2.getStartLifeline() == null || mes1.getEndLifeline() == null) break block14;
                    }
                    int y1 = ((GraphNode)((Object)m1.getGraphNode())).getY();
                    int y2 = ((GraphNode)((Object)m2.getGraphNode())).getY();
                    if (m1.getGraphNode() instanceof AsyncMessage && (as = (AsyncMessage)m1.getGraphNode()).getEndTime() == m1.getTime()) {
                        y1 += as.getHeight();
                    }
                    if (m2.getGraphNode() instanceof AsyncMessage && (as = (AsyncMessage)m2.getGraphNode()).getEndTime() == m2.getTime()) {
                        y2 += as.getHeight();
                    }
                    if (m1.getGraphNode() instanceof ExecutionOccurrence) {
                        ExecutionOccurrence eo = (ExecutionOccurrence)m1.getGraphNode();
                        if (m1.getEvent() == eo.getEndOccurrence()) {
                            y1 += eo.getHeight();
                        }
                        if (m2.getGraphNode() instanceof ExecutionOccurrence) {
                            ExecutionOccurrence eo2 = (ExecutionOccurrence)m2.getGraphNode();
                            if (m2.getEvent() == eo2.getEndOccurrence()) {
                                y2 += eo2.getHeight();
                            }
                        }
                    }
                    int m1Y = Math.round((float)y1 * this.zoomValue);
                    int m2Y = Math.round((float)y2 * this.zoomValue);
                    if (m1Y < e.y && m2Y >= e.y) {
                        TmfTimestamp delta = m2.getTime().getDelta(m1.getTime());
                        this.tooltip.showToolTip(delta, this.min, this.max);
                    }
                }
                ++i;
            }
        }
        this.setFocus(0);
    }

    @Override
    protected void contentsMouseExit(MouseEvent e) {
        if (this.tooltip != null) {
            this.tooltip.hideToolTip();
        }
    }

    @Override
    protected void contentsMouseUpEvent(MouseEvent event) {
        this.selectTimeDelta(event.y, 0);
        this.setFocus();
        super.contentsMouseUpEvent(event);
    }

    public void highlightRegion(BaseMessage mes1, BaseMessage mes2) {
        AsyncMessage as;
        if (this.frame == null) {
            return;
        }
        if (!(mes1 instanceof ITimeRange)) {
            return;
        }
        if (!(mes2 instanceof ITimeRange)) {
            return;
        }
        ITimeRange t1 = (ITimeRange)((Object)mes1);
        ITimeRange t2 = (ITimeRange)((Object)mes2);
        TmfTimestamp time1 = t1.getStartTime();
        TmfTimestamp time2 = t2.getStartTime();
        int event1 = mes1.getEventOccurrence();
        int event2 = mes2.getEventOccurrence();
        if (mes1 instanceof AsyncMessage) {
            as = (AsyncMessage)mes2;
            time1 = as.getEndTime();
            event1 = as.getEndOccurrence();
        }
        if (mes2 instanceof AsyncMessage) {
            as = (AsyncMessage)mes2;
            if (as.getEndOccurrence() > as.getStartOccurrence()) {
                time1 = as.getEndTime();
                event1 = as.getEndOccurrence();
            } else {
                time1 = as.getStartTime();
                event1 = as.getStartOccurrence();
            }
        }
        if (event1 > event2) {
            AsyncMessage as2;
            BaseMessage tempMes = mes2;
            mes2 = mes1;
            mes1 = tempMes;
            t1 = (ITimeRange)((Object)mes1);
            t2 = (ITimeRange)((Object)mes2);
            time1 = t1.getStartTime();
            time2 = t2.getStartTime();
            event1 = mes1.getEventOccurrence();
            event2 = mes2.getEventOccurrence();
            if (mes1 instanceof AsyncMessage) {
                as2 = (AsyncMessage)mes2;
                time1 = as2.getEndTime();
                event1 = as2.getEndOccurrence();
            }
            if (mes2 instanceof AsyncMessage) {
                as2 = (AsyncMessage)mes2;
                if (as2.getEndOccurrence() > as2.getStartOccurrence()) {
                    time1 = as2.getEndTime();
                    event1 = as2.getEndOccurrence();
                } else {
                    time1 = as2.getStartTime();
                    event1 = as2.getStartOccurrence();
                }
            }
        }
        TmfTimestamp minMaxdelta = this.max.getDelta(this.min);
        double gr = (double)minMaxdelta.getValue() / 10.0;
        TmfTimestamp delta = time2.getDelta(time1).getDelta(this.min);
        long absDelta = Math.abs(delta.getValue());
        int colIndex = 0;
        if (gr != 0.0) {
            colIndex = Math.round((float)((double)absDelta / gr));
            if (colIndex >= this.col.length) {
                colIndex = this.col.length - 1;
            } else if (colIndex < 0) {
                colIndex = 0;
            }
        } else {
            colIndex = 0;
        }
        int j = 0;
        while (j < this.listenerList.size()) {
            ITimeCompressionListener list = this.listenerList.get(j);
            if (mes1.getEndLifeline() != null) {
                list.deltaSelected(mes1.getEndLifeline(), event1, event2 - event1, this.col[colIndex]);
            } else if (mes2.getStartLifeline() != null) {
                list.deltaSelected(mes2.getStartLifeline(), event1, event2 - event1, this.col[colIndex]);
            } else {
                list.deltaSelected(mes1.getStartLifeline(), event1, event2 - event1, this.col[colIndex]);
            }
            ++j;
        }
    }

    public void highlightRegionSync(final BaseMessage mes1, final BaseMessage mes2) {
        this.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                TimeCompressionBar.this.highlightRegion(mes1, mes2);
            }
        });
    }

    @Override
    public void scrollBy(int x, int y) {
    }

    public void setZoom(float value) {
        this.zoomValue = value;
        this.redraw();
    }

    public void addTimeCompressionListener(ITimeCompressionListener listener) {
        if (!this.listenerList.contains(listener)) {
            this.listenerList.add(listener);
        }
    }

    public void removeSelectionChangedListener(ITimeCompressionListener listener) {
        this.listenerList.remove(listener);
    }

    public void widgetDisposed(DisposeEvent e) {
        if (this.tooltip != null) {
            this.tooltip.dispose();
        }
        super.removeDisposeListener((DisposeListener)this);
        int i = 0;
        while (i < this.col.length) {
            this.col[i].dispose();
            ++i;
        }
    }

    @Override
    protected void keyPressedEvent(KeyEvent _e) {
        boolean top;
        block23: {
            int i;
            if (this.tooltip != null) {
                this.tooltip.hideToolTip();
            }
            if (!this.isFocusControl() || this.getViewControl().isFocusControl()) {
                Control[] child = this.getParent().getChildren();
                i = 0;
                while (i < child.length) {
                    if (child[i].isFocusControl()) break;
                    ++i;
                }
            }
            this.setFocus(-1);
            top = false;
            if (this.nextNodeY == 0) {
                top = true;
            }
            if (this.frame == null || this.nextNodeY != 0) break block23;
            i = 0;
            while (i < this.nodeList.size() - 1 && i < 1) {
                block25: {
                    AsyncMessage as;
                    SDTimeEvent m2;
                    SDTimeEvent m1;
                    block24: {
                        m1 = this.nodeList.get(i);
                        m2 = this.nodeList.get(i + 1);
                        if (!SDViewPref.getInstance().excludeExternalTime() || !(m1.getGraphNode() instanceof BaseMessage) || !(m2.getGraphNode() instanceof BaseMessage)) break block24;
                        BaseMessage mes1 = (BaseMessage)((Object)m1.getGraphNode());
                        BaseMessage mes2 = (BaseMessage)((Object)m2.getGraphNode());
                        if (mes2.getStartLifeline() == null || mes1.getEndLifeline() == null) break block25;
                    }
                    int y1 = ((GraphNode)((Object)m1.getGraphNode())).getY();
                    int y2 = ((GraphNode)((Object)m2.getGraphNode())).getY();
                    if (m1.getGraphNode() instanceof AsyncMessage && (as = (AsyncMessage)m1.getGraphNode()).getEndTime() == m1.getTime()) {
                        y1 += as.getHeight();
                    }
                    if (m2.getGraphNode() instanceof AsyncMessage && (as = (AsyncMessage)m2.getGraphNode()).getEndTime() == m2.getTime()) {
                        y2 += as.getHeight();
                    }
                    if (m1.getGraphNode() instanceof ExecutionOccurrence) {
                        ExecutionOccurrence eo = (ExecutionOccurrence)m1.getGraphNode();
                        if (m1.getEvent() == eo.getEndOccurrence()) {
                            y1 += eo.getHeight();
                        }
                        if (m2.getGraphNode() instanceof ExecutionOccurrence) {
                            ExecutionOccurrence eo2 = (ExecutionOccurrence)m2.getGraphNode();
                            if (m2.getEvent() == eo2.getEndOccurrence()) {
                                y2 += eo2.getHeight();
                            }
                        }
                    }
                    this.prevNodeY = Math.round((float)y1 * this.zoomValue);
                    this.nextNodeY = Math.round((float)y2 * this.zoomValue);
                }
                ++i;
            }
        }
        if (this.ll != null) {
            int j = 0;
            while (j < this.listenerList.size()) {
                ITimeCompressionListener list = this.listenerList.get(j);
                list.deltaSelected(this.ll, this.ls, this.ln, this.lc);
                ++j;
            }
        }
        if (_e.keyCode == 0x1000002) {
            if (!top) {
                this.selectTimeDelta(this.nextNodeY + 1, 1);
            } else {
                this.selectTimeDelta(this.prevNodeY + 1, 1);
            }
            this.setFocus(1);
        } else if (_e.keyCode == 0x1000001) {
            this.selectTimeDelta(this.prevNodeY - 1, 2);
            this.setFocus(1);
        } else if (_e.keyCode == 0x1000004) {
            this.selectTimeDelta(this.prevNodeY, 1);
            this.setFocus(1);
        }
        super.keyPressedEvent(_e);
    }

    @Override
    protected void keyReleasedEvent(KeyEvent _e) {
        super.keyReleasedEvent(_e);
    }

    protected void selectTimeDelta(int dy, int direction) {
        block26: {
            SDTimeEvent lastM1 = null;
            SDTimeEvent lastM2 = null;
            int lastY1 = 0;
            int lastY2 = 0;
            boolean done = false;
            if (this.frame == null) break block26;
            int i = 0;
            while (i < this.nodeList.size() - 1) {
                block28: {
                    AsyncMessage as;
                    SDTimeEvent m2;
                    SDTimeEvent m1;
                    block27: {
                        m1 = this.nodeList.get(i);
                        m2 = this.nodeList.get(i + 1);
                        if (!SDViewPref.getInstance().excludeExternalTime() || !(m1.getGraphNode() instanceof BaseMessage) || !(m2.getGraphNode() instanceof BaseMessage)) break block27;
                        BaseMessage mes1 = (BaseMessage)((Object)m1.getGraphNode());
                        BaseMessage mes2 = (BaseMessage)((Object)m2.getGraphNode());
                        if (mes2.getStartLifeline() == null || mes1.getEndLifeline() == null) break block28;
                    }
                    int y1 = ((GraphNode)((Object)m1.getGraphNode())).getY();
                    int y2 = ((GraphNode)((Object)m2.getGraphNode())).getY();
                    if (m1.getGraphNode() instanceof AsyncMessage && (as = (AsyncMessage)m1.getGraphNode()).getEndTime() == m1.getTime()) {
                        y1 += as.getHeight();
                    }
                    if (m2.getGraphNode() instanceof AsyncMessage && (as = (AsyncMessage)m2.getGraphNode()).getEndTime() == m2.getTime()) {
                        y2 += as.getHeight();
                    }
                    if (m1.getGraphNode() instanceof ExecutionOccurrence) {
                        ExecutionOccurrence eo = (ExecutionOccurrence)m1.getGraphNode();
                        if (m1.getEvent() == eo.getEndOccurrence()) {
                            y1 += eo.getHeight();
                        }
                        if (m2.getGraphNode() instanceof ExecutionOccurrence) {
                            ExecutionOccurrence eo2 = (ExecutionOccurrence)m2.getGraphNode();
                            if (m2.getEvent() == eo2.getEndOccurrence()) {
                                y2 += eo2.getHeight();
                            }
                        }
                    }
                    int m1Y = Math.round((float)y1 * this.zoomValue);
                    int m2Y = Math.round((float)y2 * this.zoomValue);
                    if (m1Y < dy && m2Y > dy || !done && m2Y > dy && direction == 1 && lastM1 != null || !done && m1Y > dy && direction == 2 && lastM1 != null) {
                        if (m1Y > dy && direction == 2) {
                            m1 = lastM1;
                            m2 = lastM2;
                            m1Y = lastY1;
                            m2Y = lastY2;
                        }
                        done = true;
                        this.prevNodeY = m1Y;
                        this.nextNodeY = m2Y;
                        TmfTimestamp minMaxdelta = this.max.getDelta(this.min);
                        double gr = (double)minMaxdelta.getValue() / 10.0;
                        TmfTimestamp delta = m2.getTime().getDelta(m1.getTime()).getDelta(this.min);
                        long absDelta = Math.abs(delta.getValue());
                        int colIndex = 0;
                        if (gr != 0.0) {
                            colIndex = Math.round((float)((double)absDelta / gr));
                            if (colIndex >= this.col.length) {
                                colIndex = this.col.length - 1;
                            } else if (colIndex < 0) {
                                colIndex = 0;
                            }
                        } else {
                            colIndex = 0;
                        }
                        if (m1.getGraphNode() instanceof BaseMessage) {
                            BaseMessage mes1 = (BaseMessage)((Object)m1.getGraphNode());
                            if (mes1.getEndLifeline() != null) {
                                this.ll = mes1.getEndLifeline();
                                this.ls = m1.getEvent();
                                this.ln = m2.getEvent() - m1.getEvent();
                                this.lc = this.col[colIndex];
                            } else if (m2.getGraphNode() instanceof BaseMessage && ((BaseMessage)((Object)m2.getGraphNode())).getStartLifeline() != null) {
                                this.ll = ((BaseMessage)((Object)m2.getGraphNode())).getStartLifeline();
                                this.ls = m1.getEvent();
                                this.ln = m2.getEvent() - m1.getEvent();
                                this.lc = this.col[colIndex];
                            } else {
                                this.ll = mes1.getStartLifeline();
                                this.ls = m1.getEvent();
                                this.ln = m2.getEvent() - m1.getEvent();
                                this.lc = this.col[colIndex];
                            }
                        } else if (m1.getGraphNode() instanceof ExecutionOccurrence) {
                            ExecutionOccurrence eo;
                            if (m2.getGraphNode() instanceof ExecutionOccurrence) {
                                eo = (ExecutionOccurrence)m2.getGraphNode();
                                this.ll = eo.getLifeline();
                                this.ls = m1.getEvent();
                                this.ln = m2.getEvent() - m1.getEvent();
                                this.lc = this.col[colIndex];
                            } else {
                                eo = (ExecutionOccurrence)m1.getGraphNode();
                                this.ll = eo.getLifeline();
                                this.ls = m1.getEvent();
                                this.ln = m2.getEvent() - m1.getEvent();
                                this.lc = this.col[colIndex];
                            }
                        }
                        int j = 0;
                        while (j < this.listenerList.size()) {
                            ITimeCompressionListener list = this.listenerList.get(j);
                            list.deltaSelected(this.ll, this.ls, this.ln, this.lc);
                            ++j;
                        }
                        break;
                    }
                    lastM1 = m1;
                    lastM2 = m2;
                    lastY1 = m1Y;
                    lastY2 = m2Y;
                }
                ++i;
            }
        }
    }

    protected void createFakeTooltip() {
        block12: {
            if (this.tooltip == null) {
                this.tooltip = new DrawableToolTip(this);
            }
            if (this.frame == null) break block12;
            this.setFocus(0);
            int i = 0;
            while (i < this.nodeList.size() - 1) {
                block14: {
                    AsyncMessage as;
                    SDTimeEvent m2;
                    SDTimeEvent m1;
                    block13: {
                        m1 = this.nodeList.get(i);
                        m2 = this.nodeList.get(i + 1);
                        if (!SDViewPref.getInstance().excludeExternalTime() || !(m1.getGraphNode() instanceof BaseMessage) || !(m2.getGraphNode() instanceof BaseMessage)) break block13;
                        BaseMessage mes1 = (BaseMessage)((Object)m1.getGraphNode());
                        BaseMessage mes2 = (BaseMessage)((Object)m2.getGraphNode());
                        if (mes2.getStartLifeline() == null || mes1.getEndLifeline() == null) break block14;
                    }
                    int y1 = ((GraphNode)((Object)m1.getGraphNode())).getY();
                    int y2 = ((GraphNode)((Object)m2.getGraphNode())).getY();
                    if (m1.getGraphNode() instanceof AsyncMessage && (as = (AsyncMessage)m1.getGraphNode()).getEndTime() == m1.getTime()) {
                        y1 += as.getHeight();
                    }
                    if (m2.getGraphNode() instanceof AsyncMessage && (as = (AsyncMessage)m2.getGraphNode()).getEndTime() == m2.getTime()) {
                        y2 += as.getHeight();
                    }
                    if (m1.getGraphNode() instanceof ExecutionOccurrence) {
                        ExecutionOccurrence eo = (ExecutionOccurrence)m1.getGraphNode();
                        if (m1.getEvent() == eo.getEndOccurrence()) {
                            y1 += eo.getHeight();
                        }
                        if (m2.getGraphNode() instanceof ExecutionOccurrence) {
                            ExecutionOccurrence eo2 = (ExecutionOccurrence)m2.getGraphNode();
                            if (m2.getEvent() == eo2.getEndOccurrence()) {
                                y2 += eo2.getHeight();
                            }
                        }
                    }
                    int m1Y = Math.round((float)y1 * this.zoomValue);
                    int m2Y = Math.round((float)y2 * this.zoomValue);
                    if (m1Y < this.prevNodeY + 1 && m2Y >= this.prevNodeY + 1) {
                        TmfTimestamp delta = m2.getTime().getDelta(m1.getTime());
                        this.tooltip.showToolTip(delta, this.min, this.max);
                        this.tooltip.hideToolTip();
                    }
                }
                ++i;
            }
        }
    }
}

