/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.editors;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.linuxtools.tmf.trace.ITmfTrace;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.ide.IDE;

public class TmfEditorInput
implements IEditorInput {
    private IResource fResource;
    private ITmfTrace fTrace;

    public TmfEditorInput(IResource resource, ITmfTrace trace) {
        this.fResource = resource;
        this.fTrace = trace;
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public boolean exists() {
        return this.fResource.exists();
    }

    public ImageDescriptor getImageDescriptor() {
        if (this.fResource instanceof IFile) {
            IFile file = (IFile)this.fResource;
            IContentType contentType = IDE.getContentType((IFile)file);
            return PlatformUI.getWorkbench().getEditorRegistry().getImageDescriptor(file.getName(), contentType);
        }
        return null;
    }

    public String getName() {
        return this.fResource.getName();
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public String getToolTipText() {
        return this.fResource.getFullPath().makeRelative().toString();
    }

    public IResource getResource() {
        return this.fResource;
    }

    public ITmfTrace getTrace() {
        return this.fTrace;
    }

    public boolean equals(Object obj) {
        if (obj instanceof TmfEditorInput) {
            return this.fResource.equals((Object)((TmfEditorInput)obj).fResource);
        }
        if (obj instanceof IFileEditorInput) {
            return ((IFileEditorInput)obj).getFile().equals((Object)this.fResource);
        }
        if (obj instanceof FileStoreEditorInput) {
            return ((FileStoreEditorInput)obj).getURI().equals(this.fResource.getRawLocationURI());
        }
        return false;
    }
}

