/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.lttng.ui.tracecontrol.wizards;

import java.io.File;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.linuxtools.lttng.tracecontrol.model.TraceResource;
import org.eclipse.linuxtools.lttng.tracecontrol.model.config.TraceConfig;
import org.eclipse.linuxtools.lttng.ui.tracecontrol.Messages;
import org.eclipse.linuxtools.lttng.ui.tracecontrol.subsystems.TraceSubSystem;
import org.eclipse.linuxtools.lttng.ui.tracecontrol.wizards.ConfigureTraceWizard;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.ui.SystemBasePlugin;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class TraceConfigurationPage
extends WizardPage {
    private ConfigureTraceWizard fWizard;
    private String fTraceName;
    private String fTraceTransport;
    private String fTracePath;
    private int fMode;
    private int fNumChannel;
    private boolean fIsAppend;
    private boolean fIsNetwork;
    private Text fNameText;
    private Text fTransportText;
    private Text fPathText;
    private Text fNumLttdThreadsText;
    private Button fHostButton;
    private Button fTargetButton;
    private Button fIsAppendButton;
    private Button fFlightRecorderButton;
    private Button fNormalButton;
    private Display fDisplay;
    private String fTraceNameError;
    private String fTracePathError;
    private Button fBrowseButton;
    private TraceResource fTraceResource;
    private TraceConfig fOldTraceConfig;
    private TraceSubSystem fSubSystem;

    public TraceConfigurationPage(ConfigureTraceWizard wizard) {
        super("TraceConfigurationPage");
        this.setTitle(Messages.ConfigureTraceDialog_Title);
        this.fWizard = wizard;
        this.setPageComplete(false);
        this.fTraceNameError = "";
        this.fTracePathError = "";
        this.fTraceResource = this.fWizard.getSelectedTrace();
        this.fOldTraceConfig = this.fTraceResource.getTraceConfig();
        this.fSubSystem = (TraceSubSystem)this.fWizard.getSelectedTrace().getSubSystem();
    }

    public void createControl(Composite parent) {
        GridData griddata = new GridData();
        griddata = new GridData();
        Composite composite1 = new Composite(parent, 0);
        GridLayout compositeLayout1 = new GridLayout(4, false);
        composite1.setSize(520, 300);
        composite1.setLayout((Layout)compositeLayout1);
        griddata.horizontalSpan = 3;
        griddata.widthHint = 520;
        griddata.minimumWidth = 520;
        composite1.setLayoutData((Object)griddata);
        this.fDisplay = this.getShell().getDisplay();
        this.setControl((Control)composite1);
        Label nameLabel = new Label(composite1, 0);
        nameLabel.setText(String.valueOf(Messages.NewTraceDialog_TraceName) + ":");
        griddata = new GridData();
        griddata.verticalIndent = 20;
        nameLabel.setLayoutData((Object)griddata);
        this.fNameText = new Text(composite1, 2052);
        if (this.fTraceResource.isUst()) {
            this.fNameText.setText("auto");
            this.fNameText.setEnabled(false);
        }
        griddata = new GridData();
        griddata.horizontalAlignment = 4;
        griddata.grabExcessHorizontalSpace = true;
        griddata.verticalIndent = 20;
        griddata.horizontalSpan = 3;
        this.fNameText.setLayoutData((Object)griddata);
        this.fNameText.setText(this.fTraceResource.getName());
        this.fNameText.setEnabled(false);
        Label transportLabel = new Label(composite1, 0);
        transportLabel.setText(String.valueOf(Messages.ConfigureTraceDialog_Trace_Transport) + ":");
        griddata = new GridData();
        transportLabel.setLayoutData((Object)griddata);
        this.fTransportText = new Text(composite1, 2052);
        griddata = new GridData();
        griddata.horizontalAlignment = 4;
        griddata.grabExcessHorizontalSpace = true;
        griddata.horizontalSpan = 3;
        this.fTransportText.setLayoutData((Object)griddata);
        this.fTransportText.setText("relay");
        this.fTransportText.setEnabled(false);
        if (this.fOldTraceConfig != null) {
            this.fTransportText.setText(this.fOldTraceConfig.getTraceTransport());
        }
        griddata = new GridData();
        Group composite21 = new Group(composite1, 8);
        composite21.setSize(300, 300);
        composite21.setText(Messages.ConfigureTraceDialog_Trace_Location);
        griddata.horizontalAlignment = 4;
        griddata.horizontalSpan = 4;
        griddata.verticalIndent = 10;
        griddata.widthHint = 300;
        griddata.minimumWidth = 300;
        composite21.setLayoutData((Object)griddata);
        GridLayout compositeLayout21 = new GridLayout(4, false);
        composite21.setLayout((Layout)compositeLayout21);
        this.fTargetButton = new Button((Composite)composite21, 16);
        this.fTargetButton.setText(Messages.ConfigureTraceDialog_Target);
        this.fTargetButton.setSelection(true);
        this.fIsNetwork = false;
        this.fHostButton = new Button((Composite)composite21, 16);
        this.fHostButton.setText(Messages.ConfigureTraceDialog_Host);
        griddata = new GridData();
        griddata.horizontalSpan = 3;
        this.fHostButton.setLayoutData((Object)griddata);
        this.fHostButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                if (TraceConfigurationPage.this.fHostButton.getSelection()) {
                    TraceConfigurationPage.this.fBrowseButton.setEnabled(true);
                } else {
                    TraceConfigurationPage.this.fBrowseButton.setEnabled(false);
                }
                TraceConfigurationPage.this.fIsNetwork = TraceConfigurationPage.this.fHostButton.getSelection();
                TraceConfigurationPage.this.validatePathName(TraceConfigurationPage.this.fPathText.getText());
                TraceConfigurationPage.this.validate();
            }
        });
        Label pathLabel = new Label((Composite)composite21, 0);
        pathLabel.setText(Messages.ConfigureTraceDialog_Trace_Path);
        griddata = new GridData();
        griddata.verticalIndent = 10;
        pathLabel.setLayoutData((Object)griddata);
        this.fPathText = new Text((Composite)composite21, 2052);
        griddata = new GridData();
        griddata.horizontalAlignment = 4;
        griddata.grabExcessHorizontalSpace = true;
        griddata.verticalIndent = 10;
        this.fPathText.setLayoutData((Object)griddata);
        this.fPathText.setData((Object)"");
        this.fBrowseButton = new Button((Composite)composite21, 8);
        this.fBrowseButton.setText(String.valueOf(Messages.ConfigureTraceDialog_Browse) + "...");
        griddata = new GridData();
        griddata.grabExcessHorizontalSpace = false;
        griddata.widthHint = 100;
        griddata.verticalIndent = 10;
        this.fBrowseButton.setLayoutData((Object)griddata);
        this.fBrowseButton.setEnabled(false);
        this.fBrowseButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                DirectoryDialog dialog = new DirectoryDialog(TraceConfigurationPage.this.fDisplay.getActiveShell());
                String newPath = dialog.open();
                if (newPath != null) {
                    TraceConfigurationPage.this.fPathText.setText(newPath);
                }
            }
        });
        this.fNameText.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                TraceConfigurationPage.this.validateTraceName(TraceConfigurationPage.this.fNameText.getText());
                TraceConfigurationPage.this.validate();
            }
        });
        this.fTransportText.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                TraceConfigurationPage.this.validate();
            }
        });
        this.fPathText.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                if (!TraceConfigurationPage.this.fPathText.isEnabled()) {
                    return;
                }
                TraceConfigurationPage.this.validatePathName(TraceConfigurationPage.this.fPathText.getText());
                TraceConfigurationPage.this.validate();
            }
        });
        griddata = new GridData();
        Composite composite2 = new Composite(composite1, 0);
        GridLayout compositeLayout2 = new GridLayout(2, false);
        composite2.setLayout((Layout)compositeLayout2);
        griddata.horizontalSpan = 4;
        griddata.widthHint = 500;
        griddata.minimumWidth = 500;
        composite2.setLayoutData((Object)griddata);
        Label numLttdThreadsLabel = new Label(composite2, 0);
        numLttdThreadsLabel.setText(String.valueOf(Messages.ConfigureTraceDialog_Num_Lttd_Threads) + ":");
        griddata = new GridData();
        griddata.verticalIndent = 10;
        numLttdThreadsLabel.setLayoutData((Object)griddata);
        this.fNumLttdThreadsText = new Text(composite2, 2052);
        griddata = new GridData();
        griddata.horizontalAlignment = 1;
        griddata.verticalIndent = 10;
        griddata.widthHint = 50;
        griddata.minimumWidth = 50;
        this.fNumLttdThreadsText.setLayoutData((Object)griddata);
        if (this.fTraceResource.isUst()) {
            this.fNumLttdThreadsText.setText("1");
            this.fNumLttdThreadsText.setEnabled(false);
        } else {
            this.fNumLttdThreadsText.setText("2");
        }
        this.fNumLttdThreadsText.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                e.doit = e.text.matches("[0-9]*");
            }
        });
        this.fNumLttdThreadsText.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                TraceConfigurationPage.this.validate();
            }
        });
        this.fIsAppendButton = new Button(composite1, 32);
        this.fIsAppendButton.setText(Messages.ConfigureTraceDialog_Append);
        griddata = new GridData();
        griddata.horizontalAlignment = 1;
        griddata.horizontalSpan = 4;
        griddata.verticalIndent = 10;
        this.fIsAppendButton.setLayoutData((Object)griddata);
        this.fIsAppend = false;
        this.fIsAppendButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                TraceConfigurationPage.this.fIsAppend = TraceConfigurationPage.this.fIsAppendButton.getSelection();
            }
        });
        if (this.fTraceResource.isUst()) {
            this.fIsAppendButton.setEnabled(false);
        }
        griddata = new GridData();
        Group composite22 = new Group(composite1, 8);
        composite22.setText(Messages.ConfigureTraceDialog_Trace_Mode);
        griddata.horizontalSpan = 4;
        griddata.verticalIndent = 10;
        composite22.setLayoutData((Object)griddata);
        GridLayout compositeLayout22 = new GridLayout(2, false);
        composite22.setLayout((Layout)compositeLayout22);
        this.fNormalButton = new Button((Composite)composite22, 16);
        this.fNormalButton.setText(Messages.ConfigureTraceDialog_Mode_Normal);
        this.fFlightRecorderButton = new Button((Composite)composite22, 16);
        this.fFlightRecorderButton.setText(Messages.ConfigureTraceDialog_Mode_Flight_Recorder);
        this.fMode = 0;
        this.fNormalButton.setSelection(true);
        this.fNormalButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                if (TraceConfigurationPage.this.fNormalButton.getSelection()) {
                    TraceConfigurationPage.this.fMode = 0;
                }
            }
        });
        this.fFlightRecorderButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                if (TraceConfigurationPage.this.fFlightRecorderButton.getSelection()) {
                    TraceConfigurationPage.this.fMode = 1;
                }
            }
        });
        if (this.fTraceResource.isUst()) {
            this.fFlightRecorderButton.setEnabled(false);
            this.fNormalButton.setEnabled(false);
        }
        if (this.fOldTraceConfig != null) {
            this.fPathText.setText(this.fOldTraceConfig.getTracePath());
            this.fTargetButton.setSelection(!this.fOldTraceConfig.isNetworkTrace());
            this.fHostButton.setSelection(this.fOldTraceConfig.isNetworkTrace());
            this.fIsNetwork = this.fOldTraceConfig.isNetworkTrace();
            this.fBrowseButton.setEnabled(true);
            this.fNumLttdThreadsText.setText(String.valueOf(this.fOldTraceConfig.getNumChannel()));
            this.fIsAppendButton.setSelection(this.fOldTraceConfig.getIsAppend());
            this.fIsAppend = this.fOldTraceConfig.getIsAppend();
            this.fFlightRecorderButton.setSelection(this.fOldTraceConfig.getMode() == 1);
            this.fNormalButton.setSelection(this.fOldTraceConfig.getMode() == 0);
        }
        if (this.fTraceResource.getTraceState() == TraceResource.TraceState.STARTED || this.fTraceResource.getTraceState() == TraceResource.TraceState.PAUSED) {
            this.fPathText.setEnabled(false);
            this.fBrowseButton.setEnabled(false);
            this.fTargetButton.setEnabled(false);
            this.fHostButton.setEnabled(false);
            this.fIsAppendButton.setEnabled(false);
            this.fNumLttdThreadsText.setEnabled(false);
            this.fFlightRecorderButton.setEnabled(false);
            this.fNormalButton.setEnabled(false);
        }
        this.validate();
        this.fDisplay.getActiveShell().addListener(31, new Listener(){

            public void handleEvent(Event event) {
                if (event.detail == 2) {
                    event.doit = false;
                }
            }
        });
    }

    public void dispose() {
        super.dispose();
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.validate();
        }
        super.setVisible(visible);
    }

    protected boolean validateTraceName(String name) {
        if (name.length() > 0) {
            TraceResource[] traces = new TraceResource[]{};
            try {
                traces = this.fSubSystem.getAllTraces();
            }
            catch (SystemMessageException e) {
                SystemBasePlugin.logError((String)"TraceConfigurationPage ", (Throwable)e);
            }
            int i = 0;
            while (i < traces.length) {
                if (traces[i].getName().compareTo(name) == 0) {
                    this.fTraceNameError = Messages.NewTraceDialog_Error_Already_Exists;
                    this.setErrorMessage(this.fTraceNameError);
                    return false;
                }
                ++i;
            }
            char[] chars = name.toCharArray();
            int x = 0;
            while (x < chars.length) {
                char c = chars[x];
                if (!(x != 0 || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z')) {
                    this.fTraceNameError = Messages.NewTraceDialog_Error_Invalid_First_Char;
                    this.setErrorMessage(this.fTraceNameError);
                    return false;
                }
                if (!(x == 0 || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9')) {
                    this.fTraceNameError = Messages.NewTraceDialog_Error_Invalid_Name;
                    this.setErrorMessage(this.fTraceNameError);
                    return false;
                }
                ++x;
            }
        }
        if (this.fTracePathError.length() > 0) {
            this.setErrorMessage(this.fTracePathError);
        } else {
            this.setErrorMessage(null);
        }
        this.fTraceNameError = "";
        return true;
    }

    private boolean validatePathName(String path) {
        if (path.length() > 0) {
            char c0 = path.charAt(0);
            if (c0 != '/') {
                this.fTracePathError = Messages.ConfigureTraceDialog_Error_Invalid_Path;
                this.setErrorMessage(this.fTracePathError);
                return false;
            }
            String[] folders = path.split("/");
            int i = 0;
            while (i < folders.length) {
                char[] chars = folders[i].toCharArray();
                int x = 0;
                while (x < chars.length) {
                    char c = chars[x];
                    if (!(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9')) {
                        this.fTracePathError = Messages.ConfigureTraceDialog_Error_Invalid_Folder;
                        this.setErrorMessage(this.fTracePathError);
                        return false;
                    }
                    ++x;
                }
                ++i;
            }
            if (path.length() > 1) {
                i = 0;
                while (i < path.length() - 1) {
                    if (path.charAt(i) == '/' && path.charAt(i + 1) == '/') {
                        this.fTracePathError = Messages.ConfigureTraceDialog_Error_Multiple_Seps;
                        this.setErrorMessage(this.fTracePathError);
                        return false;
                    }
                    ++i;
                }
            }
            if (this.fHostButton.getSelection()) {
                File file = new File(path);
                if (file.isFile()) {
                    this.fTracePathError = Messages.ConfigureTraceDialog_Error_File_Exists;
                    this.setErrorMessage(this.fTracePathError);
                    return false;
                }
                if (path.length() > 1 && !file.getParentFile().canWrite()) {
                    this.fTracePathError = Messages.ConfigureTraceDialog_Error_Can_Not_Write;
                    this.setErrorMessage(this.fTracePathError);
                    return false;
                }
            }
        }
        if (this.fTraceNameError.length() > 0) {
            this.setErrorMessage(this.fTraceNameError);
        } else {
            this.setErrorMessage(null);
        }
        this.fTracePathError = "";
        return true;
    }

    private void validate() {
        if (this.fNameText.getText() == null || this.fTransportText.getText() == null || this.fTransportText.getText().length() == 0 || this.fNameText.getText().length() == 0 || this.fNumLttdThreadsText.getText().length() == 0 || this.fNumLttdThreadsText.getText().length() == 0) {
            this.setPageComplete(false);
            return;
        }
        if (this.fPathText.getText().length() == 0) {
            this.setPageComplete(false);
            return;
        }
        if (this.fTracePathError.length() > 0 || this.fTraceNameError.length() > 0) {
            this.setPageComplete(false);
            return;
        }
        this.fTraceName = this.fNameText.getText();
        this.fTraceTransport = this.fTransportText.getText();
        this.fTracePath = this.fPathText.getText();
        this.fNumChannel = Integer.parseInt(this.fNumLttdThreadsText.getText());
        if (this.fTraceNameError.length() == 0) {
            this.setErrorMessage(null);
            this.setPageComplete(true);
        } else {
            this.setErrorMessage(this.fTraceNameError);
            this.setPageComplete(false);
        }
    }

    public TraceConfig getTraceConfig() {
        TraceConfig newTraceConfig = new TraceConfig();
        newTraceConfig.setTraceName(this.fTraceName);
        newTraceConfig.setTraceTransport(this.fTraceTransport);
        newTraceConfig.setTracePath(this.fTracePath);
        newTraceConfig.setNetworkTrace(this.fIsNetwork);
        newTraceConfig.setIsAppend(this.fIsAppend);
        newTraceConfig.setMode(this.fMode);
        newTraceConfig.setNumChannel(this.fNumChannel);
        return newTraceConfig;
    }

    public boolean isLocalTrace() {
        return this.fHostButton.getSelection();
    }
}

