/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.filter.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.linuxtools.tmf.event.TmfEvent;
import org.eclipse.linuxtools.tmf.event.TmfNoSuchFieldException;
import org.eclipse.linuxtools.tmf.filter.model.ITmfFilterTreeNode;
import org.eclipse.linuxtools.tmf.filter.model.TmfFilterTreeNode;

public class TmfFilterContainsNode
extends TmfFilterTreeNode {
    public static final String NODE_NAME = "CONTAINS";
    public static final String NOT_ATTR = "not";
    public static final String FIELD_ATTR = "field";
    public static final String VALUE_ATTR = "value";
    public static final String IGNORECASE_ATTR = "ignorecase";
    private boolean fNot = false;
    private String fField;
    private String fValue;
    private String fValueUpperCase;
    private boolean fIgnoreCase = false;

    public TmfFilterContainsNode(ITmfFilterTreeNode parent) {
        super(parent);
    }

    public boolean isNot() {
        return this.fNot;
    }

    public void setNot(boolean not) {
        this.fNot = not;
    }

    public String getField() {
        return this.fField;
    }

    public void setField(String field) {
        this.fField = field;
    }

    public String getValue() {
        return this.fValue;
    }

    public void setValue(String value) {
        this.fValue = value;
        this.fValueUpperCase = value.toUpperCase();
    }

    public boolean isIgnoreCase() {
        return this.fIgnoreCase;
    }

    public void setIgnoreCase(boolean ignoreCase) {
        this.fIgnoreCase = ignoreCase;
    }

    @Override
    public String getNodeName() {
        return NODE_NAME;
    }

    @Override
    public boolean matches(TmfEvent event) {
        try {
            Object value = event.getContent().getField(this.fField);
            if (value == null) {
                return this.fNot;
            }
            String valueString = value.toString();
            if (this.fIgnoreCase) {
                return valueString.toUpperCase().contains(this.fValueUpperCase) ^ this.fNot;
            }
            return valueString.contains(this.fValue) ^ this.fNot;
        }
        catch (TmfNoSuchFieldException tmfNoSuchFieldException) {
            return this.fNot;
        }
    }

    @Override
    public List<String> getValidChildren() {
        return new ArrayList<String>(0);
    }

    public String toString() {
        return String.valueOf(this.fField) + (this.fNot ? " not" : "") + " contains \"" + this.fValue + "\"";
    }

    @Override
    public ITmfFilterTreeNode clone() {
        TmfFilterContainsNode clone = (TmfFilterContainsNode)super.clone();
        clone.fField = new String(this.fField);
        clone.setValue(new String(this.fValue));
        return clone;
    }
}

