/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.component;

import org.eclipse.linuxtools.tmf.Tracer;
import org.eclipse.linuxtools.tmf.component.TmfDataProvider;
import org.eclipse.linuxtools.tmf.event.TmfEvent;
import org.eclipse.linuxtools.tmf.event.TmfTimestamp;
import org.eclipse.linuxtools.tmf.request.ITmfDataRequest;
import org.eclipse.linuxtools.tmf.request.ITmfEventRequest;
import org.eclipse.linuxtools.tmf.request.TmfCoalescedEventRequest;

public abstract class TmfEventProvider<T extends TmfEvent>
extends TmfDataProvider<T> {
    public TmfEventProvider(String name, Class<T> type) {
        super(name, type);
    }

    public TmfEventProvider(String name, Class<T> type, int queueSize) {
        super(name, type, queueSize);
    }

    public TmfEventProvider(TmfEventProvider<T> oldProvider) {
        super(oldProvider);
    }

    @Override
    public boolean isCompleted(ITmfDataRequest<T> request, T data, int nbRead) {
        boolean requestCompleted = super.isCompleted(request, data, nbRead);
        if (!requestCompleted && request instanceof ITmfEventRequest && !((TmfEvent)data).isNullRef()) {
            TmfTimestamp endTime = ((ITmfEventRequest)request).getRange().getEndTime();
            return ((TmfEvent)data).getTimestamp().compareTo(endTime, false) > 0;
        }
        return requestCompleted;
    }

    @Override
    protected synchronized void newCoalescedDataRequest(ITmfDataRequest<T> request) {
        if (request instanceof ITmfEventRequest) {
            ITmfEventRequest eventRequest = (ITmfEventRequest)request;
            TmfCoalescedEventRequest coalescedRequest = new TmfCoalescedEventRequest(this.fType, eventRequest.getRange(), eventRequest.getNbRequested(), eventRequest.getBlockSize(), eventRequest.getExecType());
            coalescedRequest.addRequest(eventRequest);
            if (Tracer.isRequestTraced()) {
                Tracer.traceRequest(request, "coalesced with " + coalescedRequest.getRequestId());
            }
            this.fPendingCoalescedRequests.add(coalescedRequest);
        } else {
            super.newCoalescedDataRequest(request);
        }
    }
}

