/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.lttng.ui.views.histogram;

import org.eclipse.linuxtools.lttng.event.LttngEvent;
import org.eclipse.linuxtools.lttng.event.LttngTimestamp;
import org.eclipse.linuxtools.lttng.ui.views.histogram.ChildrenHistogramCanvas;
import org.eclipse.linuxtools.lttng.ui.views.histogram.HistogramCanvas;
import org.eclipse.linuxtools.lttng.ui.views.histogram.HistogramConstant;
import org.eclipse.linuxtools.lttng.ui.views.histogram.HistogramRequest;
import org.eclipse.linuxtools.lttng.ui.views.histogram.HistogramSelectedWindow;
import org.eclipse.linuxtools.lttng.ui.views.histogram.Messages;
import org.eclipse.linuxtools.lttng.ui.views.histogram.ParentHistogramCanvas;
import org.eclipse.linuxtools.lttng.ui.views.histogram.TimeTextGroup;
import org.eclipse.linuxtools.tmf.event.TmfTimeRange;
import org.eclipse.linuxtools.tmf.event.TmfTimestamp;
import org.eclipse.linuxtools.tmf.experiment.TmfExperiment;
import org.eclipse.linuxtools.tmf.request.ITmfDataRequest;
import org.eclipse.linuxtools.tmf.signal.TmfExperimentSelectedSignal;
import org.eclipse.linuxtools.tmf.signal.TmfRangeSynchSignal;
import org.eclipse.linuxtools.tmf.signal.TmfSignal;
import org.eclipse.linuxtools.tmf.signal.TmfSignalHandler;
import org.eclipse.linuxtools.tmf.signal.TmfTimeSynchSignal;
import org.eclipse.linuxtools.tmf.trace.ITmfTrace;
import org.eclipse.linuxtools.tmf.ui.views.TmfView;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class HistogramView
extends TmfView
implements ControlListener {
    public static final String ID = "org.eclipse.linuxtools.lttng.ui.views.histogram";
    private static final int SCREEN_SMALL_IF_SMALLER_THAN = 1600;
    private static final int FULL_TRACE_BAR_WIDTH = 1;
    private static final double FULL_TRACE_DIFFERENCE_TO_AVERAGE = 1.5;
    private static final int SELECTED_WINDOW_BAR_WIDTH = 1;
    private static final double SELECTED_WINDOW_DIFFERENCE_TO_AVERAGE = 10.0;
    private static final int NB_EVENTS_FIXED_WIDTH = 50;
    private static final int SMALL_FONT_MODIFIER = 2;
    private static final int VERY_SMALL_FONT_MODIFIER = 4;
    private static long DEFAULT_WINDOW_SIZE = 100000000L;
    private TmfExperiment<LttngEvent> lastUsedExperiment = null;
    private Composite parent = null;
    private HistogramRequest dataBackgroundFullRequest = null;
    private static ParentHistogramCanvas fullExperimentCanvas = null;
    private HistogramRequest selectedWindowRequest = null;
    private static ChildrenHistogramCanvas selectedWindowCanvas = null;
    private long currentEventTime = 0L;
    private Text txtExperimentStartTime = null;
    private Text txtExperimentStopTime = null;
    private Text txtWindowStartTime = null;
    private Text txtWindowStopTime = null;
    private Text txtWindowMaxNbEvents = null;
    private Text txtWindowMinNbEvents = null;
    private static final String WINDOW_TIMESPAN_LABEL_TEXT = Messages.HistogramView_windowSpanLabel;
    private static final String WINDOW_CENTER_TIME_LABEL_TEXT = Messages.HistogramView_windowCenterLabel;
    private static final String CURRENT_EVENT_TIME_LABEL_TEXT = Messages.HistogramView_currentEventLabel;
    private TimeTextGroup ntgWindowTimeSpan = null;
    private TimeTextGroup ntgWindowCenterTime = null;
    private TimeTextGroup ntgCurrentEventTime = null;

    public HistogramView() {
        super(ID);
    }

    public void createPartControl(Composite newParent) {
        this.parent = newParent;
        Font font = this.parent.getFont();
        FontData tmpFontData = font.getFontData()[0];
        Font smallFont = null;
        int nbEventWidth = -1;
        int selectedCanvasWidth = -1;
        boolean doesTimeTextGroupNeedAdjustment = false;
        if (this.parent.getDisplay().getBounds().width < 1600) {
            smallFont = new Font(font.getDevice(), tmpFontData.getName(), tmpFontData.getHeight() - 4, tmpFontData.getStyle());
            nbEventWidth = 25;
            doesTimeTextGroupNeedAdjustment = true;
        } else {
            smallFont = new Font(font.getDevice(), tmpFontData.getName(), tmpFontData.getHeight() - 2, tmpFontData.getStyle());
            nbEventWidth = 50;
            doesTimeTextGroupNeedAdjustment = false;
        }
        Composite layoutFullView = new Composite(this.parent, 4);
        GridLayout gridFullView = new GridLayout();
        gridFullView.numColumns = 2;
        gridFullView.horizontalSpacing = 0;
        gridFullView.verticalSpacing = 0;
        gridFullView.marginHeight = 0;
        gridFullView.marginWidth = 0;
        layoutFullView.setLayout((Layout)gridFullView);
        Composite layoutTimeSpinners = new Composite(layoutFullView, 0);
        GridLayout gridTimesSpinner = new GridLayout();
        gridTimesSpinner.numColumns = 3;
        gridTimesSpinner.marginHeight = 0;
        gridTimesSpinner.marginWidth = 0;
        gridTimesSpinner.horizontalSpacing = 5;
        gridTimesSpinner.verticalSpacing = 0;
        gridTimesSpinner.makeColumnsEqualWidth = true;
        gridTimesSpinner.marginLeft = 5;
        gridTimesSpinner.marginRight = 5;
        layoutTimeSpinners.setLayout((Layout)gridTimesSpinner);
        GridData gridDataCurrentEvent = new GridData();
        gridDataCurrentEvent.horizontalAlignment = 16384;
        gridDataCurrentEvent.verticalAlignment = 0x1000000;
        this.ntgCurrentEventTime = new TimeTextGroup(this, layoutTimeSpinners, 2048, 2048, CURRENT_EVENT_TIME_LABEL_TEXT, HistogramConstant.formatNanoSecondsTime(0L), doesTimeTextGroupNeedAdjustment);
        this.ntgCurrentEventTime.setLayoutData(gridDataCurrentEvent);
        GridData gridDataTimeSpan = new GridData();
        gridDataTimeSpan.horizontalAlignment = 0x1000000;
        gridDataTimeSpan.verticalAlignment = 0x1000000;
        this.ntgWindowTimeSpan = new TimeTextGroup(this, layoutTimeSpinners, 2048, 2048, WINDOW_TIMESPAN_LABEL_TEXT, HistogramConstant.formatNanoSecondsTime(0L), doesTimeTextGroupNeedAdjustment);
        this.ntgWindowTimeSpan.setLayoutData(gridDataTimeSpan);
        GridData gridDataWindowCenter = new GridData();
        gridDataWindowCenter.horizontalAlignment = 131072;
        gridDataWindowCenter.verticalAlignment = 0x1000000;
        this.ntgWindowCenterTime = new TimeTextGroup(this, layoutTimeSpinners, 2048, 2048, WINDOW_CENTER_TIME_LABEL_TEXT, HistogramConstant.formatNanoSecondsTime(0L), doesTimeTextGroupNeedAdjustment);
        this.ntgWindowCenterTime.setLayoutData(gridDataWindowCenter);
        Composite layoutSelectionWindow = new Composite(layoutFullView, 4);
        GridLayout gridSelectionWindow = new GridLayout();
        gridSelectionWindow.numColumns = 3;
        gridSelectionWindow.marginHeight = 0;
        gridSelectionWindow.marginWidth = 2;
        gridSelectionWindow.marginTop = 5;
        gridSelectionWindow.horizontalSpacing = 0;
        gridSelectionWindow.verticalSpacing = 0;
        layoutSelectionWindow.setLayout((Layout)gridSelectionWindow);
        GridData gridDataSelectionWindow = new GridData();
        gridDataSelectionWindow.horizontalAlignment = 4;
        gridDataSelectionWindow.verticalAlignment = 4;
        layoutSelectionWindow.setLayoutData((Object)gridDataSelectionWindow);
        GridData gridDataSelectionWindowCanvas = new GridData();
        gridDataSelectionWindowCanvas.horizontalSpan = 2;
        gridDataSelectionWindowCanvas.verticalSpan = 2;
        gridDataSelectionWindowCanvas.horizontalAlignment = 4;
        gridDataSelectionWindowCanvas.grabExcessHorizontalSpace = true;
        gridDataSelectionWindowCanvas.verticalAlignment = 4;
        gridDataSelectionWindowCanvas.widthHint = selectedCanvasWidth;
        gridDataSelectionWindowCanvas.minimumWidth = selectedCanvasWidth;
        selectedWindowCanvas = new ChildrenHistogramCanvas(this, layoutSelectionWindow, 2048);
        selectedWindowCanvas.setLayoutData(gridDataSelectionWindowCanvas);
        GridData gridDataWindowMaxEvents = new GridData();
        gridDataWindowMaxEvents.horizontalAlignment = 131072;
        gridDataWindowMaxEvents.verticalAlignment = 128;
        gridDataWindowMaxEvents.minimumWidth = nbEventWidth;
        this.txtWindowMaxNbEvents = new Text(layoutSelectionWindow, 8);
        this.txtWindowMaxNbEvents.setFont(smallFont);
        this.txtWindowMaxNbEvents.setBackground(this.parent.getDisplay().getSystemColor(34));
        this.txtWindowMaxNbEvents.setEditable(false);
        this.txtWindowMaxNbEvents.setText("0");
        this.txtWindowMaxNbEvents.setLayoutData((Object)gridDataWindowMaxEvents);
        GridData gridDataWindowMinEvents = new GridData();
        gridDataWindowMinEvents.horizontalAlignment = 131072;
        gridDataWindowMinEvents.verticalAlignment = 1024;
        gridDataWindowMinEvents.minimumWidth = nbEventWidth;
        this.txtWindowMinNbEvents = new Text(layoutSelectionWindow, 8);
        this.txtWindowMinNbEvents.setFont(smallFont);
        this.txtWindowMinNbEvents.setBackground(this.parent.getDisplay().getSystemColor(34));
        this.txtWindowMinNbEvents.setEditable(false);
        this.txtWindowMinNbEvents.setText("0");
        this.txtWindowMinNbEvents.setLayoutData((Object)gridDataWindowMinEvents);
        GridData gridDataWindowStart = new GridData();
        gridDataWindowStart.horizontalAlignment = 16384;
        gridDataWindowStart.verticalAlignment = 1024;
        this.txtWindowStartTime = new Text(layoutSelectionWindow, 8);
        this.txtWindowStartTime.setFont(smallFont);
        this.txtWindowStartTime.setBackground(this.parent.getDisplay().getSystemColor(34));
        this.txtWindowStartTime.setEditable(false);
        this.txtWindowStartTime.setText("0.000000000");
        this.txtWindowStartTime.setLayoutData((Object)gridDataWindowStart);
        GridData gridDataWindowStop = new GridData();
        gridDataWindowStop.horizontalAlignment = 131072;
        gridDataWindowStop.verticalAlignment = 1024;
        this.txtWindowStopTime = new Text(layoutSelectionWindow, 8);
        this.txtWindowStopTime.setFont(smallFont);
        this.txtWindowStopTime.setBackground(this.parent.getDisplay().getSystemColor(34));
        this.txtWindowStopTime.setEditable(false);
        this.txtWindowStopTime.setText("0.000000000");
        this.txtWindowStopTime.setLayoutData((Object)gridDataWindowStop);
        Composite layoutExperimentHistogram = new Composite(layoutFullView, 4);
        GridLayout gridExperimentHistogram = new GridLayout();
        gridExperimentHistogram.numColumns = 2;
        gridExperimentHistogram.marginHeight = 0;
        gridExperimentHistogram.marginWidth = 0;
        gridExperimentHistogram.horizontalSpacing = 0;
        gridExperimentHistogram.verticalSpacing = 0;
        gridExperimentHistogram.marginLeft = 5;
        gridExperimentHistogram.marginRight = 5;
        layoutExperimentHistogram.setLayout((Layout)gridExperimentHistogram);
        GridData gridDataExperimentCanvas = new GridData();
        gridDataExperimentCanvas.horizontalSpan = 2;
        gridDataExperimentCanvas.horizontalAlignment = 4;
        gridDataExperimentCanvas.grabExcessHorizontalSpace = true;
        gridDataExperimentCanvas.verticalAlignment = 4;
        gridDataExperimentCanvas.grabExcessVerticalSpace = true;
        fullExperimentCanvas = new ParentHistogramCanvas(this, layoutExperimentHistogram, 2048);
        fullExperimentCanvas.setLayoutData(gridDataExperimentCanvas);
        layoutExperimentHistogram.setLayoutData((Object)gridDataExperimentCanvas);
        GridData gridDataExperimentStart = new GridData();
        gridDataExperimentStart.horizontalAlignment = 16384;
        gridDataExperimentStart.verticalAlignment = 1024;
        this.txtExperimentStartTime = new Text(layoutExperimentHistogram, 8);
        this.txtExperimentStartTime.setFont(smallFont);
        this.txtExperimentStartTime.setText("0.000000000");
        this.txtExperimentStartTime.setBackground(this.parent.getDisplay().getSystemColor(34));
        this.txtExperimentStartTime.setEditable(false);
        this.txtExperimentStartTime.setLayoutData((Object)gridDataExperimentStart);
        GridData gridDataExperimentStop = new GridData();
        gridDataExperimentStop.horizontalAlignment = 131072;
        gridDataExperimentStop.verticalAlignment = 1024;
        this.txtExperimentStopTime = new Text(layoutExperimentHistogram, 8);
        this.txtExperimentStopTime.setFont(smallFont);
        this.txtExperimentStopTime.setText("0.000000000");
        this.txtExperimentStopTime.setBackground(this.parent.getDisplay().getSystemColor(34));
        this.txtExperimentStopTime.setEditable(false);
        this.txtExperimentStopTime.setLayoutData((Object)gridDataExperimentStop);
    }

    public void setFocus() {
        TmfExperiment tmpExperiment = TmfExperiment.getCurrentExperiment();
        if (this.dataBackgroundFullRequest == null && tmpExperiment != null) {
            this.createCanvasAndRequests((TmfExperiment<LttngEvent>)tmpExperiment);
        }
        this.parent.redraw();
    }

    @TmfSignalHandler
    public void experimentSelected(TmfExperimentSelectedSignal<LttngEvent> signal) {
        TmfExperiment tmpExperiment = signal.getExperiment();
        this.createCanvasAndRequests((TmfExperiment<LttngEvent>)tmpExperiment);
    }

    @TmfSignalHandler
    public void currentTimeUpdated(TmfTimeSynchSignal signal) {
        if (signal != null && signal.getSource() != this) {
            TmfTimestamp currentTime = signal.getCurrentTime();
            this.currentEventTime = currentTime.getValue();
            this.updateSelectedEventTime();
            if (!this.isGivenTimestampInSelectedWindow(this.currentEventTime)) {
                fullExperimentCanvas.setWindowCenterPosition(this.currentEventTime);
                this.windowChangedNotification();
                this.sendTmfRangeSynchSignalBroadcast();
            }
        }
    }

    @TmfSignalHandler
    public void synchToTimeRange(TmfRangeSynchSignal signal) {
        if (signal != null && this.lastUsedExperiment != null) {
            long currentTime = signal.getCurrentTime().getValue();
            long windowStart = signal.getCurrentRange().getStartTime().getValue();
            long windowEnd = signal.getCurrentRange().getEndTime().getValue();
            long windowTimeWidth = windowEnd - windowStart;
            fullExperimentCanvas.setSelectedWindowSize(windowTimeWidth);
            fullExperimentCanvas.setWindowCenterPosition(fullExperimentCanvas.getHistogramContent().getClosestXPositionFromTimestamp(windowStart + windowTimeWidth / 2L));
            if (!this.isGivenTimestampInSelectedWindow(currentTime)) {
                currentTime = windowStart;
            }
            this.currentEventTime = currentTime;
            this.windowChangedNotification();
            fullExperimentCanvas.redraw();
        }
    }

    private void createCanvasAndRequests(TmfExperiment<LttngEvent> newExperiment) {
        this.lastUsedExperiment = newExperiment;
        fullExperimentCanvas.createNewHistogramContent(HistogramView.fullExperimentCanvas.getSize().x, 1, HistogramView.fullExperimentCanvas.getSize().y / 2, 1.5);
        TmfTimeRange timeRange = this.getExperimentTimeRange(newExperiment);
        if (timeRange.getEndTime().getValue() - timeRange.getStartTime().getValue() > DEFAULT_WINDOW_SIZE) {
            fullExperimentCanvas.createNewSelectedWindow(timeRange.getStartTime().getValue(), DEFAULT_WINDOW_SIZE);
        } else {
            fullExperimentCanvas.createNewSelectedWindow(timeRange.getStartTime().getValue(), (timeRange.getEndTime().getValue() - timeRange.getStartTime().getValue()) / 2L);
        }
        this.currentEventTime = timeRange.getStartTime().getValue();
        fullExperimentCanvas.getCurrentWindow().setSelectedWindowVisible(true);
        fullExperimentCanvas.getHistogramContent().resetTable(timeRange.getStartTime().getValue(), timeRange.getEndTime().getValue());
        selectedWindowCanvas.createNewHistogramContent(HistogramView.selectedWindowCanvas.getSize().x, 1, HistogramView.selectedWindowCanvas.getSize().y, 10.0);
        selectedWindowCanvas.getHistogramContent().resetTable(fullExperimentCanvas.getCurrentWindow().getTimestampOfLeftPosition(), fullExperimentCanvas.getCurrentWindow().getTimestampOfRightPosition());
        this.resetControlsContent();
        if (this.dataBackgroundFullRequest != null) {
            fullExperimentCanvas.redraw();
            selectedWindowCanvas.redraw();
        }
        this.dataBackgroundFullRequest = null;
        this.selectedWindowRequest = null;
        this.performSelectedWindowEventsRequest(newExperiment);
        this.performAllTraceEventsRequest(newExperiment);
    }

    private TmfTimeRange getExperimentTimeRange(TmfExperiment<LttngEvent> experiment) {
        TmfTimestamp startTime = TmfTimestamp.BigCrunch;
        TmfTimestamp endTime = TmfTimestamp.BigBang;
        ITmfTrace[] iTmfTraceArray = experiment.getTraces();
        int n = iTmfTraceArray.length;
        int n2 = 0;
        while (n2 < n) {
            TmfTimestamp traceEndTime;
            ITmfTrace trace = iTmfTraceArray[n2];
            TmfTimestamp traceStartTime = trace.getStartTime();
            if (traceStartTime.compareTo(startTime, true) < 0) {
                startTime = traceStartTime;
            }
            if ((traceEndTime = trace.getEndTime()).compareTo(endTime, true) > 0) {
                endTime = traceEndTime;
            }
            ++n2;
        }
        TmfTimeRange tmpRange = new TmfTimeRange(startTime, endTime);
        return tmpRange;
    }

    public void performSelectedWindowEventsRequest(TmfExperiment<LttngEvent> experiment) {
        if (fullExperimentCanvas != null) {
            HistogramSelectedWindow curSelectedWindow = fullExperimentCanvas.getCurrentWindow();
            TmfTimeRange timeRange = this.getExperimentTimeRange(experiment);
            if (curSelectedWindow == null) {
                if (timeRange.getEndTime().getValue() - timeRange.getStartTime().getValue() > DEFAULT_WINDOW_SIZE) {
                    fullExperimentCanvas.createNewSelectedWindow(timeRange.getStartTime().getValue(), DEFAULT_WINDOW_SIZE);
                } else {
                    fullExperimentCanvas.createNewSelectedWindow(timeRange.getStartTime().getValue(), (timeRange.getEndTime().getValue() - timeRange.getStartTime().getValue()) / 2L);
                }
                curSelectedWindow = fullExperimentCanvas.getCurrentWindow();
            }
            LttngTimestamp ts1 = new LttngTimestamp(curSelectedWindow.getTimestampOfLeftPosition());
            LttngTimestamp ts2 = new LttngTimestamp(curSelectedWindow.getTimestampOfRightPosition());
            TmfTimeRange tmpRange = new TmfTimeRange((TmfTimestamp)ts1, (TmfTimestamp)ts2);
            long intervalTime = (ts2.getValue() - ts1.getValue()) / (long)selectedWindowCanvas.getHistogramContent().getNbElement();
            this.selectedWindowRequest = this.performRequest(experiment, selectedWindowCanvas, tmpRange, intervalTime, ITmfDataRequest.ExecutionType.FOREGROUND);
            selectedWindowCanvas.redrawAsynchronously();
        }
    }

    public void performAllTraceEventsRequest(TmfExperiment<LttngEvent> experiment) {
        TmfTimeRange tmpRange = this.getExperimentTimeRange(experiment);
        TmfTimestamp startTime = tmpRange.getStartTime();
        TmfTimestamp endTime = tmpRange.getEndTime();
        long intervalTime = (endTime.getValue() - startTime.getValue()) / (long)fullExperimentCanvas.getHistogramContent().getNbElement();
        this.dataBackgroundFullRequest = this.performRequest(experiment, fullExperimentCanvas, tmpRange, intervalTime, ITmfDataRequest.ExecutionType.BACKGROUND);
        fullExperimentCanvas.getCurrentWindow().setWindowXPositionLeft(fullExperimentCanvas.getHistogramContent().getClosestXPositionFromTimestamp(fullExperimentCanvas.getCurrentWindow().getTimestampOfLeftPosition()));
        fullExperimentCanvas.getCurrentWindow().setWindowXPositionCenter(fullExperimentCanvas.getHistogramContent().getClosestXPositionFromTimestamp(fullExperimentCanvas.getCurrentWindow().getTimestampOfCenterPosition()));
        fullExperimentCanvas.getCurrentWindow().setWindowXPositionRight(fullExperimentCanvas.getHistogramContent().getClosestXPositionFromTimestamp(fullExperimentCanvas.getCurrentWindow().getTimestampOfRightPosition()));
        fullExperimentCanvas.redrawAsynchronously();
    }

    private synchronized HistogramRequest performRequest(TmfExperiment<LttngEvent> experiment, HistogramCanvas targetCanvas, TmfTimeRange newRange, long newInterval, ITmfDataRequest.ExecutionType execType) {
        HistogramRequest returnedRequest = null;
        returnedRequest = new HistogramRequest(newRange, Integer.MAX_VALUE, targetCanvas, newInterval, execType);
        experiment.sendRequest((ITmfDataRequest)returnedRequest);
        return returnedRequest;
    }

    public void windowChangedNotification() {
        if (this.lastUsedExperiment != null) {
            if (this.selectedWindowRequest != null && !this.selectedWindowRequest.isCompleted()) {
                this.selectedWindowRequest.cancel();
            }
            if (fullExperimentCanvas != null && !this.isGivenTimestampInSelectedWindow(this.currentEventTime)) {
                this.currentEventChangeNotification(fullExperimentCanvas.getCurrentWindow().getTimestampOfLeftPosition());
            }
            this.performSelectedWindowEventsRequest(this.lastUsedExperiment);
        }
    }

    public void currentEventChangeNotification(long newCurrentEventTime) {
        if (this.currentEventTime != newCurrentEventTime) {
            this.currentEventTime = newCurrentEventTime;
            if (this.currentEventTime < fullExperimentCanvas.getHistogramContent().getStartTime()) {
                this.currentEventTime = fullExperimentCanvas.getHistogramContent().getStartTime();
            }
            if (this.currentEventTime > fullExperimentCanvas.getHistogramContent().getEndTime()) {
                this.currentEventTime = fullExperimentCanvas.getHistogramContent().getEndTime();
            }
            this.updateSelectedEventTime();
        }
    }

    public void sendTmfTimeSynchSignalBroadcast() {
        LttngTimestamp tmpTimestamp = new LttngTimestamp(this.currentEventTime);
        this.broadcast((TmfSignal)new TmfTimeSynchSignal((Object)this, (TmfTimestamp)tmpTimestamp));
    }

    public void sendTmfRangeSynchSignalBroadcast() {
        if (TmfExperiment.getCurrentExperiment() == null) {
            return;
        }
        long startTime = fullExperimentCanvas.getCurrentWindow().getTimestampOfLeftPosition();
        if (startTime < fullExperimentCanvas.getHistogramContent().getStartTime()) {
            startTime = fullExperimentCanvas.getHistogramContent().getStartTime();
        }
        LttngTimestamp tmpStartTime = new LttngTimestamp(startTime);
        long endTime = fullExperimentCanvas.getCurrentWindow().getTimestampOfRightPosition();
        if (endTime > fullExperimentCanvas.getHistogramContent().getEndTime()) {
            endTime = fullExperimentCanvas.getHistogramContent().getEndTime();
        }
        LttngTimestamp tmpEndTime = new LttngTimestamp(endTime);
        TmfTimeRange tmpTimeRange = new TmfTimeRange((TmfTimestamp)tmpStartTime, (TmfTimestamp)tmpEndTime);
        LttngTimestamp tmpEventTime = new LttngTimestamp(this.currentEventTime);
        this.broadcast((TmfSignal)new TmfRangeSynchSignal((Object)this, tmpTimeRange, (TmfTimestamp)tmpEventTime));
    }

    public void timeTextGroupChangeNotification() {
        long newSelectedWindowTimeRange;
        long newSelectedWindowTime;
        long newCurrentTime;
        if (this.ntgCurrentEventTime != null && (newCurrentTime = this.ntgCurrentEventTime.getValue()) != this.currentEventTime) {
            this.currentEventChangeNotification(newCurrentTime);
            this.sendTmfTimeSynchSignalBroadcast();
        }
        if (this.ntgWindowCenterTime != null && fullExperimentCanvas != null && (newSelectedWindowTime = this.ntgWindowCenterTime.getValue()) != fullExperimentCanvas.getCurrentWindow().getTimestampOfCenterPosition()) {
            fullExperimentCanvas.setWindowCenterPosition(newSelectedWindowTime);
            this.sendTmfRangeSynchSignalBroadcast();
        }
        if (this.ntgWindowTimeSpan != null && fullExperimentCanvas != null && (newSelectedWindowTimeRange = this.ntgWindowTimeSpan.getValue()) != fullExperimentCanvas.getCurrentWindow().getWindowTimeWidth()) {
            fullExperimentCanvas.resizeWindowByAbsoluteTime(newSelectedWindowTimeRange);
            this.sendTmfRangeSynchSignalBroadcast();
        }
    }

    public TmfExperiment<LttngEvent> getLastUsedExperiment() {
        return this.lastUsedExperiment;
    }

    public boolean isGivenTimestampInSelectedWindow(long timestamp) {
        boolean returnedValue = true;
        if (timestamp < fullExperimentCanvas.getCurrentWindow().getTimestampOfLeftPosition() || timestamp > fullExperimentCanvas.getCurrentWindow().getTimestampOfRightPosition()) {
            returnedValue = false;
        }
        return returnedValue;
    }

    public void resetControlsContent() {
        TmfExperiment<LttngEvent> tmpExperiment = this.getLastUsedExperiment();
        String startTime = null;
        String stopTime = null;
        if (tmpExperiment != null) {
            startTime = HistogramConstant.formatNanoSecondsTime(tmpExperiment.getStartTime().getValue());
            stopTime = HistogramConstant.formatNanoSecondsTime(tmpExperiment.getEndTime().getValue());
        } else {
            startTime = HistogramConstant.formatNanoSecondsTime(0L);
            stopTime = HistogramConstant.formatNanoSecondsTime(0L);
        }
        this.txtExperimentStartTime.setText(startTime);
        this.txtExperimentStopTime.setText(stopTime);
        this.txtExperimentStartTime.getParent().layout();
        this.txtWindowMaxNbEvents.setText("0");
        this.txtWindowMinNbEvents.setText("0");
        this.txtWindowStartTime.setText(HistogramConstant.formatNanoSecondsTime(0L));
        this.txtWindowStopTime.setText(HistogramConstant.formatNanoSecondsTime(0L));
        this.txtWindowStartTime.getParent().layout();
        this.ntgWindowCenterTime.setValue(HistogramConstant.formatNanoSecondsTime(0L));
        this.ntgWindowTimeSpan.setValue(HistogramConstant.formatNanoSecondsTime(0L));
        this.ntgCurrentEventTime.setValue(HistogramConstant.formatNanoSecondsTime(0L));
    }

    public void updateFullExperimentInformation() {
        if (fullExperimentCanvas != null) {
            String startTime = HistogramConstant.formatNanoSecondsTime(fullExperimentCanvas.getHistogramContent().getStartTime());
            String stopTime = HistogramConstant.formatNanoSecondsTime(fullExperimentCanvas.getHistogramContent().getEndTime());
            this.txtExperimentStartTime.setText(startTime);
            this.txtExperimentStopTime.setText(stopTime);
        }
        this.txtExperimentStartTime.getParent().layout();
        this.updateSelectedWindowInformation();
    }

    public void updateSelectedWindowInformation() {
        this.updateSelectedWindowTimestamp();
        if (selectedWindowCanvas != null) {
            this.txtWindowMaxNbEvents.setText(Long.toString(selectedWindowCanvas.getHistogramContent().getHeighestEventCount()));
            this.txtWindowMinNbEvents.setText(Long.toString(0L));
        }
        this.txtWindowMaxNbEvents.getParent().layout();
    }

    public void updateSelectedWindowTimestamp() {
        if (selectedWindowCanvas != null) {
            String startTime = HistogramConstant.formatNanoSecondsTime(selectedWindowCanvas.getHistogramContent().getStartTime());
            String stopTime = HistogramConstant.formatNanoSecondsTime(selectedWindowCanvas.getHistogramContent().getEndTime());
            this.txtWindowStartTime.setText(startTime);
            this.txtWindowStopTime.setText(stopTime);
        }
        if (fullExperimentCanvas != null) {
            this.ntgWindowCenterTime.setValue(fullExperimentCanvas.getCurrentWindow().getTimestampOfCenterPosition());
            this.ntgWindowTimeSpan.setValue(fullExperimentCanvas.getCurrentWindow().getWindowTimeWidth());
            if (!this.isGivenTimestampInSelectedWindow(this.ntgCurrentEventTime.getValue())) {
                this.currentEventChangeNotification(fullExperimentCanvas.getCurrentWindow().getTimestampOfCenterPosition());
            }
        }
        this.txtWindowStartTime.getParent().layout();
        this.ntgWindowCenterTime.getParent().layout();
    }

    public void updateSelectedEventTime() {
        this.ntgCurrentEventTime.setValueAsynchronously(this.currentEventTime);
        selectedWindowCanvas.getHistogramContent().setSelectedEventTimeInWindow(this.currentEventTime);
        selectedWindowCanvas.redrawAsynchronously();
    }

    public void controlMoved(ControlEvent event) {
        this.parent.redraw();
    }

    public void controlResized(ControlEvent event) {
        if (this.parent.getDisplay().getBounds().width > fullExperimentCanvas.getHistogramContent().getNbElement() && this.lastUsedExperiment != null) {
            this.createCanvasAndRequests(this.lastUsedExperiment);
        }
    }

    public static ParentHistogramCanvas getFullExperimentCanvas() {
        return fullExperimentCanvas;
    }

    public static ChildrenHistogramCanvas getSelectedWindowCanvas() {
        return selectedWindowCanvas;
    }

    public static long getDEFAULT_WINDOW_SIZE() {
        return DEFAULT_WINDOW_SIZE;
    }

    public HistogramRequest getDataBackgroundFullRequest() {
        return this.dataBackgroundFullRequest;
    }

    public HistogramRequest getSelectedWindowRequest() {
        return this.selectedWindowRequest;
    }
}

