/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.cdt.autotools.ui.text.hover;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextHoverExtension;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.linuxtools.cdt.autotools.core.AutotoolsPlugin;
import org.eclipse.linuxtools.cdt.autotools.ui.AutotoolsUIPlugin;
import org.eclipse.linuxtools.cdt.autotools.ui.editors.AutoconfEditor;
import org.eclipse.linuxtools.cdt.autotools.ui.editors.AutoconfMacro;
import org.eclipse.linuxtools.cdt.autotools.ui.editors.IAutotoolEditorActionDefinitionIds;
import org.eclipse.linuxtools.internal.cdt.autotools.core.AutotoolsPropertyConstants;
import org.eclipse.linuxtools.internal.cdt.autotools.ui.CWordFinder;
import org.eclipse.linuxtools.internal.cdt.autotools.ui.HTMLPrinter;
import org.eclipse.linuxtools.internal.cdt.autotools.ui.HTMLTextPresenter;
import org.eclipse.linuxtools.internal.cdt.autotools.ui.text.hover.AutoconfPrototype;
import org.eclipse.linuxtools.internal.cdt.autotools.ui.text.hover.HoverMessages;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.keys.IBindingService;
import org.osgi.framework.Bundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class AutoconfTextHover
implements ITextHover,
ITextHoverExtension {
    public static String LOCAL_AUTOCONF_MACROS_DOC_NAME = "macros/acmacros";
    public static String LOCAL_AUTOMAKE_MACROS_DOC_NAME = "macros/ammacros";
    public static String AUTOCONF_MACROS_DOC_NAME = "http://www.sourceware.org/eclipse/autotools/acmacros";
    public static String AUTOMAKE_MACROS_DOC_NAME = "http://www.sourceware.org/eclipse/autotools/ammacros";
    private static Map<String, Document> acHoverDocs;
    private static Map<String, Document> amHoverDocs;
    private static Map<Document, ArrayList<AutoconfMacro>> acHoverMacros;
    private static String fgStyleSheet;
    private static AutoconfEditor fEditor;
    private static IBindingService fBindingService;

    public static String getAutoconfMacrosDocName(String version) {
        return String.valueOf(AUTOCONF_MACROS_DOC_NAME) + "-" + version + ".xml";
    }

    public static String getLocalAutoconfMacrosDocName(String version) {
        return String.valueOf(LOCAL_AUTOCONF_MACROS_DOC_NAME) + "-" + version + ".xml";
    }

    public static String getDefaultAutoconfMacrosVer() {
        return AutotoolsPlugin.getDefault().getPreferenceStore().getString("autoconf_version");
    }

    public static String getAutomakeMacrosDocName(String version) {
        return String.valueOf(AUTOMAKE_MACROS_DOC_NAME) + "-" + version + ".xml";
    }

    public static String getLocalAutomakeMacrosDocName(String version) {
        return String.valueOf(LOCAL_AUTOMAKE_MACROS_DOC_NAME) + "-" + version + ".xml";
    }

    public static String getDefaultAutomakeMacrosVer() {
        return AutotoolsPlugin.getDefault().getPreferenceStore().getString("automake_version");
    }

    protected static Document getACDoc(String acDocVer) {
        Document ac_document = null;
        if (acHoverDocs == null) {
            acHoverDocs = new HashMap<String, Document>();
        }
        if ((ac_document = acHoverDocs.get(acDocVer)) == null) {
            Document doc = null;
            try {
                try {
                    IPath p;
                    InputStream docStream = null;
                    try {
                        URI uri = new URI(AutoconfTextHover.getLocalAutoconfMacrosDocName(acDocVer));
                        p = URIUtil.toPath((URI)uri);
                        docStream = FileLocator.openStream((Bundle)AutotoolsPlugin.getDefault().getBundle(), (IPath)p, (boolean)false);
                    }
                    catch (IOException iOException) {
                        URI acDoc = new URI(AutoconfTextHover.getAutoconfMacrosDocName(acDocVer));
                        p = URIUtil.toPath((URI)acDoc);
                        if (p == null) {
                            URL url = acDoc.toURL();
                            docStream = url.openStream();
                        }
                        docStream = new FileInputStream(p.toFile());
                    }
                    DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                    factory.setValidating(false);
                    try {
                        DocumentBuilder builder = factory.newDocumentBuilder();
                        doc = builder.parse(docStream);
                    }
                    catch (SAXParseException sAXParseException) {
                        doc = null;
                    }
                    catch (SAXException sAXException) {
                        doc = null;
                    }
                    catch (ParserConfigurationException parserConfigurationException) {
                        doc = null;
                    }
                    catch (IOException iOException) {
                        doc = null;
                    }
                }
                catch (FileNotFoundException e) {
                    AutotoolsPlugin.log((Throwable)e);
                }
                catch (MalformedURLException e) {
                    AutotoolsPlugin.log((Throwable)e);
                }
                catch (URISyntaxException e) {
                    AutotoolsPlugin.log((Throwable)e);
                }
                ac_document = doc;
            }
            catch (IOException iOException) {}
        }
        acHoverDocs.put(acDocVer, ac_document);
        return ac_document;
    }

    protected static Document getAMDoc(String amDocVer) {
        Document am_document = null;
        if (amHoverDocs == null) {
            amHoverDocs = new HashMap<String, Document>();
        }
        if ((am_document = amHoverDocs.get(amDocVer)) == null) {
            Document doc = null;
            try {
                try {
                    IPath p;
                    InputStream docStream = null;
                    try {
                        URI uri = new URI(AutoconfTextHover.getLocalAutomakeMacrosDocName(amDocVer));
                        p = URIUtil.toPath((URI)uri);
                        docStream = FileLocator.openStream((Bundle)AutotoolsPlugin.getDefault().getBundle(), (IPath)p, (boolean)false);
                    }
                    catch (IOException iOException) {
                        URI acDoc = new URI(AutoconfTextHover.getAutomakeMacrosDocName(amDocVer));
                        p = URIUtil.toPath((URI)acDoc);
                        if (p == null) {
                            URL url = acDoc.toURL();
                            docStream = url.openStream();
                        }
                        docStream = new FileInputStream(p.toFile());
                    }
                    DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                    factory.setValidating(false);
                    try {
                        DocumentBuilder builder = factory.newDocumentBuilder();
                        doc = builder.parse(docStream);
                    }
                    catch (SAXParseException sAXParseException) {
                        doc = null;
                    }
                    catch (SAXException sAXException) {
                        doc = null;
                    }
                    catch (ParserConfigurationException parserConfigurationException) {
                        doc = null;
                    }
                    catch (IOException iOException) {
                        doc = null;
                    }
                }
                catch (FileNotFoundException e) {
                    AutotoolsPlugin.log((Throwable)e);
                }
                catch (MalformedURLException e) {
                    AutotoolsPlugin.log((Throwable)e);
                }
                catch (URISyntaxException e) {
                    AutotoolsPlugin.log((Throwable)e);
                }
                am_document = doc;
            }
            catch (IOException iOException) {}
        }
        amHoverDocs.put(amDocVer, am_document);
        return am_document;
    }

    protected static AutotoolsHoverDoc getHoverDoc(IEditorInput input) {
        String acDocVer = AutoconfTextHover.getDefaultAutoconfMacrosVer();
        String amDocVer = AutoconfTextHover.getDefaultAutomakeMacrosVer();
        if (input instanceof IFileEditorInput) {
            IFileEditorInput fe = (IFileEditorInput)input;
            IFile f = fe.getFile();
            IProject p = f.getProject();
            try {
                String acVer = p.getPersistentProperty(AutotoolsPropertyConstants.AUTOCONF_VERSION);
                if (acVer != null) {
                    acDocVer = acVer;
                } else {
                    acVer = p.getPersistentProperty(AutotoolsPropertyConstants.AUTOCONF_VERSION_COMPAT);
                    if (acVer != null) {
                        acDocVer = acVer;
                    }
                }
            }
            catch (CoreException coreException) {}
            try {
                String amVer = p.getPersistentProperty(AutotoolsPropertyConstants.AUTOMAKE_VERSION);
                if (amVer != null) {
                    amDocVer = amVer;
                } else {
                    amVer = p.getPersistentProperty(AutotoolsPropertyConstants.AUTOMAKE_VERSION_COMPAT);
                    if (amVer != null) {
                        amDocVer = amVer;
                    }
                }
            }
            catch (CoreException coreException) {}
        }
        Document ac_document = AutoconfTextHover.getACDoc(acDocVer);
        Document am_document = AutoconfTextHover.getAMDoc(amDocVer);
        return new AutotoolsHoverDoc(ac_document, am_document);
    }

    public AutoconfTextHover(AutoconfEditor editor) {
        fBindingService = (IBindingService)PlatformUI.getWorkbench().getAdapter(IBindingService.class);
        fEditor = editor;
    }

    public static String getIndexedInfo(String name, AutoconfEditor editor) {
        AutotoolsHoverDoc h = AutoconfTextHover.getHoverDoc(editor.getEditorInput());
        String x = AutoconfTextHover.getIndexedInfoFromDocument(name, h.getAcDocument());
        if (x == null) {
            x = AutoconfTextHover.getIndexedInfoFromDocument(name, h.getAmDocument());
        }
        return x;
    }

    private static String getIndexedInfoFromDocument(String name, Document document) {
        Element elem;
        StringBuffer buffer = new StringBuffer();
        if (document != null && name != null && (elem = document.getElementById(name)) != null) {
            int prototypeCount = 0;
            buffer.append("<B>Macro:</B> " + name);
            NodeList nl = elem.getChildNodes();
            int i = 0;
            while (i < nl.getLength()) {
                Node n = nl.item(i);
                String nodeName = n.getNodeName();
                if (nodeName.equals("prototype")) {
                    String prototype = "";
                    if (++prototypeCount == 1) {
                        buffer.append(" (");
                    } else {
                        buffer.append("    <B>or</B> " + name + " (<I>");
                    }
                    NodeList varList = n.getChildNodes();
                    int j = 0;
                    while (j < varList.getLength()) {
                        Node v = varList.item(j);
                        String vnodeName = v.getNodeName();
                        if (vnodeName.equals("parameter")) {
                            NamedNodeMap parms = v.getAttributes();
                            Node parmNode = parms.item(0);
                            String parm = parmNode.getNodeValue();
                            prototype = prototype.equals("") ? parm : String.valueOf(prototype) + ", " + parm;
                        }
                        ++j;
                    }
                    buffer.append(String.valueOf(prototype) + "</I>)<br>");
                }
                if (nodeName.equals("synopsis")) {
                    Node textNode = n.getLastChild();
                    buffer.append("<br><B>Synopsis:</B> ");
                    buffer.append(textNode.getNodeValue());
                }
                ++i;
            }
        }
        if (buffer.length() > 0) {
            HTMLPrinter.insertPageProlog(buffer, 0);
            HTMLPrinter.addPageEpilog(buffer);
            return buffer.toString();
        }
        return null;
    }

    public static AutoconfMacro[] getMacroList(AutoconfEditor editor) {
        IEditorInput input = editor.getEditorInput();
        AutotoolsHoverDoc hoverdoc = AutoconfTextHover.getHoverDoc(input);
        AutoconfMacro[] macros = AutoconfTextHover.getMacroList(hoverdoc);
        return macros;
    }

    private static AutoconfMacro[] getMacroList(AutotoolsHoverDoc hoverdoc) {
        if (acHoverMacros == null) {
            acHoverMacros = new HashMap<Document, ArrayList<AutoconfMacro>>();
        }
        ArrayList<AutoconfMacro> masterList = new ArrayList<AutoconfMacro>();
        Document[] doc = hoverdoc.getDocuments();
        int ix = 0;
        while (ix < doc.length) {
            Document macroDoc = doc[ix];
            ArrayList<AutoconfMacro> list = acHoverMacros.get(macroDoc);
            if (list == null && macroDoc != null) {
                list = new ArrayList();
                NodeList nl = macroDoc.getElementsByTagName("macro");
                int i = 0;
                while (i < nl.getLength()) {
                    Node macro = nl.item(i);
                    NamedNodeMap macroAttrs = macro.getAttributes();
                    Node n2 = macroAttrs.getNamedItem("id");
                    if (n2 != null) {
                        String name = n2.getNodeValue();
                        String parms = "";
                        NodeList macroChildren = macro.getChildNodes();
                        int j = 0;
                        while (j < macroChildren.getLength()) {
                            Node x = macroChildren.item(j);
                            if (x.getNodeName().equals("prototype")) {
                                NodeList parmList = x.getChildNodes();
                                int parmCount = 0;
                                int k = 0;
                                while (k < parmList.getLength()) {
                                    Node n3 = parmList.item(k);
                                    if (n3.getNodeName() == "parameter") {
                                        NamedNodeMap parmVals = n3.getAttributes();
                                        Node parmVal = parmVals.item(0);
                                        if (parmCount > 0) {
                                            parms = String.valueOf(parms) + ", ";
                                        }
                                        parms = String.valueOf(parms) + parmVal.getNodeValue();
                                        ++parmCount;
                                    }
                                    ++k;
                                }
                            }
                            ++j;
                        }
                        AutoconfMacro m = new AutoconfMacro(name, parms);
                        list.add(m);
                    }
                    ++i;
                }
                acHoverMacros.put(macroDoc, list);
            }
            masterList.addAll(list);
            ++ix;
        }
        Object[] macros = new AutoconfMacro[masterList.size()];
        masterList.toArray(macros);
        Arrays.sort(macros);
        return macros;
    }

    public static AutoconfPrototype getPrototype(String name, AutoconfEditor editor) {
        IEditorInput input = editor.getEditorInput();
        AutotoolsHoverDoc hoverdoc = AutoconfTextHover.getHoverDoc(input);
        AutoconfPrototype x = AutoconfTextHover.getPrototype(name, hoverdoc.getAcDocument());
        if (x == null) {
            x = AutoconfTextHover.getPrototype(name, hoverdoc.getAmDocument());
        }
        return x;
    }

    private static AutoconfPrototype getPrototype(String name, Document document) {
        Element elem;
        AutoconfPrototype p = null;
        if (document != null && name != null && (elem = document.getElementById(name)) != null) {
            int prototypeCount = -1;
            p = new AutoconfPrototype();
            p.setName(name);
            NodeList nl = elem.getChildNodes();
            int i = 0;
            while (i < nl.getLength()) {
                Node n = nl.item(i);
                String nodeName = n.getNodeName();
                if (nodeName.equals("prototype")) {
                    int parmCount = 0;
                    int minParmCount = -1;
                    p.setNumPrototypes(++prototypeCount + 1);
                    NodeList varList = n.getChildNodes();
                    int j = 0;
                    while (j < varList.getLength()) {
                        Node v = varList.item(j);
                        String vnodeName = v.getNodeName();
                        if (vnodeName.equals("parameter")) {
                            ++parmCount;
                            NamedNodeMap parms = v.getAttributes();
                            Node parmNode = parms.item(0);
                            String parm = parmNode.getNodeValue();
                            if (minParmCount < 0 && (parm.charAt(0) == '[' || parm.startsWith("..."))) {
                                minParmCount = parmCount - 1;
                            } else if (minParmCount < 0 && parm.endsWith("[")) {
                                minParmCount = parmCount;
                            }
                            p.setParmName(prototypeCount, parmCount - 1, parm);
                        }
                        ++j;
                    }
                    p.setMaxParms(prototypeCount, parmCount);
                    if (minParmCount < 0) {
                        minParmCount = parmCount;
                    }
                    p.setMinParms(prototypeCount, minParmCount);
                }
                ++i;
            }
        }
        return p;
    }

    public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        String hoverInfo = null;
        IDocument d = textViewer.getDocument();
        try {
            String name = d.get(hoverRegion.getOffset(), hoverRegion.getLength());
            hoverInfo = AutoconfTextHover.getIndexedInfo(name, fEditor);
        }
        catch (BadLocationException badLocationException) {}
        return hoverInfo;
    }

    public IRegion getHoverRegion(ITextViewer textViewer, int offset) {
        if (textViewer != null) {
            Point selectedRange = textViewer.getSelectedRange();
            if (selectedRange.x >= 0 && selectedRange.y > 0 && offset >= selectedRange.x && offset <= selectedRange.x + selectedRange.y) {
                return new Region(selectedRange.x, selectedRange.y);
            }
            return CWordFinder.findWord(textViewer.getDocument(), offset);
        }
        return null;
    }

    public IInformationControlCreator getHoverControlCreator() {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                return new DefaultInformationControl(parent, AutoconfTextHover.getTooltipAffordanceString(), (DefaultInformationControl.IInformationPresenter)new HTMLTextPresenter(false));
            }
        };
    }

    public static IInformationControlCreator getInformationControlCreator() {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                return new DefaultInformationControl(parent, AutoconfTextHover.getTooltipAffordanceString(), (DefaultInformationControl.IInformationPresenter)new HTMLTextPresenter(false));
            }
        };
    }

    protected static String getTooltipAffordanceString() {
        if (fBindingService == null) {
            return null;
        }
        String keySequence = fBindingService.getBestActiveBindingFormattedFor(IAutotoolEditorActionDefinitionIds.SHOW_TOOLTIP);
        if (keySequence == null) {
            return null;
        }
        return HoverMessages.getFormattedString("ToolTipFocus", keySequence == null ? "" : keySequence);
    }

    protected static String getStyleSheet() {
        Bundle bundle;
        URL styleSheetURL;
        if (fgStyleSheet == null && (styleSheetURL = (bundle = Platform.getBundle((String)"org.eclipse.linuxtools.cdt.autotools.ui")).getEntry("/AutoconfHoverStyleSheet.css")) != null) {
            try {
                styleSheetURL = FileLocator.toFileURL((URL)styleSheetURL);
                BufferedReader reader = new BufferedReader(new InputStreamReader(styleSheetURL.openStream()));
                StringBuffer buffer = new StringBuffer(200);
                String line = reader.readLine();
                while (line != null) {
                    buffer.append(line);
                    buffer.append('\n');
                    line = reader.readLine();
                }
                fgStyleSheet = buffer.toString();
            }
            catch (IOException ex) {
                AutotoolsUIPlugin.log(ex);
                fgStyleSheet = "";
            }
        }
        return fgStyleSheet;
    }

    private static class AutotoolsHoverDoc {
        public Document[] documents = new Document[2];

        public AutotoolsHoverDoc(Document ac_document, Document am_document) {
            this.documents[0] = ac_document;
            this.documents[1] = am_document;
        }

        public Document getAcDocument() {
            return this.documents[0];
        }

        public Document getAmDocument() {
            return this.documents[1];
        }

        public Document[] getDocuments() {
            return this.documents;
        }
    }
}

