/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.internal.ui.formatting;

import java.util.HashMap;
import java.util.Map;

public class DefaultCodeFormatterOptions {
    private static final int DEFAULT_INDENT_SIZE = 4;
    private static final int DEFAULT_TAB_SIZE = 4;
    public static final int TAB = 1;
    public static final int SPACE = 2;
    public static final int MIXED = 4;
    public int indentation_size;
    public int tab_char;
    public int tab_size;
    public int comment_line_length;

    public static DefaultCodeFormatterOptions getDefaultSettings() {
        DefaultCodeFormatterOptions options = new DefaultCodeFormatterOptions();
        options.setDefaultSettings();
        return options;
    }

    public static DefaultCodeFormatterOptions getEclipseDefaultSettings() {
        DefaultCodeFormatterOptions options = new DefaultCodeFormatterOptions();
        options.setEclipseDefaultSettings();
        return options;
    }

    public static DefaultCodeFormatterOptions getRubyConventionsSettings() {
        DefaultCodeFormatterOptions options = new DefaultCodeFormatterOptions();
        options.setRubyConventionsSettings();
        return options;
    }

    private DefaultCodeFormatterOptions() {
    }

    public DefaultCodeFormatterOptions(Map settings) {
        this.setDefaultSettings();
        if (settings == null) {
            return;
        }
        this.set(settings);
    }

    public void setDefaultSettings() {
        this.tab_char = 1;
        this.tab_size = 4;
        this.indentation_size = 4;
    }

    public void setEclipseDefaultSettings() {
        this.setRubyConventionsSettings();
    }

    public void setRubyConventionsSettings() {
        this.setDefaultSettings();
        this.tab_char = 2;
        this.tab_size = 2;
        this.indentation_size = 2;
    }

    public Map getMap() {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("org.eclipse.dltk.javascript.ui.formatter.comment.line_length", Integer.toString(this.comment_line_length));
        options.put("org.eclipse.dltk.javascript.ui.formatter.indentation.size", Integer.toString(this.indentation_size));
        switch (this.tab_char) {
            case 2: {
                options.put("org.eclipse.dltk.javascript.ui.formatter.tabulation.char", "space");
                break;
            }
            case 1: {
                options.put("org.eclipse.dltk.javascript.ui.formatter.tabulation.char", "tab");
                break;
            }
            case 4: {
                options.put("org.eclipse.dltk.javascript.ui.formatter.tabulation.char", "mixed");
            }
        }
        options.put("org.eclipse.dltk.javascript.ui.formatter.tabulation.size", Integer.toString(this.tab_size));
        return options;
    }

    public void set(Map settings) {
        Object useTabOption;
        Object tabSizeOption;
        Object indentationSizeOption;
        Object commentLineLengthOption = settings.get("org.eclipse.dltk.javascript.ui.formatter.comment.line_length");
        if (commentLineLengthOption != null) {
            try {
                this.comment_line_length = Integer.parseInt((String)commentLineLengthOption);
            }
            catch (NumberFormatException numberFormatException) {
                this.comment_line_length = 80;
            }
            catch (ClassCastException classCastException) {
                this.comment_line_length = 80;
            }
        }
        if ((indentationSizeOption = settings.get("org.eclipse.dltk.javascript.ui.formatter.indentation.size")) != null) {
            try {
                this.indentation_size = Integer.parseInt((String)indentationSizeOption);
            }
            catch (NumberFormatException numberFormatException) {
                this.indentation_size = 4;
            }
            catch (ClassCastException classCastException) {
                this.indentation_size = 4;
            }
        }
        if ((tabSizeOption = settings.get("org.eclipse.dltk.javascript.ui.formatter.tabulation.size")) != null) {
            try {
                this.tab_size = Integer.parseInt((String)tabSizeOption);
            }
            catch (NumberFormatException numberFormatException) {
                this.tab_size = 4;
            }
            catch (ClassCastException classCastException) {
                this.tab_size = 4;
            }
        }
        if ((useTabOption = settings.get("org.eclipse.dltk.javascript.ui.formatter.tabulation.char")) != null) {
            this.tab_char = "tab".equals(useTabOption) ? 1 : ("space".equals(useTabOption) ? 2 : 4);
        }
    }
}

