/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.ast;

import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.javascript.ast.Expression;
import org.eclipse.dltk.javascript.ast.Keyword;
import org.eclipse.dltk.javascript.ast.Statement;

public class WithStatement
extends Statement {
    private Keyword withKeyword;
    private Expression expression;
    private Statement statement;
    private int LP = -1;
    private int RP = -1;

    public WithStatement(ASTNode parent) {
        super(parent);
    }

    public Expression getExpression() {
        return this.expression;
    }

    public void setExpression(Expression expression) {
        this.expression = expression;
    }

    public Statement getStatement() {
        return this.statement;
    }

    public void setStatement(Statement statement) {
        this.statement = statement;
    }

    public Keyword getWithKeyword() {
        return this.withKeyword;
    }

    public void setWithKeyword(Keyword keyword) {
        this.withKeyword = keyword;
    }

    public int getLP() {
        return this.LP;
    }

    public void setLP(int LP) {
        this.LP = LP;
    }

    public int getRP() {
        return this.RP;
    }

    public void setRP(int RP) {
        this.RP = RP;
    }

    public String toSourceString(String indentationString) {
        Assert.isTrue((this.sourceStart() >= 0 ? 1 : 0) != 0);
        Assert.isTrue((this.sourceEnd() > 0 ? 1 : 0) != 0);
        Assert.isTrue((this.LP > 0 ? 1 : 0) != 0);
        Assert.isTrue((this.RP > 0 ? 1 : 0) != 0);
        StringBuffer buffer = new StringBuffer();
        buffer.append(indentationString);
        buffer.append("with");
        buffer.append(" (");
        buffer.append(this.getExpression().toSourceString(indentationString));
        buffer.append(")\n");
        buffer.append(this.getStatement().toSourceString(indentationString));
        return buffer.toString();
    }

    public boolean isBlock() {
        return true;
    }
}

