/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.ast;

import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.javascript.ast.ExceptionFilter;
import org.eclipse.dltk.javascript.ast.Identifier;
import org.eclipse.dltk.javascript.ast.Keyword;
import org.eclipse.dltk.javascript.ast.Statement;

public class CatchClause
extends Statement {
    private Keyword catchKeyword;
    private Identifier exception;
    private ExceptionFilter exceptionFilter = null;
    private Statement statement;
    private int LP = -1;
    private int RP = -1;

    public CatchClause(ASTNode parent) {
        super(parent);
    }

    public Identifier getException() {
        return this.exception;
    }

    public void setException(Identifier exception) {
        this.exception = exception;
    }

    public ExceptionFilter getExceptionFilter() {
        return this.exceptionFilter;
    }

    public void setExceptionFilter(ExceptionFilter filter) {
        this.exceptionFilter = filter;
    }

    public Statement getStatement() {
        return this.statement;
    }

    public void setStatement(Statement statement) {
        this.statement = statement;
    }

    public Keyword getCatchKeyword() {
        return this.catchKeyword;
    }

    public void setCatchKeyword(Keyword keyword) {
        this.catchKeyword = keyword;
    }

    public int getLP() {
        return this.LP;
    }

    public void setLP(int LP) {
        this.LP = LP;
    }

    public int getRP() {
        return this.RP;
    }

    public void setRP(int RP) {
        this.RP = RP;
    }

    public String toSourceString(String indentationString) {
        Assert.isTrue((this.sourceStart() > 0 ? 1 : 0) != 0);
        Assert.isTrue((this.sourceEnd() > 0 ? 1 : 0) != 0);
        Assert.isTrue((this.LP > 0 ? 1 : 0) != 0);
        Assert.isTrue((this.RP > 0 ? 1 : 0) != 0);
        StringBuffer buffer = new StringBuffer();
        buffer.append(indentationString);
        buffer.append("catch");
        buffer.append(" (");
        buffer.append(this.exception.toSourceString(indentationString));
        if (this.exceptionFilter != null) {
            buffer.append(' ');
            buffer.append(this.exceptionFilter.toSourceString(indentationString));
        }
        buffer.append(")\n");
        buffer.append(this.statement.toSourceString(indentationString));
        return buffer.toString();
    }

    public boolean isBlock() {
        return true;
    }
}

