/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.internal.ui.templates;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.declarations.MethodDeclaration;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.declarations.TypeDeclaration;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.ast.statements.Statement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.javascript.internal.ui.formatting.OldCodeFormatter;
import org.eclipse.dltk.ui.templates.ScriptTemplateContext;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateBuffer;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.TemplateException;

public class JavaScriptTemplateContext
extends ScriptTemplateContext {
    public JavaScriptTemplateContext(TemplateContextType type, IDocument document, int completionOffset, int completionLength, ISourceModule sourceModule) {
        super(type, document, completionOffset, completionLength, sourceModule);
    }

    public TemplateBuffer evaluate(Template template) throws BadLocationException, TemplateException {
        if (!this.canEvaluate(template)) {
            return null;
        }
        JavaScriptTemplateContext.calculateIndent((IDocument)this.getDocument(), (int)this.getStart());
        TextUtilities.getDefaultLineDelimiter((IDocument)this.getDocument());
        String lines = template.getPattern();
        StringBuffer bf = new StringBuffer();
        boolean in = false;
        HashMap<String, String> qs = new HashMap<String, String>();
        String sp0 = "specialSecret12435Id";
        String sp = String.valueOf(sp0) + '0';
        String cId = null;
        int r = 0;
        int pos = -1;
        int a = 0;
        while (a < lines.length()) {
            char c = lines.charAt(a);
            if (c == '$' && a < lines.length() - 1 && lines.charAt(a + 1) == '{') {
                in = true;
                bf.append(sp);
                pos = a;
            }
            if (in && c == '}') {
                String tv = lines.substring(pos, a + 1);
                if (tv.equals("${cursor}")) {
                    cId = sp;
                }
                qs.put(sp, tv);
                sp = String.valueOf(sp0) + ++r;
                in = false;
            } else if (!in) {
                bf.append(c);
            }
            ++a;
        }
        OldCodeFormatter formater = new OldCodeFormatter(Collections.EMPTY_MAP);
        String string = bf.toString();
        String formatted = formater.formatString(string, new StringBuffer());
        Iterator it = qs.keySet().iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            String value = (String)qs.get(key);
            if (key == cId) {
                String replaced = JavaScriptTemplateContext.replaceSeq(formatted, String.valueOf(key) + ";", value);
                if (replaced == formatted) {
                    replaced = JavaScriptTemplateContext.replaceSeq(formatted, key, value);
                }
                formatted = replaced;
                continue;
            }
            formatted = JavaScriptTemplateContext.replaceSeq(formatted, key, value);
        }
        template = new Template(template.getName(), template.getDescription(), template.getContextTypeId(), formatted, template.isAutoInsertable());
        return super.evaluate(template);
    }

    private static String replaceSeq(String sq, String target, String replacement) {
        int indexOf = sq.indexOf(target);
        while (indexOf != -1) {
            sq = String.valueOf(sq.substring(0, indexOf)) + replacement + sq.substring(indexOf + target.length());
            indexOf = sq.indexOf(target);
        }
        return sq;
    }

    private static class FormattingAstVisitor
    extends ASTVisitor {
        private int indentLevel;
        private String text;

        private void printContent(ASTNode node) {
            int start = node.sourceStart();
            int end = node.sourceEnd();
            System.out.println("Begin index: " + start);
            System.out.println("End index: " + end);
            System.out.println("Real node type: " + node.getClass());
            if (start >= 0 && start < this.text.length() && end >= 0 && end < this.text.length()) {
                System.out.println("=== Text ===");
                System.out.println(this.text.substring(start, end));
            }
        }

        public FormattingAstVisitor(String text) {
            this.text = text;
            this.indentLevel = 0;
        }

        public boolean visit(Expression s) throws Exception {
            this.printContent((ASTNode)s);
            return true;
        }

        public boolean visit(MethodDeclaration s) throws Exception {
            this.printContent((ASTNode)s);
            return true;
        }

        public boolean visit(ModuleDeclaration s) throws Exception {
            this.printContent((ASTNode)s);
            return true;
        }

        public boolean visit(Statement s) throws Exception {
            System.out.println("FormattingAstVisitor.visit(Statement s)");
            return true;
        }

        public boolean visit(TypeDeclaration s) throws Exception {
            this.printContent((ASTNode)s);
            return true;
        }

        public boolean visitGeneral(ASTNode node) throws Exception {
            return true;
        }

        public boolean endvisit(Expression s) throws Exception {
            return true;
        }

        public boolean endvisit(MethodDeclaration s) throws Exception {
            return true;
        }

        public boolean endvisit(ModuleDeclaration s) throws Exception {
            return true;
        }

        public boolean endvisit(Statement s) throws Exception {
            return true;
        }

        public boolean endvisit(TypeDeclaration s) throws Exception {
            return true;
        }
    }
}

