/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.javascript.typeinference;

import com.xored.org.mozilla.javascript.FunctionNode;
import com.xored.org.mozilla.javascript.Node;
import com.xored.org.mozilla.javascript.ScriptOrFnNode;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.StringTokenizer;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.dltk.compiler.ISourceElementRequestor;
import org.eclipse.dltk.internal.core.ModelElement;
import org.eclipse.dltk.internal.javascript.reference.resolvers.ReferenceResolverContext;
import org.eclipse.dltk.internal.javascript.typeinference.AutoCompleteReference;
import org.eclipse.dltk.internal.javascript.typeinference.CallResultReference;
import org.eclipse.dltk.internal.javascript.typeinference.CombinedOrReference;
import org.eclipse.dltk.internal.javascript.typeinference.ContextReference;
import org.eclipse.dltk.internal.javascript.typeinference.HostCollection;
import org.eclipse.dltk.internal.javascript.typeinference.IReference;
import org.eclipse.dltk.internal.javascript.typeinference.NewReference;
import org.eclipse.dltk.internal.javascript.typeinference.NodeSwitch;
import org.eclipse.dltk.internal.javascript.typeinference.PositionReachedException;
import org.eclipse.dltk.internal.javascript.typeinference.ReferenceFactory;
import org.eclipse.dltk.internal.javascript.typeinference.TransparentRef;
import org.eclipse.dltk.internal.javascript.typeinference.UnknownReference;
import org.eclipse.dltk.utils.TextUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class TypeInferencer {
    private ReferenceResolverContext cs;
    Stack contexts = new Stack();
    Map functionNodes = new HashMap();
    HostCollection collection = new HostCollection(null);
    ModelElement module;
    static SAXParser parser;
    ISourceElementRequestor requestor;

    static {
        try {
            parser = SAXParserFactory.newInstance().newSAXParser();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new LinkageError();
        }
        catch (SAXException sAXException) {
            throw new LinkageError();
        }
    }

    public TypeInferencer(ModelElement owner, ReferenceResolverContext cs) {
        this.module = owner;
        this.cs = cs;
    }

    public HostCollection getCollection() {
        return this.collection;
    }

    public IReference evaluateReference(String key, Node expression, ReferenceResolverContext cs) {
        IReference internalEvaluate = TypeInferencer.internalEvaluate(this.collection, key, expression, this.module, cs);
        if (internalEvaluate == null) {
            return new UnknownReference(key, false);
        }
        return internalEvaluate;
    }

    static IReference internalEvaluate(HostCollection collection, String key, Node expression, ModelElement parent, ReferenceResolverContext cs) {
        if (expression == null) {
            return null;
        }
        int type = expression.getType();
        switch (type) {
            case 130: {
                return TypeInferencer.internalEvaluate(collection, key, expression.getFirstChild(), parent, cs);
            }
            case 39: {
                NewReference newReference = new NewReference(key, "Number", cs);
                UnknownReference uncknownReference = new UnknownReference(key, false);
                return new CombinedOrReference(newReference, uncknownReference);
            }
            case 40: {
                NewReference newReference = new NewReference(key, "String", cs);
                UnknownReference uncknownReference = new UnknownReference(key, false);
                return new CombinedOrReference(newReference, uncknownReference);
            }
            case 43: 
            case 44: {
                NewReference newReference = new NewReference(key, "Boolean", cs);
                UnknownReference uncknownReference = new UnknownReference(key, false);
                return new CombinedOrReference(newReference, uncknownReference);
            }
            case 64: {
                return TypeInferencer.createObjectLiteral(collection, key, expression, parent, cs);
            }
            case 63: {
                return TypeInferencer.createArrayLiteralReference(collection, key, expression, cs);
            }
            case 37: {
                return TypeInferencer.createCallResult(collection, key, expression, cs);
            }
            case 105: {
                return TypeInferencer.createNewFunctionReference(collection, key, expression);
            }
            case 30: {
                return TypeInferencer.createNewObjectRefernce(collection, key, expression, cs);
            }
            case 33: 
            case 35: 
            case 38: {
                IReference ref;
                String key1 = TypeInferencer.getObjId(expression);
                if (key1.endsWith(".e")) {
                    key1 = key1.substring(0, key1.length() - 2);
                }
                if ((ref = collection.queryElement(key1, true)) == null) {
                    ref = TypeInferencer.resolveReferenceTree(key, cs, key1, ref);
                }
                if (ref != null) {
                    ref = new TransparentRef(ref, expression, key, parent, cs);
                }
                return ref;
            }
        }
        return null;
    }

    private static IReference resolveReferenceTree(String key, ReferenceResolverContext cs, String key1, IReference ref) {
        Set resolveGlobals = cs.resolveGlobals(key1);
        if (resolveGlobals.size() > 0) {
            ref = new AutoCompleteReference(key, key1, cs);
        }
        return ref;
    }

    private static IReference createNewFunctionReference(HostCollection collection2, String key, Node expression) {
        HostCollection function = collection2.getFunction(expression);
        if (function == null) {
            return null;
        }
        return new ContextReference(function, key);
    }

    private static IReference createCallResult(HostCollection collection2, String key, Node expression, ReferenceResolverContext cs) {
        Node nm = expression.getFirstChild();
        String id = TypeInferencer.getObjId(nm);
        if (id == null) {
            return null;
        }
        CallResultReference ref = new CallResultReference(collection2, key, id, cs);
        CombinedOrReference ws = new CombinedOrReference(ref, new UnknownReference(key, false));
        return ws;
    }

    private static IReference createNewObjectRefernce(HostCollection collection2, String key, Node expression, ReferenceResolverContext cs) {
        Node nm = expression.getFirstChild();
        String id = TypeInferencer.getObjId(nm);
        if (id == null) {
            return null;
        }
        NewReference ref = new NewReference(key, id, cs);
        UnknownReference unknownReference = new UnknownReference(key, false);
        if (id.equals("XML")) {
            try {
                String string = expression.getLastChild().getString();
                TypeInferencer.modifyReferenceXML(unknownReference, string, cs);
            }
            catch (ClassCastException classCastException) {}
        }
        CombinedOrReference ws = new CombinedOrReference(ref, unknownReference);
        return ws;
    }

    private static IReference createArrayLiteralReference(HostCollection collection2, String key, Node expression, ReferenceResolverContext cs) {
        String id = "Array";
        NewReference ref = new NewReference(key, id, cs);
        UnknownReference unknownReference = new UnknownReference(key, false);
        CombinedOrReference ws = new CombinedOrReference(ref, unknownReference);
        return ws;
    }

    private static void modifyReferenceXML(final UnknownReference uncknownReference, String string, final ReferenceResolverContext cs) {
        try {
            parser.parse((InputStream)new ByteArrayInputStream(string.getBytes()), new DefaultHandler(){
                boolean has = false;
                IReference curReference;
                Stack stack;
                {
                    this.curReference = unknownReference;
                    this.stack = new Stack();
                }

                public void endElement(String uri, String localName, String name) throws SAXException {
                    if (!this.stack.isEmpty()) {
                        this.stack.pop();
                        this.curReference = !this.stack.isEmpty() ? (IReference)this.stack.peek() : uncknownReference;
                    } else {
                        this.curReference = uncknownReference;
                    }
                }

                public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
                    if (name.indexOf(58) != -1) {
                        name = TextUtils.replace((String)name, (char)':', (String)"::");
                    }
                    NewReference elementNewRef = new NewReference(name, "XML", cs);
                    UnknownReference uncknownReference2 = new UnknownReference(name, true);
                    CombinedOrReference corf = new CombinedOrReference(elementNewRef, uncknownReference2);
                    int length = attributes.getLength();
                    if (this.has) {
                        this.curReference.setChild(name, corf);
                        this.curReference = corf;
                        this.stack.push(this.curReference);
                    }
                    int a = 0;
                    while (a < length) {
                        String val = "@" + attributes.getQName(a);
                        if (val.indexOf(58) != -1) {
                            val = TextUtils.replace((String)val, (char)':', (String)"::");
                        }
                        NewReference attrNewRef = new NewReference(val, "XMLATTR", null);
                        UnknownReference uncknownReference3 = new UnknownReference(val, true);
                        CombinedOrReference attrCorf = new CombinedOrReference(attrNewRef, uncknownReference3);
                        this.curReference.setChild(val, attrCorf);
                        ++a;
                    }
                    this.has = true;
                }
            });
        }
        catch (SAXException sAXException) {
        }
        catch (IOException iOException) {}
    }

    private static IReference createObjectLiteral(HostCollection col, String key, Node expression, ModelElement parent, ReferenceResolverContext cs) {
        Object[] ids = (Object[])expression.getProp(12);
        ArrayList positions = (ArrayList)expression.getProp(4);
        Node child = expression.getFirstChild();
        UnknownReference uRef = new UnknownReference(key, false);
        int a = 0;
        while (a < ids.length) {
            if (ids[a] instanceof String) {
                String name = (String)ids[a];
                IReference internalEvaluate = TypeInferencer.internalEvaluate(col, name, child, parent, cs);
                if (internalEvaluate == null) {
                    internalEvaluate = new UnknownReference(name, false);
                }
                internalEvaluate.setLocationInformation(parent, (Integer)positions.get(a) - name.length() - 1, name.length());
                uRef.setChild(name, internalEvaluate);
                child = child.getNext();
            }
            ++a;
        }
        return uRef;
    }

    public static String getObjId(Node id) {
        if (id == null) {
            return "";
        }
        switch (id.getType()) {
            case 37: {
                Node n = id.getFirstChild();
                return TypeInferencer.getObjId(n);
            }
            case 33: {
                Node n = id.getFirstChild();
                String result = String.valueOf(TypeInferencer.getObjId(n)) + '.' + id.getLastChild().getString();
                return result;
            }
            case 35: {
                Node n = id.getFirstChild();
                String res = TypeInferencer.getObjId(n);
                return String.valueOf(res) + "[]";
            }
            case 42: {
                return "this";
            }
            case 38: 
            case 48: {
                return TypeInferencer.getKey(id);
            }
        }
        return null;
    }

    public static String getKey(Node id) {
        try {
            return id.getString();
        }
        catch (ClassCastException classCastException) {
            return "";
        }
    }

    public HostCollection doInterferencing(ScriptOrFnNode node, int tillPosition) {
        HostCollection hostCollection = new HostCollection(null);
        TypeInferencerSwitch sw = new TypeInferencerSwitch(node, tillPosition);
        sw.doAction(node, hostCollection);
        return hostCollection;
    }

    public Map getFunctionMap() {
        return this.functionNodes;
    }

    public void setRequestor(ISourceElementRequestor requestor) {
        this.requestor = requestor;
    }

    private final class TypeInferencerSwitch
    extends NodeSwitch {
        LinkedList functionContexts = new LinkedList();

        private TypeInferencerSwitch(ScriptOrFnNode module, int position) {
            super(module, position);
        }

        public Object processNewNode(Node node, Object arg) {
            try {
                Node firstChild = node.getFirstChild();
                TypeInferencer.getObjId(firstChild.getNext());
                String call = TypeInferencer.getObjId(firstChild);
                if (call == null) {
                    return super.processNewNode(node, arg);
                }
                int length = call.length();
                int indexOf = call.indexOf(46);
                if (indexOf != -1) {
                    call = call.substring(indexOf + 1);
                }
                if (TypeInferencer.this.requestor != null && call != null && firstChild.getPosition() != 0) {
                    TypeInferencer.this.requestor.acceptMethodReference(call.toCharArray(), 0, firstChild.getPosition() - length, firstChild.getPosition() - 1);
                }
            }
            catch (Throwable throwable) {}
            return super.processScriptNode(node, arg);
        }

        public Object processCall(Node node, Object arg) {
            try {
                Node firstChild = node.getFirstChild();
                String objId = TypeInferencer.getObjId(firstChild.getNext());
                String call = TypeInferencer.getObjId(firstChild);
                if (call == null) {
                    return super.processNewNode(node, arg);
                }
                int length = call.length();
                int indexOf = call.indexOf(46);
                if (indexOf != -1) {
                    call = call.substring(indexOf + 1);
                }
                TypeInferencer.this.cs.processCall(call, objId);
                if (TypeInferencer.this.requestor != null && call != null && firstChild.getPosition() != 0) {
                    int start = firstChild.getPosition() - length;
                    int end = firstChild.getPosition() - 1;
                    TypeInferencer.this.requestor.acceptMethodReference(call.toCharArray(), 0, start, end);
                }
            }
            catch (Throwable throwable) {}
            return super.processCall(node, arg);
        }

        public Object processSetElemNode(Node node, Object arg) {
            if (node.getFirstChild().getNext() instanceof Node.StringNode) {
                String objId = TypeInferencer.getObjId(node.getFirstChild());
                String fieldId = node.getFirstChild().getNext().getString();
                this.internalSetProp(node, objId, fieldId);
            } else {
                String string = String.valueOf(TypeInferencer.getObjId(node.getFirstChild())) + "[]";
                TypeInferencer.this.collection.write(string, TypeInferencer.this.evaluateReference(string, node.getLastChild(), TypeInferencer.this.cs));
            }
            return arg;
        }

        public Object processSwitch(Node node, Object arg) {
            Object processScriptNode = this.processScriptNode(node, arg);
            return processScriptNode;
        }

        public Object processBlock(Node node, Object arg) {
            Node nm = node.getFirstChild();
            if (nm instanceof Node.Jump) {
                Node.Jump jm = (Node.Jump)nm;
                int type = nm.getType();
                if (type == 7) {
                    return this.processIf(arg, jm);
                }
            }
            Object processScriptNode = this.processScriptNode(node, arg);
            return processScriptNode;
        }

        public Object processReturn(Node node, Object arg) {
            IReference r = TypeInferencer.this.evaluateReference("!!!returnValue", node.getFirstChild(), TypeInferencer.this.cs);
            TypeInferencer.this.collection.setReference("!!!returnValue", r);
            return arg;
        }

        public Object processHookNode(Node node, Object arg) {
            HostCollection root = TypeInferencer.this.collection;
            TypeInferencer.this.contexts.push(root);
            HostCollection ifContext = new HostCollection(root);
            HostCollection elseContext = new HostCollection(root);
            TypeInferencer.this.collection = ifContext;
            Node ifNode = node.getFirstChild().getNext();
            this.doAction(ifNode, arg);
            TypeInferencer.this.collection = elseContext;
            Node elseNode = node.getLastChild();
            this.doAction(elseNode, arg);
            TypeInferencer.this.collection = (HostCollection)TypeInferencer.this.contexts.pop();
            root.mergeElseIf(ifContext, elseContext);
            return arg;
        }

        public Object processCatchScopeNode(Node node, Object arg) {
            Node n1 = node.getFirstChild();
            TypeInferencer.this.contexts.push(TypeInferencer.this.collection);
            TypeInferencer.this.collection = new HostCollection(TypeInferencer.this.collection.getParent());
            String name = n1.getString();
            TypeInferencer.this.collection.setReference(name, new UnknownReference(name, true));
            node.getFirstChild();
            this.processScriptNode(node, arg);
            HostCollection pop = (HostCollection)TypeInferencer.this.contexts.pop();
            if (node.getPosition() >= this.position) {
                throw new PositionReachedException(null);
            }
            TypeInferencer.this.collection = pop;
            return arg;
        }

        public Object processLoop(Node node, Object arg) {
            TypeInferencer.this.contexts.push(TypeInferencer.this.collection);
            TypeInferencer.this.collection = new HostCollection(TypeInferencer.this.collection);
            this.processScriptNode(node, arg);
            HostCollection pop = (HostCollection)TypeInferencer.this.contexts.pop();
            pop.mergeIf(TypeInferencer.this.collection);
            TypeInferencer.this.collection = pop;
            return arg;
        }

        private Object processIf(Object arg, Node.Jump jm) {
            TypeInferencer.this.contexts.push(TypeInferencer.this.collection);
            TypeInferencer.this.collection = new HostCollection(TypeInferencer.this.collection);
            HostCollection ifCollection = null;
            Node n = jm;
            while (n != null) {
                HostCollection elseCollection;
                Node cm;
                this.doAction(n, arg);
                n = n.getNext();
                if (!(n instanceof Node.Jump) || (cm = n).getType() != 5) continue;
                HostCollection pop = (HostCollection)TypeInferencer.this.contexts.peek();
                ifCollection = TypeInferencer.this.collection;
                TypeInferencer.this.collection = elseCollection = new HostCollection(pop);
            }
            HostCollection pop = (HostCollection)TypeInferencer.this.contexts.pop();
            if (ifCollection == null) {
                pop.mergeIf(TypeInferencer.this.collection);
            } else {
                pop.mergeElseIf(TypeInferencer.this.collection, ifCollection);
            }
            TypeInferencer.this.collection = pop;
            return arg;
        }

        public Object processFunction(Node node, Object arg) {
            ScriptOrFnNode oldC = this.context;
            String sn = node.getString();
            if (sn.length() > 0) {
                int a = 0;
                while (a < this.context.getFunctionCount()) {
                    FunctionNode functionNode = this.context.getFunctionNode(a);
                    String name = functionNode.getFunctionName();
                    if (name != null && name.equals(sn)) {
                        this.context = functionNode;
                        this.internalProcessFunctionNode(arg, functionNode, node);
                        break;
                    }
                    ++a;
                }
            } else {
                int index = node.getIntProp(1, -1);
                FunctionNode functionNode = this.context.getFunctionNode(index);
                this.context = functionNode;
                this.internalProcessFunctionNode(arg, functionNode, node);
            }
            this.context = oldC;
            return null;
        }

        private void internalProcessFunctionNode(Object arg, FunctionNode functionNode, Node function) {
            if (functionNode.getEncodedSourceStart() >= this.position) {
                throw new PositionReachedException(this.context);
            }
            HostCollection parent = TypeInferencer.this.collection;
            this.functionContexts.addLast(TypeInferencer.this.collection);
            TypeInferencer.this.contexts.push(parent);
            TypeInferencer.this.collection = new HostCollection((HostCollection)this.functionContexts.getFirst());
            TypeInferencer.this.collection.setType(1);
            TypeInferencer.this.collection.setName(functionNode.getFunctionName());
            String comment = functionNode.getFunctionComments();
            Map paramTypes = this.parseComment(comment);
            int am = 0;
            while (am < functionNode.getParamCount()) {
                String paramOrVarName = functionNode.getParamOrVarName(am);
                String type = (String)paramTypes.get(paramOrVarName);
                IReference reference = null;
                if (type != null) {
                    reference = ReferenceFactory.createTypeReference(paramOrVarName, type, TypeInferencer.this.cs);
                }
                if (reference == null) {
                    reference = new UnknownReference(paramOrVarName, false);
                }
                reference.setLocationInformation(TypeInferencer.this.module, functionNode.nameStart, functionNode.getFunctionName().length());
                TypeInferencer.this.collection.write(paramOrVarName, reference);
                ++am;
            }
            this.processScriptNode(functionNode.getFirstChild(), arg);
            TypeInferencer.this.functionNodes.put(new Integer(functionNode.getEncodedSourceStart()), TypeInferencer.this.collection);
            if (functionNode.getEncodedSourceEnd() >= this.position) {
                throw new PositionReachedException(functionNode);
            }
            HostCollection pop = (HostCollection)TypeInferencer.this.contexts.pop();
            Iterator i = TypeInferencer.this.collection.getReferences().values().iterator();
            while (i.hasNext()) {
                IReference rf;
                Object o = i.next();
                if (!(o instanceof IReference) || (rf = (IReference)o).isLocal()) continue;
                pop.write(rf.getName(), rf);
            }
            pop.recordFunction(function, TypeInferencer.this.collection);
            TypeInferencer.this.collection = pop;
            this.functionContexts.removeLast();
        }

        private Map parseComment(String comment) {
            if (comment == null) {
                return Collections.EMPTY_MAP;
            }
            HashMap<String, String> map = new HashMap<String, String>();
            int paramIndex = comment.indexOf("@param");
            while (paramIndex != -1) {
                int endLineIndex = comment.indexOf("\n", paramIndex);
                StringTokenizer st = new StringTokenizer(comment.substring(paramIndex + 6, endLineIndex));
                String type = "";
                while (st.hasMoreTokens()) {
                    String token = st.nextToken();
                    if (token.startsWith("{") && token.endsWith("}")) {
                        type = token.substring(1, token.length() - 1);
                        continue;
                    }
                    map.put(token, type);
                    break;
                }
                paramIndex = comment.indexOf("@param", endLineIndex);
            }
            return map;
        }

        public Object processVarDeclaration(Node node, Object arg) {
            Node firstChild = node.getFirstChild();
            Object processScriptNode = this.processScriptNode(node, arg);
            while (firstChild != null) {
                String key = TypeInferencer.getKey(firstChild);
                IReference evaluateReference = TypeInferencer.this.evaluateReference(key, firstChild.getFirstChild(), TypeInferencer.this.cs);
                if (evaluateReference == null) {
                    evaluateReference = new UnknownReference(key, false);
                }
                evaluateReference.setLocationInformation(TypeInferencer.this.module, firstChild.getPosition() + 1, key.length());
                evaluateReference.setLocal(true);
                TypeInferencer.this.collection.write(key, evaluateReference);
                firstChild = firstChild.getNext();
            }
            return processScriptNode;
        }

        public Object processSetPropNode(Node node, Object arg) {
            Node obj = node.getFirstChild();
            String objId = TypeInferencer.getObjId(obj);
            if (objId == null) {
                return null;
            }
            Node id = node.getFirstChild().getNext();
            Object processScriptNode = this.processScriptNode(node, arg);
            String fieldId = TypeInferencer.getKey(id);
            this.internalSetProp(node, objId, fieldId);
            return processScriptNode;
        }

        public Object processDelProp(Node node, Object arg) {
            Node firstChild = node.getFirstChild();
            String objId = TypeInferencer.getKey(firstChild);
            if (firstChild.getType() == 48) {
                TypeInferencer.this.collection.recordDelete(objId);
            } else {
                Node id = node.getFirstChild().getNext();
                String fieldId = TypeInferencer.getKey(id);
                IReference queryElement = TypeInferencer.this.collection.queryElement(objId, false);
                if (queryElement != null) {
                    queryElement.recordDelete(fieldId);
                }
            }
            return null;
        }

        private void internalSetProp(Node node, String objId, String fieldId) {
            IReference evaluateReference = TypeInferencer.this.evaluateReference(fieldId, node.getLastChild(), TypeInferencer.this.cs);
            int pos = objId.indexOf(46);
            String rootName = pos == -1 ? objId : objId.substring(0, pos);
            IReference root = TypeInferencer.this.collection.getReferenceNoParentContext(rootName);
            if (root == null) {
                root = new UnknownReference(rootName, true);
                root.setLocationInformation(TypeInferencer.this.module, node.getPosition(), fieldId.length());
                HostCollection parent = TypeInferencer.this.collection.getParent();
                if (parent == null) {
                    TypeInferencer.this.collection.setReference(rootName, root);
                } else {
                    IReference rm = parent.getReference(rootName);
                    if (rm != null) {
                        rm = new CombinedOrReference(rm, root);
                        TypeInferencer.this.collection.setReference(rootName, rm);
                    } else {
                        TypeInferencer.this.collection.setReference(rootName, root);
                    }
                }
            }
            ++pos;
            while (pos != 0) {
                int p1 = objId.indexOf(46, pos);
                String field = p1 != -1 ? objId.substring(pos, p1) : objId.substring(pos);
                IReference child = root.getChild(field, false);
                if (child == null) {
                    child = new UnknownReference(field, true);
                    child.setLocationInformation(TypeInferencer.this.module, node.getPosition(), fieldId.length());
                    root.setChild(field, child);
                }
                root = child;
                pos = p1 + 1;
            }
            TransparentRef transparentRef = new TransparentRef(evaluateReference, node.getLastChild(), fieldId, TypeInferencer.this.module, TypeInferencer.this.cs);
            TypeInferencer.this.collection.addTransparent(transparentRef);
            transparentRef.setLocationInformation(TypeInferencer.this.module, node.getPosition(), fieldId.length());
            if (root.getName().equals("this")) {
                TypeInferencer.this.collection.add(transparentRef.getName(), transparentRef);
            }
            root.setChild(fieldId, transparentRef);
        }

        public Object processLeaveWidth(Node node, Object arg) {
            if (node.getPosition() >= this.position) {
                throw new PositionReachedException(null);
            }
            if (TypeInferencer.this.contexts.isEmpty()) {
                return arg;
            }
            if (!(TypeInferencer.this.contexts.peek() instanceof IReference) && TypeInferencer.this.contexts.peek() != null) {
                return arg;
            }
            IReference to = (IReference)TypeInferencer.this.contexts.pop();
            if (to != null) {
                Map mn = TypeInferencer.this.collection.getReferences();
                Iterator i = mn.keySet().iterator();
                while (i.hasNext()) {
                    String next = (String)i.next();
                    to.setChild(next, (IReference)mn.get(next));
                }
            }
            TypeInferencer.this.collection = (HostCollection)TypeInferencer.this.contexts.pop();
            return null;
        }

        public Object processEnterWidth(Node node, Object arg) {
            Node firstChild = node.getFirstChild();
            if (!(firstChild instanceof Node.StringNode)) {
                TypeInferencer.this.contexts.push(TypeInferencer.this.collection);
                TypeInferencer.this.contexts.push(null);
                return arg;
            }
            TypeInferencer.this.contexts.push(TypeInferencer.this.collection);
            String name = firstChild.getString();
            IReference ref = TypeInferencer.this.collection.queryElement(name, false);
            TypeInferencer.this.contexts.push(ref);
            TypeInferencer.this.collection = new HostCollection(TypeInferencer.this.collection);
            if (ref != null) {
                IReference k;
                Iterator i;
                IReference r = ref.getPrototype(false);
                if (r != null) {
                    AbstractCollection lm = new LinkedHashSet<IReference>();
                    while (r != null && !lm.contains(r)) {
                        lm.add(r);
                        r = r.getPrototype(false);
                    }
                    lm = new LinkedList(lm);
                    Collections.reverse((List)((Object)lm));
                    i = lm.iterator();
                    while (i.hasNext()) {
                        k = (IReference)i.next();
                        Set sm = k.getChilds(false);
                        Iterator i1 = sm.iterator();
                        while (i1.hasNext()) {
                            IReference k1 = (IReference)i1.next();
                            TypeInferencer.this.collection.setReference(k1.getName(), k1);
                        }
                    }
                }
                Set sm = ref.getChilds(false);
                i = sm.iterator();
                while (i.hasNext()) {
                    k = (IReference)i.next();
                    TypeInferencer.this.collection.setReference(k.getName(), k);
                }
            }
            return null;
        }

        public Object processSetNameNode(Node node, Object arg) {
            String key = TypeInferencer.getKey(node.getFirstChild());
            Node lastChild = node.getLastChild();
            Object processScriptNode = this.processScriptNode(node, arg);
            IReference evaluateReference = TypeInferencer.this.evaluateReference(key, lastChild, TypeInferencer.this.cs);
            evaluateReference.setLocationInformation(TypeInferencer.this.module, node.getFirstChild().getPosition() - key.length(), key.length());
            TypeInferencer.this.collection.write(key, evaluateReference);
            return processScriptNode;
        }
    }
}

