/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.javascript.reference.resolvers;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.internal.javascript.reference.resolvers.IReferenceResolver;
import org.eclipse.dltk.internal.javascript.reference.resolvers.IResolvableReference;
import org.eclipse.dltk.internal.javascript.typeinference.HostCollection;
import org.eclipse.dltk.internal.javascript.typeinference.IReference;

public final class ReferenceResolverContext {
    protected ArrayList resolvers = new ArrayList();
    protected ISourceModule module;
    protected Map settings;
    private HostCollection collection;

    public ReferenceResolverContext(ISourceModule module, Map settings) {
        this.module = module;
        this.settings = settings;
    }

    public ISourceModule getModule() {
        return this.module;
    }

    public Map getOptions() {
        return this.settings;
    }

    public boolean resolveLocals() {
        return false;
    }

    public Set resolveGlobals(String id) {
        TreeSet sm = new TreeSet(new Comparator(){

            public int compare(Object o1, Object o2) {
                if (o1 instanceof IReference && o2 instanceof IReference) {
                    return ((IReference)o1).getName().compareToIgnoreCase(((IReference)o2).getName());
                }
                if (o1 instanceof IModelElement && o2 instanceof IReference) {
                    return ((IModelElement)o1).getElementName().compareToIgnoreCase(((IReference)o2).getName());
                }
                if (o1 instanceof IReference && o2 instanceof IModelElement) {
                    return ((IReference)o1).getName().compareToIgnoreCase(((IModelElement)o2).getElementName());
                }
                return 0;
            }
        });
        int a = 0;
        while (a < this.resolvers.size()) {
            IReferenceResolver res = (IReferenceResolver)this.resolvers.get(a);
            Set result = res.resolveGlobals(id);
            Iterator it = result.iterator();
            while (it.hasNext()) {
                sm.remove(it.next());
            }
            sm.addAll(result);
            ++a;
        }
        return sm;
    }

    public void init() {
        int a = 0;
        while (a < this.resolvers.size()) {
            IReferenceResolver res = (IReferenceResolver)this.resolvers.get(a);
            res.init(this);
            ++a;
        }
    }

    public Set resolveChilds(IResolvableReference abstractCallResultReference) {
        int a = 0;
        while (a < this.resolvers.size()) {
            IReferenceResolver res = (IReferenceResolver)this.resolvers.get(a);
            Set result = res.getChilds(abstractCallResultReference);
            if (result != null && !result.isEmpty()) {
                return result;
            }
            ++a;
        }
        return new HashSet();
    }

    public void processCall(String call, String objId) {
        int a = 0;
        while (a < this.resolvers.size()) {
            IReferenceResolver res = (IReferenceResolver)this.resolvers.get(a);
            res.processCall(call, objId);
            ++a;
        }
    }

    public HostCollection getHostCollection() {
        return this.collection;
    }

    public void setHostCollection(HostCollection collection) {
        this.collection = collection;
    }
}

