/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.util.internal.httpproxy.core;

import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.actf.util.httpproxy.core.IBufferRange;
import org.eclipse.actf.util.internal.httpproxy.core.HTTPHeader;
import org.eclipse.actf.util.internal.httpproxy.core.HTTPMessageBuffer;

public final class HeaderInBuffer
extends HTTPHeader {
    private HTTPMessageBuffer fBuffer;
    private IBufferRange fName = null;
    private IBufferRange fValue = null;
    private byte[] fReplacedValue = null;

    public void init(HTTPMessageBuffer hTTPMessageBuffer, IBufferRange iBufferRange, IBufferRange iBufferRange2) {
        this.fBuffer = hTTPMessageBuffer;
        this.fName = iBufferRange;
        this.fValue = iBufferRange2;
        this.fReplacedValue = null;
    }

    public void reset() {
        this.fName = null;
        this.fValue = null;
        this.fReplacedValue = null;
    }

    public IBufferRange getNameAsBufferRange() {
        return this.fName;
    }

    public IBufferRange getValueAsBufferRange() {
        return this.fValue;
    }

    public boolean isFieldNameEqualsTo(byte[] byArray) {
        return this.fBuffer.equalsIgnoreCase(this.fName, byArray);
    }

    public boolean isFieldValueEqualsTo(byte[] byArray) {
        return this.fBuffer.equals(this.fValue, byArray);
    }

    public byte[] getName() {
        return this.fBuffer.getAsBytes(this.fName);
    }

    public byte[] getValue() {
        return this.fBuffer.getAsBytes(this.fValue);
    }

    public void setValue(byte[] byArray) {
        this.fValue = null;
        this.fReplacedValue = byArray;
    }

    protected void write(OutputStream outputStream) throws IOException {
        this.fBuffer.writeTo(outputStream, this.fName);
        this.writeHeaderSeparator(outputStream);
        if (this.fValue != null) {
            this.fBuffer.writeTo(outputStream, this.fValue);
        } else if (this.fReplacedValue != null) {
            outputStream.write(this.fReplacedValue);
        }
    }
}

